function rangeSlidify(element){
	var input = document.createElement('input');
	input.setAttribute('type', 'range');
	if(input.type !== 'text'){
		var parent = element.htmlElement.parentNode;
		var rangeSlider = document.createElement('input');
		rangeSlider.id = element.htmlElement.id;
		rangeSlider.value = 5;
		rangeSlider.setAttribute('type', 'range');
		rangeSlider.setAttribute('min', element.htmlElement.getAttribute('data-min'));
		rangeSlider.setAttribute('max', element.htmlElement.getAttribute('data-max'));
		rangeSlider.setAttribute('step', element.htmlElement.getAttribute('data-step'));
		parent.replaceChild(rangeSlider, element.htmlElement);
		
		element.htmlElement = rangeSlider;
		element.addEvent('input');
		
	}
}

function HtmlObject(element){
	var self = this;
	self.htmlElement = element;
	self.active = function(){
		self.htmlElement.classList.add('active');
	};	
	self.inactive = function(){
		self.htmlElement.classList.remove('active');
	};
	self.standardEvent = 'click';
	self.handleEvent = function(){
		console.log('Handling an event for ' + self.htmlElement);
	};
	self.addEvent = function(event){
		var event = event || 'click';
		self.htmlElement.addEventListener(event, self.handleEvent, false);
	};
}