"use strict"; 
var lang = new Lang();
var firstUse = true;
var audio = new Audio();
var selector = new HtmlObject(document.getElementById('selector'));
var menuBtn = new HtmlObject(document.getElementById('menu_Btn'));
var sliderVis = document.getElementById('slider-vis');

var mainScene = document.getElementById('main');
var timedFor = document.getElementById('timedFor');
var minutesLeft = document.getElementById('minutesLeft');
var appVersion = document.getElementById('app-version');
var greetings = document.getElementById('greetings');
var alarmTime = 0;
var timerActive = false;
var currentAlarmId = 0;



audio.mozAudioChannelType = 'content';
audio.src = 'media/sleep.mp3';

selector.handleEvent = selectorAction;
selector.addEvent('change');
menuBtn.handleEvent = callInfo;
menuBtn.addEvent('click', callInfo);
timedFor.addEventListener('click', setAlarm, false);

if(navigator.mozSetMessageHandler){
	navigator.mozSetMessageHandler("alarm", function(mozAlarm){
		if(mozAlarm.id === currentAlarmId){
			navigator.mozApps.getSelf().onsuccess = function(evt) {
				var app = evt.target.result;
				app.launch();
				console.log('Alarm received, letting Music sleep');
				audio.play();
				clearAlarm();
			};
		}
	});
}
else{
	console.log('mozSetMessageHandler not available.');
}

function callInfo(){
	menuBtn.htmlElement.classList.toggle('active');
	info.classList.toggle('slideIn');
}

function countdownMinutes(){
  if(timerActive === true){
		minutesLeft.innerHTML = displayTime(alarmTime,1);
		if(Math.round((alarmTime.getTime() - Date.now())/60000) > 0){
			var timeout = window.setTimeout(countdownMinutes, 60000);
		}
		else{
			timerActive = false;
			console.log('timer beendet');
		}
  }
}

function displayTime(date,role){
	var now = date || new Date();
	if(role === 0){ //display Time
		var hours = (now.getHours().toString().length == 1) ? '0' + now.getHours().toString() : now.getHours().toString();
		var minutes = (now.getMinutes().toString().length == 1) ? '0' + now.getMinutes().toString() : now.getMinutes().toString();
		return hours + ':' + minutes;
	}
	else if(role == 1){ //display minutes left
		return Math.round((now.getTime() - Date.now())/60000) +  '&#8239;min';
	}
}

function selectorAction(){
	if(timerActive !== true){
		var currentDate = new Date();
		var value = parseInt(selector.htmlElement.value);
		currentDate.setTime(currentDate.getTime() + (value*60000));
		timedFor.innerHTML = displayTime(currentDate,0);
		minutesLeft.innerHTML = displayTime(currentDate,1);
		alarmTime = currentDate;		
		if(value > 0){
			sliderVis.style.width = (value+20)/1.4 + "%";
		}
		else{sliderVis.style.width = "14%";}
		
	}
}

function setAlarm(){
	if(timerActive === false){
		if(timedFor.innerHTML.length == 5){
			clearAlarm();
			timerActive = true;
			countdownMinutes();
			console.log("Trying to schedule alarm for " + alarmTime);
			
			if(navigator.mozAlarms){
				var alarmRequest = navigator.mozAlarms.add(alarmTime, "ignoreTimezone", { mydata: "0" });
				alarmRequest.onsuccess = function(){
					currentAlarmId = this.result;
					console.log('The alarm with ID ' + currentAlarmId + ' has been scheduled for ' + alarmTime);
				};
				alarmRequest.onerror = function(){ 
					console.log("An error occurred: " + this.error.name);
				};
				timedFor.className = 'active';
				mainScene.classList.toggle('active');
				selector.htmlElement.disabled = true;
			}
			else{
				
				timedFor.className = 'warn';
				timedFor.addEventListener("animationend", function(){timedFor.className = '';}, false);
			}
		}
		else{
			timedFor.className = 'warn';
			timedFor.addEventListener("animationend", function(){timedFor.className = '';}, false);
		}
	}
	else{clearAlarm();}
}


function clearAlarm(){
	console.log("clearing Alarm with ID " + currentAlarmId);
	timerActive = false;
	timedFor.className = '';
	mainScene.classList.remove('active');
	selector.htmlElement.disabled = false;
	if(navigator.mozAlarms){
		navigator.mozAlarms.remove(currentAlarmId);
	}
	else{
		console.log('mozAlarms not available');
	}
}

function checkFirstUse(){
	if(localStorage.firstUse){
		firstUse = false;
	}
	else{
		callInfo();
		localStorage.setItem('firstUse', false);
	}
}

function init(){
	rangeSlidify(selector);
	selectorAction();
	lang.getText(appVersion, 'app-version');
	lang.getText(greetings, 'greetings');
	checkFirstUse();
}

init();


