"use strict";
function Lang(){
	this.locale = function getLocale(){
		var locale = navigator.language.substr(0,2) || 'en';
		return locale;
	}

	this.getText = function getText(element, langString){
		element.innerHTML = this.translation[langString][this.locale()];
	}

	this.translation = {
		"app-version":{
			"en": "Music Timer v1.10",
			"de": "Music Timer v1.10"
		},
		"greetings": {
			"en": "<p><strong>Thank You</strong> <br />for using Music Timer.<br />This app is brought to You for free, without collecting any data.<br /><br /><strong>Do You like it?</strong><br /><a href='https://marketplace.firefox.com/app/music-timer/ratings/add' target='_blank'>&#10032; Rate it at the Marketplace</a>, show some love!<br /><br /><strong>Think I could do better?</strong><br /><a href='mailto:app@qomisch.de'>&#9993; Write an e-mail</a>, tell me how!</p>", 
			"de": "<p><strong>Vielen Dank,</strong> <br />dass Sie Music Timer benutzen.<br />Diese App ist für Sie kostenlos und sammelt keinerlei Daten.<br /><br /><strong>Mögen Sie Music Timer?</strong><br /><a href='https://marketplace.firefox.com/app/music-timer/ratings/add' target='_blank'>&#10032; Geben Sie eine Bewertung ab</a>!<br /><br /><strong>Könnte besser sein?</strong><br /><a href='mailto:app@qomisch.de'>&#9993; Schreiben Sie eine E-Mail</a>, sagen sie mir wie!</p>"
		}
	};
}