// DOMContentLoaded is fired once the document has been loaded and parsed,
// but without waiting for other external resources to load (css/images/etc)
// That makes the app more responsive and perceived as faster.
// https://developer.mozilla.org/Web/Reference/Events/DOMContentLoaded
window.addEventListener('DOMContentLoaded', function() {

  // We'll ask the browser to use strict code to help us catch errors earlier.
  // https://developer.mozilla.org/Web/JavaScript/Reference/Functions_and_function_scope/Strict_mode
  'use strict';

  var translate = navigator.mozL10n.get;

  // We want to wait until the localisations library has loaded all the strings.
  // So we'll tell it to let us know once it's ready.
  navigator.mozL10n.once(start);

  // ---

  function start() {
    var audioCtx = new window.AudioContext();
    var source;
    var stream;
    var analyser = audioCtx.createAnalyser();
    var lacoul = 120 ;
    analyser.minDecibels = -90;
    analyser.maxDecibels = -10;
    analyser.smoothingTimeConstant = 1.0;
    
    var lemode = "music" ;
    var lafreq = 20 ;
    var le_rendu ;
    var ok_ecran = true ;
    var ok_flash = true ;
    
    GerFlash.checkCameras();
//    setTimeout(function(){ GerFlash.on() } , 1000 );
    //gefla.allum();
    //console.log(gefla);
    
    if (navigator.mozGetUserMedia) {
      navigator.mozGetUserMedia ( { audio: true },
        function(stream) {     // success
          source = audioCtx.createMediaStreamSource(stream);
          source.connect(analyser);
          active_mode();
        },
        function(err) {         // error
          console.log('Error : ' + err);
        } 
       );   
    } else {
      console.log('getUserMedia not supported on your browser ...');
    }

    function active_mode(){
      switch(lemode){
        case 'strob' : strob_rendu(); break;
        case 'music' : 
        default : rendu();
      }
    }
    
    function rendu() {
      analyser.fftSize = 2048;
      var bufferLength = analyser.fftSize;
      var buff_data = new Uint8Array(bufferLength);

      var min = 64 ;
      var max = 64 ;
      var pct = 50 ;
      var tot = 0 ;

      function aff() {
        analyser.getByteTimeDomainData(buff_data);
        tot = 0 ;
        for(var i = 0; i < bufferLength; i++)
          if(buff_data[i]>tot)    tot = buff_data[i] ;

        if(tot<min){
          min += (tot - min)*0.1 ;
          pct = 0 ;
        }else if(tot>max){
          max += (tot - max)*0.1 ;
          pct = 100 ;
        }else{
          min += (tot - min)*0.1 ;
          max += (tot - max)*0.1 ;
          pct = Math.round((tot - min)/(max - min)*100) ;
        }

        if(ok_ecran)
          document.body.style.backgroundColor='hsl('+lacoul+', '+pct+'%, '+(pct/2)+'%)';
        //      console.log(tot,pct,min,max);

        //      setTimeout(aff,100);
        le_rendu = requestAnimationFrame(aff);
        if(ok_flash)
          if(pct>=50)
            GerFlash.on();
          else
            GerFlash.off();
      };
      aff();
    }
    
    
    function strob_rendu() {
/*        lafreq = parseInt(la_freq.value);
        document.body.style.backgroundColor='hsl('+lacoul+', 100%, '+(new Date().getMilliseconds()%lafreq>(lafreq/2)?50:0)+'%)';
        le_rendu = requestAnimationFrame(strob_rendu);*/
        if(lemode!='strob') return ;
        if(ok_ecran)
          document.body.style.backgroundColor='hsl('+lacoul+', 100%, 0%)';
        if(ok_flash)
          GerFlash.off();
        setTimeout(strob_rendu_b,lafreq*9)
    }
    
    function strob_rendu_b() {
/*        lafreq = parseInt(la_freq.value);
        document.body.style.backgroundColor='hsl('+lacoul+', 100%, '+(new Date().getMilliseconds()%lafreq>(lafreq/2)?50:0)+'%)';
        le_rendu = requestAnimationFrame(strob_rendu);*/
        if(lemode!='strob') return ;
        if(ok_ecran)
          document.body.style.backgroundColor='hsl('+lacoul+', 100%, 50%)';
        if(ok_flash)
          GerFlash.on();
        setTimeout(strob_rendu,lafreq)
    }
    
    la_couleur.addEventListener('change', function() {
      lacoul = parseInt(la_couleur.value);
        document.body.style.backgroundColor='hsl('+lacoul+', '+pct+'%, '+(pct/2)+'%)';
    });
    la_freq.addEventListener('change', function() {
      lafreq = parseInt(la_freq.value);
    });
    flash.addEventListener('change', function() {
      ok_flash = flash.checked;
      if(!ok_flash)
          GerFlash.off();
    });
    ecran.addEventListener('change', function() {
      ok_ecran = ecran.checked;
      if(!ok_ecran)
          document.body.style.backgroundColor='hsl('+lacoul+', 50%, 25%)';
    });
    le_mode.addEventListener('change', function() {
      window.cancelAnimationFrame(le_rendu);
      lemode = le_mode.value ;
      active_mode();
    });
    
    omenu.addEventListener('click',function(){
      omenu.style.display = 'none';
      menu.style.display = 'block';
    });
    qmenu.addEventListener('click',function(){
      omenu.style.display = 'block';
      menu.style.display = 'none';
    });
    
    
  }
});

var GerFlash = (function() {
  var GerFlash = {} ;
  GerFlash.camera = null;
  
  GerFlash.on = function() {
    this.camera.flashMode = 'torch';
  };

  GerFlash.off = function() {
    this.camera.flashMode = 'off';
  };
  
  GerFlash.checkCameras = function() {
    if(navigator.mozCameras==undefined) {
      this.camera = {flashMode:""};
      return ;
    }
    var deviceCameras = navigator.mozCameras.getListOfCameras();
    var cameras = navigator.mozCameras;
    var that = this ;
    for(var i = 0; i < deviceCameras.length; i++) {
      cameras.getCamera(cameras[i], null, function(currentCamera) {
        var flashModes = currentCamera.capabilities.flashModes;
        if(flashModes && flashModes.indexOf('torch') >= 0) {
          that.camera = currentCamera;
        } else {
          console.log('Pas de flash');
        }
      });
    }
  };
  
  GerFlash.releaseCamera = function() {
    if (this.camera) this.camera.release(null);
  };
  
  return GerFlash ;
}());

window.addEventListener('blur', function() {
  GerFlash.releaseCamera();
});