$(document).ready(function(){
			
	get_battery_indicator();

});

function get_battery_indicator()
{	
	var battery = navigator.battery || navigator.mozBattery || navigator.webkitBattery;

	var	level = battery.level * 100;

	/* Заполняем полосу заряда */
	$('.charge').css('width', Math.round(level) + '%');
		
	/* Указываем процент заряда */
	$('#battery_level').text(Math.round(level) + '%');
		
	/* Если идет зарядка */
	if(battery.charging)
	{
		/* Задаем зеленый цвет полосе заряда */
		$('.charge').css('background', '#008000');
			
		/* Добавляем иконку */
		$('.charge').html('<span class="icon-power"></span>');
			
		/* Указатели заряжается/разряжается */
		$('#battery_status_charged').removeClass('display_status_0');
		$('#battery_status_discharges').addClass('display_status_0');
		
		/* Прячем статус, если заряд равен 100% */
		if(level == 100)
		{
			$('#h-status').addClass('display_status_0');
		}
	}
	else
	{
		/* Удаляем иконку */ 
		$('.icon-power').remove();
			
		/* Указатели заряжается/разряжается */
		$('#battery_status_charged').addClass('display_status_0');
		$('#battery_status_discharges').removeClass('display_status_0');
			
		/* Время ожидания */
		discharge_standby = discharge('standby', level);
		discharge_standby_time = s2t(discharge_standby);		
		$('#battery_time_standby_h').html(discharge_standby_time.h);
		$('#battery_time_standby_m').html(discharge_standby_time.m);
		
		/* Разговор */
		discharge_standby = discharge('call', level);
		discharge_standby_time = s2t(discharge_standby);
		$('#battery_time_call_h').html(discharge_standby_time.h);
		$('#battery_time_call_m').html(discharge_standby_time.m);
		
		/* Прослушивание музыки */
		discharge_standby = discharge('music', level);
		discharge_standby_time = s2t(discharge_standby);
		$('#battery_time_music_h').html(discharge_standby_time.h);
		$('#battery_time_music_m').html(discharge_standby_time.m);
		
		/* Воспроизвидение видео */
		discharge_standby = discharge('video', level);
		discharge_standby_time = s2t(discharge_standby);
		$('#battery_time_video_h').html(discharge_standby_time.h);
		$('#battery_time_video_m').html(discharge_standby_time.m);
		
		/* Игры */
		discharge_standby = discharge('games', level);
		discharge_standby_time = s2t(discharge_standby);
		$('#battery_time_games_h').html(discharge_standby_time.h);
		$('#battery_time_games_m').html(discharge_standby_time.m);
		
		/* Серфинг */
		discharge_standby = discharge('web', level);
		discharge_standby_time = s2t(discharge_standby);
		$('#battery_time_websurf_h').html(discharge_standby_time.h);
		$('#battery_time_websurf_m').html(discharge_standby_time.m);
		
		/* GPS */
		discharge_standby = discharge('gps', level);
		discharge_standby_time = s2t(discharge_standby);
		$('#battery_time_gps_h').html(discharge_standby_time.h);
		$('#battery_time_gps_m').html(discharge_standby_time.m);
		
	}
		
	/* Меняем цвет полосы, если заряда < 20% */
	if(level <= 20)
	{
		$('.charge').css('background', '#FF0000');
	}
		
	/* Меняем цвет полосы, если заряда < 75% */
	else if(level <= 75)
	{
		$('.charge').css('background', '#FFD800');
	}
		
	/* Меняем цвет полосы, если заряда > 75% */
	else
	{
		$('.charge').css('background', '#008000');
	}
	
	battery.addEventListener('chargingchange', get_battery_indicator);

	battery.addEventListener('levelchange', get_battery_indicator);

	battery.addEventListener('chargingtimechange', get_battery_indicator); 

	battery.addEventListener('dischargingtimechange', get_battery_indicator);
}

/* Функция для подсчета времени разряда */	
function discharge(app, level)
{
	switch (app)
	{
		case 'standby':
		result = Math.floor((level*10) / 0.5);
		break;
		
		case 'call':
		result = Math.floor((level*10) / 3);
		break;

		case 'music':
		result = Math.floor((level*10) / 2);
		break;
		
		case 'video':
		result = Math.floor((level*10) / 3.5);
		break;
		
		case 'web':
		result = Math.floor((level*10) / 3);
		break;
		
		case 'game':
		result = Math.floor((level*10) / 4);
		break;
		
		case 'gps':
		result = Math.floor((level*10) / 4);
		break;
		
		default:
		result = Math.floor((level*10) / 9);
		break;
	}
	
	return result * 60;
}