$(document).ready(function() {
	
	var devicePixelRatio = window.devicePixelRatio || 1;
	
	dpi_x = document.getElementById('screen_diagonal_sys').offsetWidth * devicePixelRatio;
	dpi_y = document.getElementById('screen_diagonal_sys').offsetHeight * devicePixelRatio;
	
	var width_in = screen.width / dpi_x;
	var height_in = screen.height / dpi_y;
	
	$('#screen_diagonal').text('~' + Math.round(10*Math.sqrt(width_in * width_in + height_in * height_in))/10 + '"');

	/* Определяем высоту экрана */
    $('#screen_height').text(screen.height + 'px');
    
    /* Определяем ширину */
    $('#screen_width').text(screen.width + 'px');
    
    /* Опеределяем глубину цвета */
    $('#screen_depth').text(screen.colorDepth);
    
    /* Определяем количество пикселей */
    $('#screen_px').text(screen.height * screen.width);
    
    /* Определяем поддержку cookies */
	if(typeof(navigator.cookieEnabled) == 'boolean')
	{
		$('#cookie_enable').html((navigator.cookieEnabled ? '<span class="icon-true true"></span>' : '<span class="icon-false false"></span>'));
	}
	else if(typeof(navigator.cookieEnabled) == 'function')
	{
		$('#cookie_enable').html((navigator.cookieEnabled() ? '<span class="icon-true true"></span>' : '<span class="icon-false false"></span>'));
	}
	
	/* Определяем поддержку приватности */
	if(navigator.doNotTrack)
	{
		$('#do_not_track').html((navigator.doNotTrack ? '<span class="icon-true true"></span>' : '<span class="icon-false false"></span>'));
	}
	
	/* Определяем поддержку java */
	if(typeof(navigator.javaEnabled) == 'boolean')
	{
		$('#java_enable').html((navigator.javaEnabled ? '<span class="icon-true true"></span>' : '<span class="icon-false false"></span>'));
	}
	else if(typeof(navigator.javaEnabled) == 'function')
	{
		$('#java_enable').html((navigator.javaEnabled() ? '<span class="icon-true true"></span>' : '<span class="icon-false false"></span>'));
	}
	
	/* Определяем поддержку vibro */
	if(typeof(navigator.vibrate) == 'function')
	{
		$('#vibro_enable').html('<span class="icon-true true"></span>');
	}
	
	/* Определяем поддержку локального хранилища */
    if(typeof(Storage) !== 'undefined')
    {
		$('#localstorage_enable').html('<span class="icon-true true"></span>');
	}
	else
	{
		$('#localstorage_enable').html('<span class="icon-false false"></span>');
	}
	
	/* Определяем поддержку WebGL */
	if(window.WebGLRenderingContext)
	{
		$('#webgl_enable').html('<span class="icon-true true"></span>');
	}
	else
	{
		$('#webgl_enable').html('<span class="icon-false false"></span>');
	}
	
	/* Определяем поддержку Canvas */
	if(Canvas())
	{
		$('#canvas_enable').html('<span class="icon-true true"></span>');
	}
	else
	{
		$('#canvas_enable').html('<span class="icon-false false"></span>');
	}
    
});

/* Тестирем canvas */
function Canvas()
{
  var elem = document.createElement('canvas');
  return !!(elem.getContext && elem.getContext('2d'));
}

/* Тестируем WebGL */
function WebGL()
{
  return window.WebGLRenderingContext ? true : false;
}