$(document).ready(function(){
	
	/* Получаем данные */
	network();
	
	/* Запускаем тест скорости */
	$("#speedtest-button").click(function()
	{
		/* Запускаем тест */
		SpeedTest();
		
		/* Прячем кнопку */
		$('#speedtest-button').addClass('display_status_0');
		
		/* Показываем блок для результатов */
		$('#speedtest').removeClass('display_status_0');
		
		/* Добавляем анимацию загрузки  */
		$('#speedtest_result_bps').html('<progress></progress>');
        $('#speedtest_result_kbps').html('<progress></progress>');
        $('#speedtest_result_mbps').html('<progress></progress>');
	});
	    
});

/* Network JS */
function network()
{
	/* Проверяем есть ли интернет-соединение */
	if (navigator.onLine)
	{
		/* Соединяемся с сервером */
		$.ajax({
			crossDomain: true,
			type: 'GET',
			async:true,
			url: 'http://api.myfirefoxos.ru/device/network.php?callback=?',
			dataType: 'jsonp',                
			jsonpCallback: 'mydevice',
			success : function(data)
			{
				/* Прописываем IP */
				$('#network_ip').text(data.ip);
				
				/* Прописываем страну */
				$('#network_country').text(data.country);
				
				/* Прописываем провайдера */
				$('#network_provider').text(data.provider);

			},
			error: function (xhr, textStatus)
			{
				/* При ошибке указываем - */
				$('#network_ip').text('-');
				$('#network_ua').text('-');
				$('#network_country').text('-');
				$('#network_provider').text('-');
			}
		}); 
	}	
	else
	{
		/* Если нет интернет соединения, прописываем - */
		$('#network_ip').text('Offline');
		$('#network_ua').text('Offline');
		$('#network_country').text('-');
		$('#network_provider').text('-');
		
		/* Прячем кнопку теста скорости */
		$('#speedtest-button').addClass('display_status_0');
	}
}

function SpeedTest()
{
	var FileLink = 'http://api.myfirefoxos.ru/device/firefox.jpg'; 
	var FileSize = 198804;
    var StartTime, EndTime;
    var Download = new Image();

	/* Запускаем загрузку */
    Download.onload = function ()
    {
		/* Засекаем время */
        EndTime = (new Date()).getTime();
        
        /* Обрабатываем и выводим результаты */
        ShowResult();
    }
    
    Download.onerror = function (err, msg)
    {
		/* Если произошла ошибка */
		alert('Error!');
		
		$('#speedtest-button').removeClass('display_status_0');
		$('#speedtest').addClass('display_status_0');
    }
    
    StartTime = (new Date()).getTime();
    
    var CacheBuster = "?nnn=" + StartTime;
    
    Download.src = FileLink + CacheBuster;
    
    function ShowResult()
    {
        var Duration = (EndTime - StartTime) / 1000;
        var BitsLoaded = FileSize * 8;
        var speedBps = (BitsLoaded / Duration).toFixed(2);
        var speedKbps = (speedBps / 1024).toFixed(2);
        var speedMbps = (speedKbps / 1024).toFixed(2);
        
        $('#speedtest_result_bps').html(speedBps);
        $('#speedtest_result_kbps').html(speedKbps);
        $('#speedtest_result_mbps').html(speedMbps);

        $('#speedtest-button').removeClass('display_status_0');
    }
}