﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#addPaymentDay', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                //init the ShiftColorsSelector
                InitColorsSelector($("#addPaymentDay ol.ShiftColorsSelector"));

                $(this).data("loaded", true);
            }

            //reset the form
            $("#addPaymentDay form")[0].reset();
            $("#addPaymentDay #PaymentType").trigger("change"); // fix "select" bug in IOS4

            // select a default color
            $("#addPaymentDay ol.ShiftColorsSelector li.selected").removeClass("selected");
            $("#addPaymentDay ol.ShiftColorsSelector li[data-color='#bed98c']").trigger("tap"); 

            //check if EDIT MODE
            var editPaymentDayId = sessionStorage.getItem("EditPaymentDayId");
            if (editPaymentDayId != null) {
                sessionStorage.removeItem("EditPaymentDayId");

                LoadFormData(editPaymentDayId);

                //show the edit button
                $("#addPaymentDay #btnEditPaymentDay").data("payment-day-id", editPaymentDayId);
                $("#addPaymentDay #btnAddPaymentDay").hide();
                $("#addPaymentDay .info").hide();

                //check if this month salary is already recorded in DB (and the user can't edit shifts/paymentDays anymore)
                var IsMonthSalaryInDB = sessionStorage.getItem("IsMonthSalaryInDB");
                if (IsMonthSalaryInDB == "true") {
                    //hide all edit buttons and delete button
                    $("#addPaymentDay #btnEditPaymentDay,#addPaymentDay #btnDeletePaymentDay").hide();
                }
                else {
                    //show all edit buttons and delete button
                    $("#addPaymentDay #btnEditPaymentDay,#addPaymentDay #btnDeletePaymentDay").show();
                }
            }
            //ADD MODE
            else {
                //show the add button
                $("#addPaymentDay #btnEditPaymentDay").hide();
                $("#addPaymentDay #btnAddPaymentDay").show();
                $("#addPaymentDay .info").show();
                $("#addPaymentDay #btnDeletePaymentDay").hide();

                SetCurrentDate();

                //add "mobiscroll" plugin to show date picker
                $("#addPaymentDay #Date").mobiscroll().date(mobiscrollDateOptions);

                //update the values of the native date selectors (iOS only)
                UpdateNativeDateSelectors();
            }

            GetCurrencyName();

            //Daily Salary
            var dailySalary = localStorage.getItem("DailySalary");
            $("#addPaymentDay #userDailySalary").html(dailySalary);

            //if ADD MODE
            if ($("#addPaymentDay #btnAddPaymentDay:visible").length > 0) {
                $("#addPaymentDay #Money").val(dailySalary);
            }
        }
    });

    $("#jqt").on("change", "#addPaymentDay #PaymentType", function () {
        var selectedType = $(this).val();

        //if the user select "Other" in the DeductionType options
        if (selectedType == "Other") {
            $("#addPaymentDay #Name").val("");
            $("#addPaymentDay #paymentNameRow").show();
        }
        else if (selectedType != "--Select--") {
            $("#addPaymentDay #Name").val(selectedType);
            $("#addPaymentDay #paymentNameRow").hide();
        }
        else {
            $("#addPaymentDay #Name").val("");
            $("#addPaymentDay #paymentNameRow").hide();
        }

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedType);
    });

    //when click on Delete PaymentDay - show Confirm Dialog
    $("#jqt").on("tap", "#addPaymentDay #btnDeletePaymentDay", function () {
        showDialog("<div class='title'>Delete Pay<span class='close'>X</span></div><div class='content'>Do you want to delete this full day pay?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "DeletePaymentDayDialog");
    });
    $("#jqt").on("tap", "#addPaymentDay #DeletePaymentDayDialog .confirm", function () {
        showLoading();

        var paymentDayId = $("#addPaymentDay #btnEditPaymentDay").data("payment-day-id");

        //Invoke AJAX to delete the paymentDay
        $.post(pathPrefix + "PaymentDays/DeletePaymentDay", { "PaymentDayID": paymentDayId }, function () {
            sessionStorage.setItem("ShouldUpdateShifts", true);

            jqtouch.goBack();
            removeLoading();
        }, "json");
    });

    //when changing the PaymentDay Date value
    $("#jqt").on("change", "#addPaymentDay #Date", ShowDayName);

    //ADD PAYMENT DAY
    $("#jqt").on("tap", "#addPaymentDay #btnAddPaymentDay", function () {
        var data = $("#addPaymentDay form").serializeObject();

        AddOrEditPaymentDay(data, "AddPaymentDay");
    });

    //Edit PAYMENT DAY
    $("#jqt").on("tap", "#addPaymentDay #btnEditPaymentDay", function () {
        var data = $("#addPaymentDay form").serializeObject();
        data.PaymentDayID = $(this).data("payment-day-id");

        AddOrEditPaymentDay(data, "EditPaymentDay");
    });

    function AddOrEditPaymentDay(data, actionName) {
        if (data.Date != "" && data.Name != "" && data.Money != "") {
            showLoading();

            //Invoke AJAX method to add/edit this paymentDay
            $.post(pathPrefix + "PaymentDays/" + actionName, data, function (result) {
                sessionStorage.setItem("ShouldUpdateShifts", true);

                jqtouch.goBack();
                removeLoading();
            }, "json");
        }
        else {
            showPopup("Please enter date, description and pay.", false);
        }
    }

    /*show the current date in the "ShiftDate" field
    -----------------------------------------------*/
    function SetCurrentDate() {
        var paymentDayDate = GetCurrentDate();

        var selectedView = localStorage.getItem("MonthlyShiftsView");
        var selectedDate = sessionStorage.getItem("CalendarViewSelectedDate");

        //if there is a selected date in the calendar (and the user's view is the calendar)
        if (selectedView == "calendar" && selectedDate != null) {
            paymentDayDate = selectedDate;
        }

        $("#addPaymentDay #Date").val(paymentDayDate).trigger("change");
    }

    function LoadFormData(paymentDayId) {
        //Invoke AJAX method to get the payment day values (to allow him EDIT)
        $.getJSON(pathPrefix + "PaymentDays/GetPaymentDay?PaymentDayId=" + paymentDayId, function (result) {
            if (result != null && result != "") {

                //highlight the paymentDay's selected color
                $("#addPaymentDay ol.ShiftColorsSelector li.selected").removeClass("selected");
                $("#addPaymentDay ol.ShiftColorsSelector li[data-color='" + result.Color + "']").addClass("selected");

                //set the "PaymentType" selected value according to the PaymentName
                var paymentType = $("#addPaymentDay #PaymentType option[value='" + result.Name + "']");
                if (paymentType.length == 0) {
                    paymentType = $("#addPaymentDay #PaymentType option[value='Other']");
                }
                paymentType.prop("selected", true);
                $("#addPaymentDay #PaymentType").trigger("change");

                $("#addPaymentDay #Name").val(result.Name);
                $("#addPaymentDay #Money").val(result.Money);
                $("#addPaymentDay #Comments").val(result.Comments);
                $("#addPaymentDay #Color").val(result.Color);

                var date = result.Date;
                var dateElement = $("#addPaymentDay #Date");
                dateElement.val(date).trigger("change");

                //add "mobiscroll" plugin to show date picker
                dateElement.mobiscroll().date(mobiscrollDateOptions);

                //update the values of the native date selectors (iOS only)
                UpdateNativeDateSelectors();
            }
        });
    }
});