﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#addPresetShift', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                //init the ShiftColorsSelector
                InitColorsSelector($("#addPresetShift ol.ShiftColorsSelector"));

                $(this).data("loaded", true);
            }

            //reset the form
            $("#addPresetShift form")[0].reset();
            $("#addPresetShift #isCustomRateDiv .optionsSelector > div[data-value=true]").trigger("tap"); //select the default option in the OptionsSelector
            $("#addPresetShift ol.ShiftColorsSelector li.selected").removeClass("selected");
            $("#addPresetShift ol.ShiftColorsSelector li:first-child").addClass("selected");

            //check if EDIT MODE
            var editPresetShiftId = sessionStorage.getItem("EditPresetShiftId");
            if (editPresetShiftId != null) {
                sessionStorage.removeItem("EditPresetShiftId");

                InitBonusesInputList(function () {
                    LoadFormData(editPresetShiftId);
                });

                //show the edit button
                $("#addPresetShift h1").html("Edit Preset Shift");
                $("#addPresetShift #btnEditPresetShift").show().data("preset-shift-id", editPresetShiftId);
                $("#addPresetShift #btnAddPresetShift").hide();
            }
            //ADD MODE
            else {
                InitBonusesInputList(null);

                //show the add button
                $("#addPresetShift h1").html("Add Preset Shift");
                $("#addPresetShift #btnEditPresetShift").hide();
                $("#addPresetShift #btnAddPresetShift").show();

                //add "mobiscroll" plugin to show date picker
                $("#addPresetShift #StartTime,#addPresetShift #EndTime").mobiscroll().time(mobiscrollDateOptions);

                var dailySalary = localStorage.getItem("DailySalary");
                $("#addPresetShift #Money").val(dailySalary);
            }
        }
    });

    //when changing the option in "OptionsSelector"
    $("#jqt").on("tap", "#addPresetShift .optionsSelector > div", function () {
        //set the value in the relevant hidden field
        var value = $(this).data("value");
        $(this).siblings(":hidden").val(value);
    });

    //when changing the option in "isCustomRateDiv - OptionsSelector" - show or hide the relevant textboxes (תעריף מותאם אישית)
    $("#jqt").on("tap", "#addPresetShift #isCustomRateDiv .optionsSelector > div", function () {
        var toDisable = $(this).data("value");

        //disable or enable the relevant input elements
        $("#addPresetShift .customRateValues input").prop("disabled", toDisable);

        if (toDisable) {
            $("#addPresetShift .customRateValues").hide();
        }
        else {
            $("#addPresetShift .customRateValues").show();
        }

        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                if (myScroll) {
                    myScroll.refresh();
                }
            }, 0);
        }
    });

    //when changing the option in "hasPresetTimesDiv - OptionsSelector" - show or hide the relevant textboxes (שעות קבועות או משתנות)
    $("#jqt").on("tap", "#addPresetShift #hasPresetTimesDiv .optionsSelector > div", function () {
        var toDisable = !$(this).data("value");

        //disable or enable the relevant input elements
        $("#addPresetShift #startEndTimeValuesDiv input").prop("disabled", toDisable);

        if (toDisable) {
            $("#addPresetShift #startEndTimeValuesDiv").hide();
        }
        else {
            $("#addPresetShift #startEndTimeValuesDiv").show();
        }
    });

    //when changing the option in "hasMoneyPerHourDiv - OptionsSelector" - show or hide the relevant textboxes (שכר לפי שעה או שכר קבוע לכל המשמרת)
    $("#jqt").on("tap", "#addPresetShift #hasMoneyPerHourDiv .optionsSelector > div", function () {
        var toDisable = $(this).data("value");

        //disable or enable the relevant input elements
        $("#addPresetShift #presetShiftFixedMoneyDiv input").prop("disabled", toDisable);

        if (toDisable) {
            $("#addPresetShift #presetShiftRatesDiv").show();
            $("#addPresetShift #presetShiftFixedMoneyDiv").hide();

            $("#addPresetShift #moneyPerHourLabel").show();
            $("#addPresetShift #moneyFixedLabel").hide();
        }
        else {
            $("#addPresetShift #presetShiftRatesDiv").hide();
            $("#addPresetShift #presetShiftFixedMoneyDiv").show();

            $("#addPresetShift #moneyPerHourLabel").hide();
            $("#addPresetShift #moneyFixedLabel").show();
        }
    });

    //when changing UseExtraHours value - show/hide the relevant elements
    $("#jqt").on("change", "#addPresetShift #UseExtraHoursForPresetShift", function () {
        var useExtraHours = $(this).prop("checked");

        if (useExtraHours) {
            $("#addPresetShift .extraHoursDiv").show();
        }
        else {
            $("#addPresetShift .extraHoursDiv").hide();
        }

        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                if (myScroll) {
                    myScroll.refresh();
                }
            }, 0);
        }
    });

    //when changing ExtraHours value - update the relevant ExtraExtraHours label
    $("#jqt").on("change", "#addPresetShift #ExtraHours", function () {
        var extraHours = $(this).val();
        $("#addPresetShift #ExtraExtraHoursLabel").html("After " + extraHours + " Hours");
    });

    //when the user click on an other Tab
    $("#jqt").on("tap", "#addPresetShift .TabBar ol li", function () {
        $(this).siblings(".selected").removeClass("selected");
        $(this).addClass("selected");

        //show the selected section
        var selectedIndex = $(this).index("#addPresetShift .TabBar ol li");
        $("#addPresetShift .presetShiftSection:visible").hide();
        $("#addPresetShift .presetShiftSection:eq(" + selectedIndex + ")").show();
    });

    //ADD PRESET SHIFT
    $("#jqt").on("tap", "#addPresetShift #btnAddPresetShift", function () {
        var data = $("#addPresetShift form").serializeObject();

        AddOrEditPresetShift(data, "AddPresetShift");
    });

    //Edit PRESET SHIFT
    $("#jqt").on("tap", "#addPresetShift #btnEditPresetShift", function () {
        var data = $("#addPresetShift form").serializeObject();
        data.PresetShiftID = $(this).data("preset-shift-id");

        AddOrEditPresetShift(data, "EditPresetShift");
    });

    function AddOrEditPresetShift(data, actionName) {
        //if the user define that he is not using Extra Hours (שעות נוספות) - change all extrahours rates to the regular rate
        if ($("#addPresetShift #UseExtraHoursForPresetShift").prop("checked") == false) {
            data.ShiftExtraRate = data.ShiftRate;
            data.ShiftExtraExtraRate = data.ShiftRate;
        }

        if (data.Name != "") {
            if (data.hasPresetTimes == false || (data.StartTime != "" && data.EndTime != "")) {
                showLoading();

                data.Bonuses = [];

                //loop through all the Bonuses textboxes
                $("#addPresetShift #BonusesInputContainer .bonusInput").each(function () {
                    //add the bonus value to the array
                    var bonus = {};
                    bonus.UserBonusID = $(this).data("bonus-id");
                    bonus.BonusVal = $(this).val();

                    if (bonus.BonusVal != "") {
                        data.Bonuses.push(bonus);
                    }
                });

                //Invoke AJAX method to add/edit this shift
                $.ajax({
                    url: pathPrefix + "PresetShifts/" + actionName,
                    data: JSON.stringify(data),
                    type: "POST",
                    contentType: 'application/json; charset=utf-8',
                    success: function (result) {
                        jqtouch.goBack();
                        removeLoading();
                    }
                });
            }
            else {
                showPopup("Please enter start and end time.", false);
            }
        }
        else {
            showPopup("Please select a name.", false);
        }
    }

    //insert INPUT element for each bonus
    function InitBonusesInputList(callback) {
        //get the bonuses that this user need to enter for each shift (bonuses per shift)
        $.getJSON(pathPrefix + "UserBonuses/GetUserBonusesForShift", function (result) {
            var currencyName = GetCurrencyName();

            if (result.length > 0) {
                //create input element for each bonus that this user has
                $("#addPresetShift #BonusesInputContainer").empty();

                var presetShiftBonusInputRowTemplate = Handlebars.templates["presetShiftBonusInputRowTemplate"];

                var listHtml = "";

                for (var i = 0; i < result.length; i++) {
                    result[i].Currency = currencyName;

                    //bind item to the bonuses list
                    listHtml += $.trim(presetShiftBonusInputRowTemplate(result[i]));
                }
                $("#addPresetShift #BonusesInputContainer").append(listHtml);

                InitNumberTextboxes($("#addPresetShift #BonusesInputContainer"));

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    window.setTimeout(function () {
                        if (myScroll) {
                            myScroll.refresh();
                        }
                    }, 0);
                }
            }

            if (callback != null) {
                callback();
            }
        });
    }

    function LoadFormData(presetShiftId) {
        //Invoke AJAX method to get the preset shift values (to allow him EDIT)
        $.getJSON(pathPrefix + "PresetShifts/GetPresetShift?PresetShiftID=" + presetShiftId, function (result) {
            if (result != null && result != "") {
                $("#addPresetShift #Name").val(result.Name);
                $("#addPresetShift #Color").val(result.Color);

                //highlight the presetShift's selected color
                $("#addPresetShift ol.ShiftColorsSelector li.selected").removeClass("selected");
                $("#addPresetShift ol.ShiftColorsSelector li[data-color='" + result.Color + "']").addClass("selected");

                //if there are StartTime-EndTime defined for this presetShift (שעות קבועות)
                if (result.StartTime != null && result.EndTime != null) {
                    $("#addPresetShift #StartTime").val(result.StartTime);
                    $("#addPresetShift #EndTime").val(result.EndTime);
                }
                //the times are changing (שעות משתנות)
                else {
                    $("#addPresetShift #hasPresetTimesDiv .optionsSelector > div[data-value=false]").trigger("tap");
                }

                //if there is fixed money for this shift (שכר קבוע, לא לפי שעה)
                if (result.Money != null) {
                    $("#addPresetShift #hasMoneyPerHourDiv .optionsSelector > div[data-value=false]").trigger("tap");
                    $("#addPresetShift #Money").val(result.Money);
                }
                else {
                    var dailySalary = localStorage.getItem("DailySalary");
                    $("#addPresetShift #Money").val(dailySalary);
                }

                /* Rates
                ---------------*/

                //check if the user defined specific shift rates for this shift
                if (result.UserDefinedShiftRates == false) {
                    $("#addPresetShift #isCustomRateDiv .optionsSelector > div[data-value=true]").trigger("tap");
                }
                else {
                    $("#addPresetShift #isCustomRateDiv .optionsSelector > div[data-value=false]").trigger("tap");

                    $("#addPresetShift #StandardHours").val(result.StandardHours);
                    $("#addPresetShift #ExtraHours").val(result.ExtraHours).trigger("change");
                    $("#addPresetShift #ShiftRate").val(result.ShiftRate);
                    $("#addPresetShift #ShiftExtraRate").val(result.ShiftExtraRate);
                    $("#addPresetShift #ShiftExtraExtraRate").val(result.ShiftExtraExtraRate);

                    //check or uncheck the "UseExtraHours" checkbox (if the user have 100% in all extra hours - he is not using ExtraHours)
                    var useExtraHours = $("#addPresetShift #UseExtraHoursForPresetShift");
                    if (result.ShiftExtraRate == result.ShiftRate && result.ShiftExtraExtraRate == result.ShiftRate) {
                        useExtraHours.prop("checked", false);
                    }
                    else {
                        useExtraHours.prop("checked", true)
                    }
                    useExtraHours.trigger("change");
                }

                /* Bonuses
                ---------------*/

                //if there are bonuses set for this shift
                if (result.Bonuses.length > 0) {
                    for (var i = 0; i < result.Bonuses.length; i++) {
                        var bonusValue = result.Bonuses[i].BonusVal;
                        var bonusName = result.Bonuses[i].BonusName;

                        //set value for this bonus
                        $("#addPresetShift #BonusesInputContainer .bonusInput[data-bonus-name='" + bonusName + "']").val(bonusValue);
                    }
                }
            }

            //add "mobiscroll" plugin to show date picker
            $("#addPresetShift #StartTime,#addPresetShift #EndTime").mobiscroll().time(mobiscrollDateOptions);

            //update the values of the native date selectors (iOS only)
            UpdateNativeDateSelectors();
        });
    }
});