﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#addShift', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            //reset the form
            $("#addShift form")[0].reset();
            $("#addShift ol.ShiftColorsSelector li.selected").removeClass("selected");
            $("#addShift ol.ShiftColorsSelector li:first-child").addClass("selected");

            /*init the start date in the "StartDate" field
            -----------------------------------------------*/
            var selectedView = localStorage.getItem("MonthlyShiftsView");
            var selectedDate = sessionStorage.getItem("CalendarViewSelectedDate");

            //if there is a selected date in the calendar (and the user's view is the calendar)
            if (selectedView == "calendar" && selectedDate != null) {
                var startDateInitialValue = selectedDate + " " + GetCurrentTime();

                //set this as the default date (in the Fake textbox - so that when the user click - it will be shown as the initial date, but won't be shown on the textbox)
                $("#addShift #StartDateFake").val(startDateInitialValue);
            }

            //add "mobiscroll" plugin to show date picker
            var dateFields = $("#addShift #StartDate,#addShift #EndDate,#addShift #StartDateFake,#addShift #EndDateFake");
            dateFields.mobiscroll().datetime(mobiscrollDateOptions);
        }
    });

    //when this page loads first time (Animation END)
    $('#jqt').on('pageAnimationEnd', '#addShift', function (event, info) {
        if (info.direction == 'in') {
            GetCurrencyName();

            //only on the first load
            if (!$(this).data("loadedAnimationEnd")) {
                //init the ShiftColorsSelector
                InitColorsSelector($("#addShift ol.ShiftColorsSelector"));

                $(this).data("loadedAnimationEnd", true);
            }

            //update the values of the native date selectors (iOS only)
            UpdateNativeDateSelectors();
        }
    });

    //when changing the StartDateFake value (which is the upper one, the one that the user can click on)
    $("#jqt").on("change", "#addShift #StartDateFake", function () {
        //update the real textbox value
        var startDate = $(this).val();
        $("#addShift #StartDate").val(startDate);

        var currentEndDate = $("#addShift #EndDate").val();

        //check that there is no EndDate entered already
        if (currentEndDate == "") {
            //add one minute to the EndDate (in the Fake textbox - so that when the user click - it will be shown as the initial date
            var startDate = $(this).val();
            if (startDate != "") {
                var endDate = AddOneMinute(startDate);
                var endDateElement = $("#addShift #EndDateFake");
                endDateElement.val(endDate);

                //update the "mobiscroll" plugin value
                var dateTimeParts = endDate.split(" ");
                var dateParts = dateTimeParts[0].split("/");
                var timeParts = dateTimeParts[1].split(":");
                var endDateObj = new Date(dateParts[2], parseInt(dateParts[0], 10) - 1, dateParts[1], timeParts[0], timeParts[1], 0, 0);
                // add am-pm (12 hours if PM)
                if (endDate.toUpperCase().indexOf("PM") >= 0) {
                    endDateObj.setHours(endDateObj.getHours() + 12);
                }
                endDateElement.mobiscroll("setDate", endDateObj, false);

                //update the values of the native date selectors (iOS only)
                UpdateNativeDateSelectors();
            }
        }
    });

    //when changing the EndDateFake value (which is the upper one, the one that the user can click on)
    $("#jqt").on("change", "#addShift #EndDateFake", function () {
        //update the real textbox value
        var endDate = $(this).val();
        $("#addShift #EndDate").val(endDate);
    });

    //ADD SHIFT
    $("#jqt").on("tap", "#addShift #btnAddShift", function () {
        var data = $("#addShift form").serializeObject();

        if (data.StartDate != "") {
            showLoading();

            //Invoke AJAX method to add this shift
            $.post(pathPrefix + "Shifts/AddNewShift", data, function (result) {
                //if success
                if (result.Key) {
                    sessionStorage.setItem("ShouldUpdateShifts", true);

                    jqtouch.goBack();

                    //if the user want to show shift details after insertion
                    if (localStorage.getItem("ShowShiftDetailsAfterInsertion") == "true") {
                        sessionStorage.setItem("EditShiftId", result.AddedShift.ShiftID);
                        sessionStorage.setItem("ShouldUpdateShiftDetails", true);
                        sessionStorage.setItem("ShowSmallPopup", JSON.stringify(result));

                        window.setTimeout(function () {
                            //go to the ShiftDetails page
                            jqtouch.goTo("ShiftDetails.html", "slideup");
                        }, 2000);
                    }

                    AddShiftToIphoneCalendar(result.AddedShift);
                }
                else {
                    showPopup(result.Value, result.Key);
                }
                removeLoading();
            }, "json");
        }
        else {
            showPopup("Please select start time.", false);
        }
    });
});