﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#addUserBonus', function (event, info) {
        if (info.direction == 'in') {

            $("#addUserBonus form")[0].reset();
            $("#addUserBonus .optionsSelector > div[data-value=true]").trigger("tap"); //select the default option in the OptionsSelector

            GetCurrencyName();

            //check if EDIT MODE
            var editUserBonusId = sessionStorage.getItem("EditUserBonusId");
            if (editUserBonusId != null) {
                sessionStorage.removeItem("EditUserBonusId");

                LoadFormData(editUserBonusId);

                //show the edit button
                $("#addUserBonus h1").html("Edit Bonus");
                $("#addUserBonus #btnEditUserBonus").show().data("bonus-id", editUserBonusId);
                $("#addUserBonus #btnAddUserBonus").hide();
            }
            //ADD MODE
            else {
                //show the add button
                $("#addUserBonus h1").html("Add Bonus");
                $("#addUserBonus #btnEditUserBonus").hide();
                $("#addUserBonus #btnAddUserBonus").show();
            }
        }
    });

    //when changing the option in "OptionsSelector"
    $("#jqt").on("tap", "#addUserBonus .optionsSelector > div", function () {
        //set the value in the relevant hidden field
        var value = $(this).data("value");
        $(this).siblings(":hidden").val(value);

        var isChanging = $("#addUserBonus #IsChanging").val();
        var isPerShift = $("#addUserBonus #IsPerShift").val();

        //if this bonus is not changing (בונוס קבוע) or not per shift (בונוס חודשי)
        if (isChanging == "false" || isPerShift == "false") {
            $("#addUserBonus #defaultValueDiv").show();
            $("#addUserBonus #defaultValueDiv input").prop("disabled", false);

            //show or hide the MonthlyChanging description
            if (isChanging == "true" && isPerShift == "false") {
                $("#addUserBonus #defaultValueDiv .smallDesc").show();
            }
            else {
                $("#addUserBonus #defaultValueDiv .smallDesc").hide();

            }
        }
        else {
            $("#addUserBonus #defaultValueDiv").hide();
            $("#addUserBonus #defaultValueDiv input").prop("disabled", true);
        }

        if (isPerShift == "true") {
            $("#addUserBonus #isPerShiftLabel").html("per shift");
        }
        else {
            $("#addUserBonus #isPerShiftLabel").html("per payroll");
        }
    });

    //ADD USER BONUS
    $("#jqt").on("tap", "#addUserBonus #btnAddUserBonus", function () {
        var data = $("#addUserBonus form").serializeObject();

        AddOrEditUserBonus(data, "AddUserBonus");
    });

    //EDIT USER BONUS
    $("#jqt").on("tap", "#addUserBonus #btnEditUserBonus", function () {
        var data = $("#addUserBonus form").serializeObject();
        data.UserBonusID = $(this).data("bonus-id");

        AddOrEditUserBonus(data, "EditUserBonus");
    });

    function AddOrEditUserBonus(data, actionName) {
        var isDefaultValueValid = false;
        if ($("#addUserBonus #defaultValueDiv input").prop("disabled") || data.DefaultValue != "") {
            isDefaultValueValid = true;
        }

        if (data.Name != "" && isDefaultValueValid) {
            showLoading();

            //Invoke AJAX method to add this bonus
            $.post(pathPrefix + "UserBonuses/" + actionName, data, function (result) {
                if (result.Key) {
                    sessionStorage.setItem("ShouldUpdateShifts", true);
                    jqtouch.goBack();
                }
                else {
                    showPopup(result.Value, result.Key);
                }

                removeLoading();

                GetUserSettings();
            }, "json");
        }
        else {
            showPopup("Please select the bonus details.", false);
        }
    }

    function LoadFormData(bonusId) {
        //Invoke AJAX method to get the bonus values (to allow him EDIT)
        $.getJSON(pathPrefix + "UserBonuses/GetUserBonus?UserBonusID=" + bonusId, function (result) {
            if (result != null && result != "") {

                $("#addUserBonus #Name").val(result.Name);

                $("#addUserBonus #IsPerShift").val(result.IsPerShift);
                $("#addUserBonus #isPerShiftDiv .optionsSelector > div[data-value=" + result.IsPerShift + "]").trigger("tap");

                $("#addUserBonus #IsChanging").val(result.IsChanging);
                $("#addUserBonus #isChangingDiv .optionsSelector > div[data-value=" + result.IsChanging + "]").trigger("tap");

                $("#addUserBonus #IsTaxDeductible").val(result.IsTaxDeductible);
                $("#addUserBonus #isTaxDeductibleDiv .optionsSelector > div[data-value=" + result.IsTaxDeductible + "]").trigger("tap");

                $("#addUserBonus #DefaultValue").val(result.DefaultValue);
            }
        });
    }
});