﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#addUserDeduction', function (event, info) {
        if (info.direction == 'in') {

            $("#addUserDeduction form")[0].reset();
            $("#addUserDeduction .optionsSelector > div[data-value=true]").trigger("tap"); //select the default option in the OptionsSelector
            $("#addUserDeduction #DeductionType").trigger("change"); // fix "select" bug in IOS4

            GetCurrencyName();

            //check if EDIT MODE
            var editUserDeductionId = sessionStorage.getItem("EditUserDeductionId");
            if (editUserDeductionId != null) {
                sessionStorage.removeItem("EditUserDeductionId");

                LoadFormData(editUserDeductionId);

                //show the edit button
                $("#addUserDeduction h1").html("Edit Deduction");
                $("#addUserDeduction #btnEditUserDeduction").show().data("deduction-id", editUserDeductionId);
                $("#addUserDeduction #btnAddUserDeduction").hide();
            }
            //ADD MODE
            else {
                //show the add button
                $("#addUserDeduction h1").html("Add Deduction");
                $("#addUserDeduction #btnEditUserDeduction").hide();
                $("#addUserDeduction #btnAddUserDeduction").show();
            }
        }
    });

    //when changing the option in "OptionsSelector" - show or hide the relevant textboxes
    $("#jqt").on("tap", "#addUserDeduction .optionsSelector > div", function () {
        var toDisable = $(this).data("value");

        //enable the PercentageOfGross textbox or the FixedAmount textbox
        $("#addUserDeduction #PercentageOfGross").prop("disabled", !toDisable);
        $("#addUserDeduction #FixedAmount").prop("disabled", toDisable);

        if (toDisable) {
            $("#addUserDeduction #percentageOfGrossDiv").show();
            $("#addUserDeduction #fixedAmountDiv").hide();
        }
        else {
            $("#addUserDeduction #percentageOfGrossDiv").hide();
            $("#addUserDeduction #fixedAmountDiv").show();
        }

        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                if (myScroll) {
                    myScroll.refresh();
                }
            }, 0);
        }
    });

    $("#jqt").on("change", "#addUserDeduction #DeductionType", function () {
        var selectedType = $(this).val();

        //if the user select "Other" in the DeductionType options
        if (selectedType == "Other") {
            $("#addUserDeduction #Name").val("");
            $("#addUserDeduction #deductionNameRow").show();
        }
        else if (selectedType != "--Select--") {
            $("#addUserDeduction #Name").val(selectedType);
            $("#addUserDeduction #deductionNameRow").hide();
        }
        else {
            $("#addUserDeduction #Name").val("");
            $("#addUserDeduction #deductionNameRow").hide();
        }

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedType);
    });

    //ADD USER DEDUCTION
    $("#jqt").on("tap", "#addUserDeduction #btnAddUserDeduction", function () {
        var data = $("#addUserDeduction form").serializeObject();

        AddOrEditUserDeduction(data, "AddUserDeduction");
    });

    //EDIT USER DEDUCTION
    $("#jqt").on("tap", "#addUserDeduction #btnEditUserDeduction", function () {
        var data = $("#addUserDeduction form").serializeObject();
        data.DeductionID = $(this).data("deduction-id");

        AddOrEditUserDeduction(data, "EditUserDeduction");
    });

    function AddOrEditUserDeduction(data, actionName) {
        if (data.Name != "") {
            showLoading();

            //Invoke AJAX method to add this deduction
            $.post(pathPrefix + "UserDeductions/" + actionName, data, function (result) {
                jqtouch.goBack();
                removeLoading();
            }, "json");
        }
        else {
            showPopup("Please fill the required fields.", false);
        }
    }

    function LoadFormData(deductionId) {
        //Invoke AJAX method to get the deduction values (to allow him EDIT)
        $.getJSON(pathPrefix + "UserDeductions/GetUserDeduction?DeductionID=" + deductionId, function (result) {
            if (result != null && result != "") {

                //set the "DeductionType" selected value according to the DeductionName
                var deductionType = $("#addUserDeduction #DeductionType option[value='" + result.Name + "']");
                if (deductionType.length == 0) {
                    deductionType = $("#addUserDeduction #DeductionType option[value='Other']");
                }
                deductionType.prop("selected", true);
                $("#addUserDeduction #DeductionType").trigger("change");

                $("#addUserDeduction #Name").val(result.Name);

                if (result.PercentageOfGross != null) {
                    $("#addUserDeduction .optionsSelector > div[data-value=true]").trigger("tap");
                    $("#addUserDeduction #PercentageOfGross").val(result.PercentageOfGross);
                }
                else if (result.FixedAmount != null) {
                    $("#addUserDeduction .optionsSelector > div[data-value=false]").trigger("tap");
                    $("#addUserDeduction #FixedAmount").val(result.FixedAmount);
                }
            }
        });
    }
});