﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#addUserProfile', function (event, info) {
        if (info.direction == 'in') {

            $("#addUserProfile form")[0].reset();

            //check if EDIT MODE
            var editUserProfileId = sessionStorage.getItem("EditUserProfileId");
            if (editUserProfileId != null) {
                sessionStorage.removeItem("EditUserProfileId");

                //set the form values
                $("#addUserProfile #ProfileName").val(sessionStorage.getItem("EditUserProfileName"));

                //show the edit button
                $("#addUserProfile h1").html("Edit Profile");
                $("#addUserProfile .info").hide();
                $("#addUserProfile #btnEditUserProfile").show().data("user-id", editUserProfileId);
                $("#addUserProfile #btnAddUserProfile").hide();
            }
            //ADD MODE
            else {
                //show the add button
                $("#addUserProfile h1").html("Add Profile");
                $("#addUserProfile .info").show();
                $("#addUserProfile #btnEditUserProfile").hide();
                $("#addUserProfile #btnAddUserProfile").show();
            }
        }
    });

    //ADD USER PROFILE
    $("#jqt").on("tap", "#addUserProfile #btnAddUserProfile", function () {
        var data = $("#addUserProfile form").serializeObject();

        if (data.ProfileName != "") {
            showLoading();

            //Invoke AJAX method to add this extra profile
            $.post(pathPrefix + "UserProfiles/AddUserExtraProfile", data, function (result) {
                localStorage.setItem("UserUniqueGuid", result.UniqueGuid);
                localStorage.setItem("ProfileName", data.ProfileName);
                sessionStorage.setItem("ShouldUpdateShifts", true);

                var userData = { "UniqueGuid": result.UniqueGuid, "AppVersion": appVersion, "Device": localStorage.getItem("Device") };

                //Invoke AJAX method to login this user's profile
                $.post(pathPrefix + "Users/AutoLogin", userData, function (result) {
                    if (result.Key) {
                        jqtouch.goTo(result.Redirect);
                    }

                    removeLoading();
                }, "json");
            }, "json");
        }
        else {
            showPopup("Please enter profile name.", false);
        }

        return false;
    });

    //EDIT USER PROFILE
    $("#jqt").on("tap", "#addUserProfile #btnEditUserProfile", function () {
        var data = $("#addUserProfile form").serializeObject();
        data.UserID = $(this).data("user-id");

        if (data.ProfileName != "") {
            showLoading();

            //Invoke AJAX method to add this profile
            $.post(pathPrefix + "UserProfiles/EditUserProfile", data, function (result) {
                jqtouch.goBack();
                removeLoading();
            }, "json");
        }
        else {
            showPopup("Please enter profile name.", false);
        }

        return false;
    });
});