﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#addUserRateType', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            $("#addUserRateType form")[0].reset();
            $("#addUserRateType #FromDay").trigger("change"); // fix "select" bug in IOS4
            $("#addUserRateType #ToDay").trigger("change"); // fix "select" bug in IOS4

            //check if EDIT MODE
            var editUserRateTypeId = sessionStorage.getItem("EditUserRateTypeId");
            if (editUserRateTypeId != null) {
                sessionStorage.removeItem("EditUserRateTypeId");

                LoadFormData(editUserRateTypeId);

                //show the edit button
                $("#addUserRateType h1").html("Edit Pay Rate");
                $("#addUserRateType #btnEditUserRateType").show().data("rate-id", editUserRateTypeId);
                $("#addUserRateType #btnAddUserRateType").hide();
            }
            //ADD MODE
            else {
                //show the add button
                $("#addUserRateType h1").html("Add Pay Rate");
                $("#addUserRateType #btnEditUserRateType").hide();
                $("#addUserRateType #btnAddUserRateType").show();

                //add "mobiscroll" plugin to show date picker
                $("#addUserRateType #FromTime,#addUserRateType #ToTime").mobiscroll().time(mobiscrollDateOptions);
            }
        }
    });

    //when changing UseExtraHours value - show/hide the relevant elements
    $("#jqt").on("change", "#addUserRateType #UseExtraHoursForRate", function () {
        var useExtraHours = $(this).prop("checked");

        if (useExtraHours) {
            $("#addUserRateType .extraHoursDiv").show();
        }
        else {
            $("#addUserRateType .extraHoursDiv").hide();
        }

        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                if (myScroll) {
                    myScroll.refresh();
                }
            }, 0);
        }
    });

    //when changing ExtraHours value - update the relevant ExtraExtraHours label
    $("#jqt").on("change", "#addUserRateType #ExtraHours", function () {
        var extraHours = $(this).val();
        $("#addUserRateType #ExtraExtraHoursLabel").html("After " + extraHours + " Hours");
    });

    $("#jqt").on("change", "#addUserRateType #FromDay,#addUserRateType #ToDay", function () {
        var selectedType = $(this).find("option:selected").html();

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedType);
    });

    //ADD USER RATE TYPE
    $("#jqt").on("tap", "#addUserRateType #btnAddUserRateType", function () {
        var data = $("#addUserRateType form").serializeObject();

        AddOrEditRateType(data, "AddUserRateType");
    });

    //EDIT USER RATE TYPE
    $("#jqt").on("tap", "#addUserRateType #btnEditUserRateType", function () {
        var data = $("#addUserRateType form").serializeObject();
        data.RateTypeID = $(this).data("rate-id");

        AddOrEditRateType(data, "EditUserRateType");
    });

    function AddOrEditRateType(data, actionName) {
        //if the user define that he is not using Extra Hours (שעות נוספות) - change all extrahours rates to be exactly as the regular rate
        if ($("#addUserRateType #UseExtraHoursForRate").prop("checked") == false) {
            data.ExtraRate = data.Rate;
            data.ExtraExtraRate = data.Rate;
        }

        if (data.Name != "") {
            if ((data.FromDay != "" && data.ToDay != "") || (data.FromDay == "" && data.ToDay == "")) {
                showLoading();

                //Invoke AJAX method to add/edit this rate type
                $.post(pathPrefix + "UserRateTypes/" + actionName, data, function (result) {
                    jqtouch.goBack();
                    removeLoading();
                }, "json");
            }
            else {
                showPopup("These times are invalid.", false);
            }
        }
        else {
            showPopup("Please enter a name.", false);
        }
    }

    function LoadFormData(rateId) {
        //Invoke AJAX method to get the rate type values (to allow him EDIT)
        $.getJSON(pathPrefix + "UserRateTypes/GetUserRateType?RateTypeID=" + rateId, function (result) {
            if (result != null && result != "") {
                $("#addUserRateType #Name").val(result.Name);

                $("#addUserRateType #StandardHours").val(result.StandardHours);
                $("#addUserRateType #ExtraHours").val(result.ExtraHours).trigger("change"); 
                $("#addUserRateType #Rate").val(result.Rate);
                $("#addUserRateType #ExtraRate").val(result.ExtraRate);
                $("#addUserRateType #ExtraExtraRate").val(result.ExtraExtraRate);

                $("#addUserRateType #FromDay").val(result.FromDay).trigger("change");
                $("#addUserRateType #ToDay").val(result.ToDay).trigger("change");
                $("#addUserRateType #FromTime").val(result.FromTimeVal);
                $("#addUserRateType #ToTime").val(result.ToTimeVal);

                //check or uncheck the "UseExtraHours" checkbox (if the user have 100% in all extra hours - he is not using ExtraHours)
                var useExtraHours = $("#addUserRateType #UseExtraHoursForRate");
                if (result.ExtraRate == result.Rate && result.ExtraExtraRate == result.Rate) {
                    useExtraHours.prop("checked", false);
                }
                else {
                    useExtraHours.prop("checked", true)
                }
                useExtraHours.trigger("change");
            }

            //add "mobiscroll" plugin to show date picker
            $("#addUserRateType #FromTime,#addUserRateType #ToTime").mobiscroll().time(mobiscrollDateOptions);

            //update the values of the native date selectors (iOS only)
            UpdateNativeDateSelectors();
        });
    }
});