﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#contact', function (event, info) {
        if (info.direction == 'in') {

            //load Email from localStorage
            var rememberEmail = localStorage.getItem("RememberEmail");
            if (rememberEmail != null) {
                $("#contact #Email").val(rememberEmail);
            }
        }
    });

    //SEND CONTACT MESSAGE
    $("#jqt").on("tap", "#contact #btnSend", function () {
        var data = $("#contact form").serializeObject();

        if (data.Text != "" && data.Email != "") {
            if (data.Email.indexOf("@") >= 0 && data.Email.indexOf(".") >= 0) {
                showLoading();

                //Invoke AJAX method to send message
                $.post(pathPrefix + "Contact/SendMessage", data, function (result) {
                    showPopup("Thanks for contacting us!", true);

                    window.setTimeout(function () {
                        jqtouch.goBack();
                        removeLoading();
                    }, 4000);
                }, "json");
            }
            else {
                showPopup("Invalid email.", false);
            }
        }
        else {
            showPopup("Please enter your message.", false);
        }
    });
});