﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#editMonthlyBonuses', function (event, info) {
        if (info.direction == 'in') {

            $("#editMonthlyBonuses form")[0].reset();
            InitBonusesInputList();

            //get the current period
            var currentPeriodID = sessionStorage.getItem("currentUserPeriodID");
            var currentPeriod = GetPeriodByID(currentPeriodID);

            if (currentPeriod != null) {
                //set the period in the relevant label
                $("#editMonthlyBonuses #periodDesc").html(currentPeriod.FromDate + " - " + currentPeriod.ToDate);
            }
        }
    });

    //EDIT Monthly Bonus
    $("#jqt").on("tap", "#editMonthlyBonuses #btnEditMonthlyBonuses", function () {
        var data = {
            "UserPayPeriodID": sessionStorage.getItem("currentUserPeriodID"),
            "Bonuses": []
        };

        //loop through all the Bonuses textboxes
        $("#editMonthlyBonuses #MonthlyBonusesInputContainer .bonusInput").each(function () {
            //add the bonus value to the array
            var bonus = {};
            bonus.UserBonusID = $(this).data("bonus-id");
            bonus.BonusVal = $(this).val();

            data.Bonuses.push(bonus);
        });

        showLoading();

        //Invoke AJAX method to update the monthly bonuses of this user
        $.ajax({
            url: pathPrefix + "UserBonuses/UpdateMonthlyBonuses",
            data: JSON.stringify(data),
            type: "POST",
            contentType: 'application/json; charset=utf-8',
            success: function (result) {
                jqtouch.goBack();
                removeLoading();
            }
        });
    });

    function InitBonusesInputList() {
        //get the bonuses that this user need to enter for each month (bonuses per month)
        $.getJSON(pathPrefix + "UserBonuses/GetUserBonusesForPeriod?UserPayPeriodID=" + sessionStorage.getItem("currentUserPeriodID"), function (result) {
            var currencyName = GetCurrencyName();

            if (result.UserBonuses.length == 0) {
            }
            else {
                $("#editMonthlyBonuses .info").hide();

                //create input element for each bonus that this user has
                $("#editMonthlyBonuses #MonthlyBonusesInputContainer").empty();

                var monthlyBonusInputRowTemplate = Handlebars.templates["monthlyBonusInputRowTemplate"];

                var listHtml = "";

                //loop through the bonuses and bind to the list
                for (var i = 0; i < result.UserBonuses.length; i++) {
                    result.UserBonuses[i].Currency = currencyName;

                    //set default value
                    result.UserBonuses[i].val = "0";
                    if (result.UserBonuses[i].DefaultValue != null) {
                        result.UserBonuses[i].val = result.UserBonuses[i].DefaultValue;
                    }

                    listHtml += $.trim(monthlyBonusInputRowTemplate(result.UserBonuses[i]));
                }
                $("#editMonthlyBonuses #MonthlyBonusesInputContainer").append(listHtml);

                InitNumberTextboxes($("#editMonthlyBonuses"));

                LoadFormData(result.MonthlyBonusesValues);
            }
        });
    }

    function LoadFormData(bonuses) {
        //if there are bonuses set for this month
        if (bonuses.length > 0) {
            for (var i = 0; i < bonuses.length; i++) {
                var bonusValue = bonuses[i].BonusVal;
                var bonusName = bonuses[i].BonusName;

                //set value for this bonus
                $("#editMonthlyBonuses #MonthlyBonusesInputContainer .bonusInput[data-bonus-name='" + bonusName + "']").val(bonusValue);
            }
        }
    }
});