﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#editShiftBonuses', function (event, info) {
        if (info.direction == 'in') {

            $("#editShiftBonuses form")[0].reset();
            InitBonusesInputList();
        }
    });

    //EDIT SHIFT
    $("#jqt").on("tap", "#editShiftBonuses #btnEditShiftBonuses", function () {
        var data = {
            "ShiftID": sessionStorage.getItem("EditShiftId"),
            "Bonuses": []
        };

        //loop through all the Bonuses textboxes
        $("#editShiftBonuses #BonusesInputContainer .bonusInput").each(function () {
            //add the bonus value to the array
            var bonus = {};
            bonus.UserBonusID = $(this).data("bonus-id");
            bonus.BonusVal = $(this).val();

            if (bonus.BonusVal != "") {
                data.Bonuses.push(bonus);
            }
        });

        showLoading();

        //Invoke AJAX method to update this shift bonuses
        $.ajax({
            url: pathPrefix + "Shifts/EditShiftBonuses",
            data: JSON.stringify(data),
            type: "POST",
            contentType: 'application/json; charset=utf-8',
            success: function (result) {
                sessionStorage.setItem("ShouldUpdateShiftDetails", true);
                sessionStorage.setItem("ShouldUpdateShifts", true);

                jqtouch.goBack();
                removeLoading();
            }
        });
    });

    //insert INPUT element for each bonus
    function InitBonusesInputList() {
        //get the bonuses that this user need to enter for each shift (bonuses per shift)
        $.getJSON(pathPrefix + "UserBonuses/GetUserBonusesForShift", function (result) {
            var currencyName = GetCurrencyName();

            if (result.length == 0) {
                $("#editShiftBonuses .info").show();
            }
            else {
                $("#editShiftBonuses .info").hide();

                //create input element for each bonus that this user has
                $("#editShiftBonuses #BonusesInputContainer").empty();

                var bonusInputRowTemplate = Handlebars.templates["bonusInputRowTemplate"];

                var listHtml = "";

                //loop through the items and bind to the list
                for (var i = 0; i < result.length; i++) {
                    result[i].Currency = currencyName;

                    listHtml += $.trim(bonusInputRowTemplate(result[i]));
                }
                $("#editShiftBonuses #BonusesInputContainer").append(listHtml);

                InitNumberTextboxes($("#editShiftBonuses"));

                LoadFormData();
            }
        });
    }

    function LoadFormData() {
        //get this shift details from the SessionStorage
        var editShiftData = sessionStorage.getItem("EditShiftData");

        if (editShiftData != null) {
            result = JSON.parse(editShiftData);

            //if there are bonuses set for this shift
            if (result.Bonuses.length > 0) {
                for (var i = 0; i < result.Bonuses.length; i++) {
                    var bonusValue = result.Bonuses[i].BonusVal;
                    var bonusName = result.Bonuses[i].BonusName;

                    //set value for this bonus
                    $("#editShiftBonuses #BonusesInputContainer .bonusInput[data-bonus-name='" + bonusName + "']").val(bonusValue);
                }
            }
        }
    }
});