﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#editShiftMoney', function (event, info) {
        if (info.direction == 'in') {

            $("#editShiftMoney form")[0].reset();
            LoadFormData();
        }
    });

    //when this page loads first time (Animation END)
    $('#jqt').on('pageAnimationEnd', '#editShiftMoney', function (event, info) {
        if (info.direction == 'in') {
            GetCurrencyName();
        }
    });

    //when user click revert to original money
    $("#jqt").on("tap", "#editShiftMoney #btnRevertOriginalMoney", function () {
        //get this shift details from the SessionStorage
        var editShiftData = sessionStorage.getItem("EditShiftData");

        if (editShiftData != null) {
            result = JSON.parse(editShiftData);

            $("#editShiftMoney #Money").val(result.MoneyOriginal);
        }
    });

    //EDIT SHIFT
    $("#jqt").on("tap", "#editShiftMoney #btnEditShiftMoney", function () {
        var data = $("#editShiftMoney form").serializeObject();
        data.ShiftID = sessionStorage.getItem("EditShiftId");

        showLoading();

        //Invoke AJAX method to update this shift details
        $.post(pathPrefix + "Shifts/UpdateShiftMoney", data, function (result) {
            sessionStorage.setItem("ShouldUpdateShiftDetails", true);
            sessionStorage.setItem("ShouldUpdateShifts", true);

            jqtouch.goBack();
            removeLoading();
        }, "json");
    });

    function LoadFormData() {
        //get this shift details from the SessionStorage
        var editShiftData = sessionStorage.getItem("EditShiftData");

        if (editShiftData != null) {
            result = JSON.parse(editShiftData);

            var money = result.Money;
            money = money.replace(",","");
            $("#editShiftMoney #Money").val(money);
        }
    }
});