﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#editShiftRate', function (event, info) {
        if (info.direction == 'in') {

            $("#editShiftRate form")[0].reset();
            LoadFormData();
        }
    });

    //when changing the option in "OptionsSelector" - show or hide the relevant textboxes
    $("#jqt").on("tap", "#editShiftRate .optionsSelector > div", function () {
        var toDisable = $(this).data("value");

        //disable or enable the relevant input elements
        $("#editShiftRate .customRateValues input").prop("disabled", toDisable);

        if (toDisable) {
            $("#editShiftRate .customRateValues").hide();
        }
        else {
            $("#editShiftRate .customRateValues").show();
        }

        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                if (myScroll) {
                    myScroll.refresh();
                }
            }, 0);
        }
    });

    //when changing UseExtraHours value - show/hide the relevant elements
    $("#jqt").on("change", "#editShiftRate #UseExtraHoursForShift", function () {
        var useExtraHours = $(this).prop("checked");

        if (useExtraHours) {
            $("#editShiftRate .extraHoursDiv").show();
        }
        else {
            $("#editShiftRate .extraHoursDiv").hide();
        }

        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                if (myScroll) {
                    myScroll.refresh();
                }
            }, 0);
        }
    });

    //when changing ExtraHours value - update the relevant ExtraExtraHours label
    $("#jqt").on("change", "#editShiftRate #ExtraHours", function () {
        var extraHours = $(this).val();
        $("#editShiftRate #ExtraExtraHoursLabel").html("After " + extraHours + " Hours");
    });

    //EDIT SHIFT
    $("#jqt").on("tap", "#editShiftRate #btnEditShiftRate", function () {
        var data = $("#editShiftRate form").serializeObject();
        data.ShiftID = sessionStorage.getItem("EditShiftId");

        //if the user define that he is not using Extra Hours (שעות נוספות) - change all extrahours rates to the regular rate
        if ($("#editShiftRate #UseExtraHoursForShift").prop("checked") == false) {
            data.ShiftExtraRate = data.ShiftRate;
            data.ShiftExtraExtraRate = data.ShiftRate;
        }

        showLoading();

        //Invoke AJAX method to update this shift details
        $.post(pathPrefix + "Shifts/EditShiftRate", data, function (result) {
            sessionStorage.setItem("ShouldUpdateShiftDetails", true);
            sessionStorage.setItem("ShouldUpdateShifts", true);

            jqtouch.goBack();
            removeLoading();
        }, "json");
    });

    function LoadFormData() {
        //get this shift details from the SessionStorage
        var editShiftData = sessionStorage.getItem("EditShiftData");

        if (editShiftData != null) {
            result = JSON.parse(editShiftData);

            //check if the user defined specific shift rates for this shift
            if (result.UserDefinedShiftRates == false) {
                $("#editShiftRate .optionsSelector > div[data-value=true]").trigger("tap");
            }
            else {
                $("#editShiftRate .optionsSelector > div[data-value=false]").trigger("tap");

                $("#editShiftRate #StandardHours").val(result.StandardHours);
                $("#editShiftRate #ExtraHours").val(result.ExtraHours).trigger("change");
                $("#editShiftRate #ShiftRate").val(result.ShiftRate);
                $("#editShiftRate #ShiftExtraRate").val(result.ShiftExtraRate);
                $("#editShiftRate #ShiftExtraExtraRate").val(result.ShiftExtraExtraRate);

                //check or uncheck the "UseExtraHours" checkbox (if the user have 100% in all extra hours - he is not using ExtraHours)
                var useExtraHours = $("#editShiftRate #UseExtraHoursForShift");
                if (result.ShiftExtraRate == result.ShiftRate && result.ShiftExtraExtraRate == result.ShiftRate) {
                    useExtraHours.prop("checked", false);
                }
                else {
                    useExtraHours.prop("checked", true)
                }
                useExtraHours.trigger("change");
            }
        }
    }
});