﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#editShiftTimes', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            $("#editShiftTimes form")[0].reset();
            LoadFormData();
        }
    });

    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#editShiftTimes', function (event, info) {
        if (info.direction == 'in') {
            //update the values of the native date selectors (iOS only)
            UpdateNativeDateSelectors();
        }
    });

    //when changing the StartDate value
    $("#jqt").on("change", "#editShiftTimes #StartDate", function () {
        var currentEndDate = $("#editShiftTimes #EndDate").val();

        //check that there is no EndDate entered already
        if (currentEndDate == "") {
            //add one minute to the EndDate
            var startDate = $(this).val();
            if (startDate != "") {
                var endDate = AddOneMinute(startDate);
                var endDateElement = $("#editShiftTimes #EndDateFake");
                endDateElement.val(endDate);

                //update the "mobiscroll" plugin value
                var dateTimeParts = endDate.split(" ");
                var dateParts = dateTimeParts[0].split("/");
                var timeParts = dateTimeParts[1].split(":");
                var endDateObj = new Date(dateParts[2], parseInt(dateParts[0], 10) - 1, dateParts[1], timeParts[0], timeParts[1], 0, 0);
                // add am-pm (12 hours if PM)
                if (endDate.toUpperCase().indexOf("PM") >= 0) {
                    endDateObj.setHours(endDateObj.getHours() + 12);
                }
                endDateElement.mobiscroll("setDate", endDateObj, false);

                //update the values of the native date selectors (iOS only)
                UpdateNativeDateSelectors();
            }
        }
    });

    //when changing the EndDateFake value
    $("#jqt").on("change", "#editShiftTimes #EndDateFake", function () {
        var endDate = $(this).val();
        $("#editShiftTimes #EndDate").val(endDate);
    });

    //EDIT SHIFT
    $("#jqt").on("tap", "#editShiftTimes #btnEditShiftTimes", function () {
        var data = $("#editShiftTimes form").serializeObject();
        data.ShiftID = sessionStorage.getItem("EditShiftId");

        if (data.StartDate != "") {
            showLoading();

            //Invoke AJAX method to update this shift details
            $.post(pathPrefix + "Shifts/EditShiftTimes", data, function (result) {
                sessionStorage.setItem("ShouldUpdateShiftDetails", true);
                sessionStorage.setItem("ShouldUpdateShifts", true);

                jqtouch.goBack();
                removeLoading();
            }, "json");
        }
        else {
            showPopup("Please select the start time.", false);
        }
    });

    function LoadFormData() {
        //get this shift details from the SessionStorage
        var editShiftData = sessionStorage.getItem("EditShiftData");

        if (editShiftData != null) {
            var result = JSON.parse(editShiftData);

            var StartDate = result.StartDate + " " + result.StartTime;
            var EndDate = result.EndDate + " " + result.EndTime;

            //set values for StartDate and EndDate
            var startDateElement = $("#editShiftTimes #StartDate");
            startDateElement.val(StartDate);

            if (result.EndDate != "-") {
                $("#editShiftTimes #EndDate").val(EndDate);
                $("#editShiftTimes #EndDateFake").val(EndDate);
            }
        }

        //add "mobiscroll" plugin to show date picker
        var dateFields = $("#editShiftTimes #StartDate,#editShiftTimes #EndDate,#editShiftTimes #EndDateFake");
        dateFields.mobiscroll().datetime(mobiscrollDateOptions);
    }
});