﻿$.fn.serializeObject = function () {
	var o = {};
	var a = this.serializeArray();
	$.each(a, function () {
		if (o[this.name] !== undefined) {
			if (!o[this.name].push) {
				o[this.name] = [o[this.name]];
			}
			o[this.name].push(this.value || '');
		} else {
			o[this.name] = this.value || '';
		}
	});
	return o;
};

//format a number to money string (3876.4511 will be "3,876.45")
Number.prototype.formatMoney = function (c, d, t) {
	var n = this,
    c = isNaN(c = Math.abs(c)) ? 2 : c,
    d = d == undefined ? "." : d,
    t = t == undefined ? "," : t,
    s = n < 0 ? "-" : "",
    i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "",
    j = (j = i.length) > 3 ? j % 3 : 0;
	return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
};

//show mobile popup with the relevant message (success or failed)
function showPopup(message, success, alwaysVisible) {
	var popupDiv = $("<div class='popup'>" + message + "</div>");

	if (success) {
		popupDiv.addClass("successPopup");
	}
	else {
		popupDiv.addClass("failedPopup");
	}

	popupDiv.appendTo("#jqt .current");

	if (alwaysVisible != true) {
		window.setTimeout(function () {
			popupDiv.remove();

			//force redraw of the UI (Android bug that don't remove the popup)
			var n = document.createTextNode(' ');
			$('#jqt .current h1').append(n);
			setTimeout(function () { n.parentNode.removeChild(n) }, 0);
		}, 3000);
	}
}

//show mobile popup with the relevant message (success or failed)
function showSmallPopup(message, success) {
	var popupDiv = $("<div class='popupSmall'>" + message + "</div>");

	if (success) {
		popupDiv.addClass("successPopup");
	}
	else {
		popupDiv.addClass("failedPopup");
	}

	popupDiv.appendTo("#jqt .current");
	popupDiv.addClass("show");

	window.setTimeout(function () {
		popupDiv.remove();

		//force redraw of the UI (Android bug that don't remove the popup)
		var n = document.createTextNode(' ');
		$('#jqt .current h1').append(n);
		setTimeout(function () { n.parentNode.removeChild(n) }, 0);
	}, 4500);
}

//show modal dialog
function showDialog(popupDiv, id, isWizard) {
	//var docHeight = $(document).height();
	var fullScreenOverlay = $("<div class='fullScreenOverlay low'>");
	fullScreenOverlay.appendTo("#jqt .current");
	fullScreenOverlay.css("display", "block");

	var dialogContainer = $("<div class='dialog' id='" + id + "'></div>");

	//if this dialog is wizard
	if (isWizard != null) {
		if (isWizard == true) {
			dialogContainer = $("<div class='dialog show wizard' id='" + id + "'></div>");
		}
	}

	dialogContainer.appendTo("#jqt .current");
	dialogContainer.append(popupDiv);

	verticalCenterDialog();
	dialogContainer.addClass("show"); // show with animation
}

function verticalCenterDialog() {
	//set the dialog in the center
	var dialog = $("#jqt .dialog");
	var windowHeight = $(window).height();
	var dialogHeight = dialog.height();
	var top = (windowHeight - dialogHeight) / 2;
	dialog.css("top", top + "px");
}

/* Loading
-----------*/

var loadingTimer;

function showLoading() {
	if ($("#jqt .current .loadingImage").length == 0) {

		var randomID = Math.floor(Math.random() * 100);

		var loadingDiv = $("<div class='loadingImage' id='loading" + randomID + "'><span></span></div>");
		loadingDiv.appendTo("#jqt .current");

		var fullScreenOverlay = $("<div class='fullScreenOverlay' id='overlay" + randomID + "'>");
		fullScreenOverlay.appendTo("#jqt .current");
		fullScreenOverlay.css("display", "block");

		//remove this loadingImage and FullScreenOverlay in 6 seconds (in case that the loading is stuck for long time)
		window.clearTimeout(loadingTimer);
		loadingTimer = null;
		loadingTimer = window.setTimeout(function () {
			$("#jqt .loadingImage#loading" + randomID).remove();
			$("#jqt .fullScreenOverlay#overlay" + randomID).remove();
		}, 30000);
	}
}

function removeLoading() {
	$("#jqt .loadingImage").remove();
	$("#jqt .fullScreenOverlay").remove();
}

/* Bottom Menu
--------------*/

function showBottomMenu() {
	//show full screen overlay
	var fullScreenOverlay = $("<div class='fullScreenOverlay'>");
	fullScreenOverlay.appendTo("#jqt .current");
	fullScreenOverlay.css("display", "block");

	//show the bottomMenu
	$("#jqt .current .BottomMenu").show();
	window.setTimeout(function () {
		$("#jqt .current .BottomMenu").addClass("show");
	}, 500);
}

function showPopupMenu() {
	//show full screen overlay
	var fullScreenOverlay = $("<div class='fullScreenOverlay'>");
	fullScreenOverlay.appendTo("#jqt .current");
	fullScreenOverlay.css("display", "block");

	//show the PopupMenu
	$("#jqt .current .PopupMenu").addClass("show");

	window.setTimeout(function () {
		//when user click on the full screen overlay - hide the popup
		fullScreenOverlay.one("tap", function () {
			hidePopupMenu();
		});
	}, 600);
}

function hidePopupMenu() {
	//hide the PopupMenu
	$("#jqt .fullScreenOverlay").remove();

	$("#jqt .current .PopupMenu").removeClass("show");
}

/* Date and Time
-----------------*/

function ConvertDateToString(date) {
	var curr_day = date.getDate();
	var curr_month = date.getMonth() + 1;
	var curr_year = date.getFullYear();

	return curr_month + "/" + curr_day + "/" + curr_year;
}

function GetCurrentDate() {
	//get current date
	var currentDate = new Date();

	return ConvertDateToString(currentDate);
}

function GetCurrentTime() {
	//get current time
	var currentTime = new Date();

	var hours = currentTime.getHours();
	var minutes = currentTime.getMinutes();
	var ampm = hours >= 12 ? 'PM' : 'AM';
	hours = hours % 12;
	hours = hours ? hours : 12; // the hour '0' should be '12'
	minutes = minutes < 10 ? '0' + minutes : minutes;
	var timeStr = hours + ':' + minutes + ' ' + ampm;

	return timeStr;
}

//get date in regular format (12/31/2012) and convert to IOS format (2012-12-31)
function ConvertToIOSdate(date) {
	var dateParts = date.split('/');

	var month = dateParts[0];
	if (parseInt(month, 10) < 10) {
		month = "0" + month;
	}

	var day = dateParts[1];
	if (parseInt(day, 10) < 10) {
		day = "0" + day;
	}

	var year = dateParts[2];

	date = year + "-" + month + "-" + day;
	return date;
}

//get date in IOS format (2012-12-31) and convert to regular format (8/18/2012)
function ConvertFromIOSdate(date) {
	var year = date.substring(0, 4);
	var month = parseInt(date.substring(5, 7), 10);
	var day = parseInt(date.substring(8, 10), 10);
	date = month + "/" + day + "/" + year;
	return date;
}

//get datetime in regular format (12/31/2012 04:30 AM) and convert to IOS format (2012-12-31T04:30:00)
function ConvertToIOSdatetime(datetime) {
	var datetimeParts = datetime.split(' ');
	var date = datetimeParts[0];
	var time = datetimeParts[1];
	var amPm = datetimeParts[2];

	//convert the date
	var convertedDate = ConvertToIOSdate(date);

	//convert the time
	var timeParts = time.split(':');

	var hours = timeParts[0];

	if (amPm == "PM") {
		if (parseInt(hours, 10) < 12) {
			hours = parseInt(hours, 10) + 12;
		}
	}
	else if (amPm == "AM") {
		if (parseInt(hours, 10) == 12) {
			hours = 0;
		}
	}

	if (parseInt(hours, 10) < 10) {
		hours = "0" + parseInt(hours, 10);
	}

	var minutes = timeParts[1];
	if (parseInt(minutes, 10) < 10) {
		minutes = "0" + parseInt(minutes, 10);
	}

	datetime = convertedDate + "T" + hours + ":" + minutes + ":00";

	return datetime;
}

//get datetime in IOS format (2012-12-31T14:30:00) and convert to regular format (8/18/2012 04:30 AM)
function ConvertFromIOSdatetime(datetime) {
	var hours = datetime.substring(11, 13);
	var minutes = datetime.substring(14, 16);
	var ampm = parseInt(hours, 10) >= 12 ? 'PM' : 'AM';
	hours = hours % 12;
	hours = hours ? hours : 12; // the hour '0' should be '12'
	minutes = parseInt(minutes, 10) < 10 ? '0' + parseInt(minutes, 10) : minutes;
	var timeStr = hours + ':' + minutes + ' ' + ampm;

	var dateStr = ConvertFromIOSdate(datetime);
	datetime = dateStr + " " + timeStr;

	return datetime;
}

//calculate how many hours and minutes passed since specifiedDateTime
function TimeElapsed(specifiedDateTime) {
	//convert the SpecifiedDate to Date object
	var specifiedTime = ConvertToIOSdatetime(specifiedDateTime).replace('T', ' ');
	var specifiedTimeSplit = specifiedTime.split(/[- :]/);
	var specifiedTimeObject = new Date(specifiedTimeSplit[0], specifiedTimeSplit[1] - 1, specifiedTimeSplit[2], specifiedTimeSplit[3], specifiedTimeSplit[4], specifiedTimeSplit[5]);

	//get the current DateTime and convert to Date object
	var currentDateTime = GetCurrentDate() + " " + GetCurrentTime();
	var currentTime = ConvertToIOSdatetime(currentDateTime).replace('T', ' ');
	var currentTimeSplit = currentTime.split(/[- :]/);
	var currentTimeObject = new Date(currentTimeSplit[0], currentTimeSplit[1] - 1, currentTimeSplit[2], currentTimeSplit[3], currentTimeSplit[4], currentTimeSplit[5]);

	//calculate the time elapsed
	var timeDiff = currentTimeObject - specifiedTimeObject;
	var hours = Math.floor(timeDiff / 1000 / 60 / 60);

	var minutes = Math.floor(timeDiff / 1000 / 60);
	minutes = minutes - (60 * hours);

	if (hours > 24) {
		hours = 24;
	}

	if (hours < 0) {
		hours = 0;
		minutes = 0;
	}

	if (minutes < 10) { minutes = "0" + minutes; }

	return { "Hours": hours, "Minutes": minutes };
}

//get datetime object (in regular or IOS format) and increase minutes by 1 (to use in ShiftStart - ShiftEnd)
function AddOneMinute(datetime) {
	//if IOS format (2012-12-31T14:30:00)
	if (datetime.indexOf('-') >= 0) {
		var parts = datetime.split('T');
		var date = parts[0];
		var time = parts[1];

		var timeParts = time.split(':');
		var minutes = parseInt(timeParts[1]);
		if (minutes < 10) { minutes = "0" + minutes; }
		return date + "T" + timeParts[0] + ":" + minutes + ":00";
	}
		//if regular format (31/12/2012 14:30)
	else {
		var parts = datetime.split(' ');
		var date = parts[0];
		var time = parts[1];
		var ampm = parts[2];

		var timeParts = time.split(':');
		var minutes = parseInt(timeParts[1]);
		if (minutes < 10) { minutes = "0" + minutes; }
		return date + " " + timeParts[0] + ":" + minutes + " " + ampm;
	}
}

/* User Pay Periods (תקופות תשלום)
-------------------------------------*/

//find the specified user period according to the periodId
function GetPeriodByID(periodId) {
	var userPayPeriodsJSON = localStorage.getItem("PayPeriods");
	if (userPayPeriodsJSON != null) {
		var userPayPeriods = JSON.parse(userPayPeriodsJSON);

		for (var i = 0; i < userPayPeriods.length; i++) {
			if (userPayPeriods[i].UserPayPeriodID == periodId) {
				return userPayPeriods[i];
			}
		}
	}
}

//go to the next or previous period
function GoToPeriod(offset) {
	var currentPeriodID = sessionStorage.getItem("currentUserPeriodID");

	var userPayPeriodsJSON = localStorage.getItem("PayPeriods");
	if (userPayPeriodsJSON != null) {
		var userPayPeriods = JSON.parse(userPayPeriodsJSON);

		for (var i = 0; i < userPayPeriods.length; i++) {
			if (userPayPeriods[i].UserPayPeriodID == currentPeriodID) {
				if (userPayPeriods[i + offset] != null) {
					//change the current period to be the previous/next one
					sessionStorage.setItem("currentUserPeriodID", userPayPeriods[i + offset].UserPayPeriodID);
				}
			}
		}
	}
}

function GoToPreviousPeriod() {
	GoToPeriod(-1);
}

function GoToNextPeriod() {
	GoToPeriod(1);
}

/* Init User Pay Period (תקופת תשלום)
------------------------------------*/

function SetInitialUserPayPeriod() {
	//define the initial pay period that will be shown to the user when he open the application
	var userPayPeriodsJSON = localStorage.getItem("PayPeriods");
	if (userPayPeriodsJSON != null) {
		var userPayPeriods = JSON.parse(userPayPeriodsJSON);

		var currentPeriods;
		for (var i = 0; i < userPayPeriods.length; i++) {
			var period = userPayPeriods[i];
			var periodFromDate = new Date(period.FromDate);
			var periodToDate = new Date(period.ToDate);
			var today = new Date();
			today.setHours(0, 0, 0, 0);

			//check if this is the current period
			if (today >= periodFromDate && today <= periodToDate) {
				sessionStorage.setItem("currentUserPeriodID", period.UserPayPeriodID);
				sessionStorage.setItem("originalUserPeriodID", period.UserPayPeriodID);
			}
		}
	}

	//set initial month and year values (for calendar use)
	var curDate = new Date();
	var initialMonth = curDate.getMonth() + 1;
	var initialYear = curDate.getFullYear();
	sessionStorage.setItem("currentMonth", initialMonth);
	sessionStorage.setItem("currentYear", initialYear);
}

/* show the period label in the monthBar
------------------------------------------*/
function ShowCurrentPeriodLabel() {
	//get the current period
	var currentPeriodID = sessionStorage.getItem("currentUserPeriodID");
	var currentPeriod = GetPeriodByID(currentPeriodID);

	if (currentPeriod != null) {
		//set the period in the relevant label
		$("#jqt .current #currentPeriod #datesRange").html(currentPeriod.FromDate + " - " + currentPeriod.ToDate);
	}
}

/* Currency
-----------*/
function GetCurrencyName() {
	/*var currencyName = localStorage.getItem("CurrencyName");

    if (currencyName != null) {
    $("#jqt .current .currencyName").html(currencyName);
    return currencyName;
    }*/

	$("#jqt .current .currencyName").html("$");
	return "$";
}

/* Color Selector
-------------------*/

function InitColorsSelector(colorSelector) {
	//init the ShiftColorsSelector
	var colors = ["#ffffff", "#7d7d7d", "#303030", "#d8a48c", "#d8be8d", "#d7d88c", "#bed98c", "#a5d88d", "#8cd8cb", "#95b8de", "#8ba5d8", "#998dd9", "#be99c0"];

	for (var i = 0; i < colors.length; i++) {
		var colorItem = $("<li data-color='" + colors[i] + "' style='background-color:" + colors[i] + ";'>");
		if (i == 0) {
			colorItem.addClass("selected");
		}
		colorSelector.append(colorItem);
	}
}

/* show Month + Year label in the monthBar
------------------------------------------*/
function GetCurrentMonth() {
	//get the current month
	var month = parseInt(sessionStorage.getItem("currentMonth"), 10);
	if (month < 10) {
		month = "0" + month;
	}

	//set the month and year in the relevant label
	$("#jqt .current #currentPeriod #month").html(monthsNames[month]);
	$("#jqt .current #currentPeriod #year").html(sessionStorage.getItem("currentYear"));
}

//define the initial month&year that will be shown to the user when he open the application
function GetInitialMonthYear() {
	var date = new Date();
	var initialMonth = date.getMonth() + 1;
	var initialYear = date.getFullYear();

	return { "Month": initialMonth, "Year": initialYear };
}

/*
-------------------------*/

function UpdateCheckboxValue() {
	var id = $(this).attr("id");
	var hiddenField = $(this).siblings("input[name='" + id + "']");

	if ($(this).prop("checked")) {
		hiddenField.val("true");
	}
	else {
		hiddenField.val("false");
	}
}

function ShowDayName() {
	var date = $(this).val();

	//if there is value in the date field
	if (date != "") {
		//if contains "-" (IOS date format: yyyy-dd-mm)
		if (date.indexOf("-") >= 0) {
			date = date.substring(5, 7) + "/" + date.substring(8, 10) + "/" + date.substring(0, 4);
		}
			//if no IOS date format (mm/dd/yyyy)
		else {
			date = date.substring(3, 5) + "/" + date.substring(0, 2) + "/" + date.substring(6, 10);
		}

		var dateObj = new Date(date);
		var dayName = dayNames[dateObj.getDay()];
		$(this).siblings(".dayName").html(dayName);
	}
}

function BooleanToString(val) {
	if (val == true) {
		return "Yes";
	}
	return "No";
}

function ShortenString(str, length) {
	if (str.length > length) {
		return str.substring(0, length - 3) + "...";
	}
	return str;
}

/* News items
--------------*/

function CheckNewsItemsAlreadyRead() {
	//get the news items list
	var newsItemsJSON = localStorage.getItem("NewsItems");
	if (newsItemsJSON != null) {
		var newsItems = JSON.parse(newsItemsJSON);

		//get the list of news that have been already readed
		var newsItemsAlreadyReadJSON = localStorage.getItem("NewsItemsAlreadyRead");
		if (newsItemsAlreadyReadJSON != null) {
			var newsItemsAlreadyRead = JSON.parse(newsItemsAlreadyReadJSON);

			//loop through all news items
			for (var i = 0; i < newsItems.length; i++) {
				//if this news item has been readed already
				if (newsItemsAlreadyRead.indexOf(newsItems[i].NewsID) >= 0) {
					newsItems[i].AlreadyRead = true;
				}
				else {
					newsItems[i].AlreadyRead = false;
				}
			}
		}

		//save the news list in the local storage
		localStorage.setItem("NewsItems", JSON.stringify(newsItems));
	}
}

/* Iphone Calendar Plugin
-------------------------*/
function AddShiftToIphoneCalendar(shift) {
	//if the user want to add shifts to iPhone calendar
	/*if (localStorage.getItem("AddShiftsToCalendar") == "true") {

    if (shift != null) {
    if (shift.EndDate != null) {
    //Add this shift as Event in the iPhone Calendar
    window.plugins.calendarPlugin.createEvent(shift.Title, shift.Location, shift.Comments, shift.StartDate, shift.EndDate);
    }
    }
    }*/
}

/* Calendar Widget
-------------------*/
var dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];

$(document).ready(function () {

	function calendarWidget(el, params) {

		var now = new Date();
		var thisday = now.getDate();
		var thismonth = now.getMonth();
		var thisyear = now.getYear() + 1900;

		var opts = {
			month: thismonth,
			year: thisyear
		};

		$.extend(opts, params);

		var monthNames = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

		month = i = parseInt(opts.month);
		year = parseInt(opts.year);
		var m = 0;

		// next month
		if (month == 11) {
			var next_month = '<a href="?month=' + 1 + '&amp;year=' + (year + 1) + '" title="' + monthNames[0] + ' ' + (year + 1) + '">' + monthNames[0] + ' ' + (year + 1) + '</a>';
		} else {
			var next_month = '<a href="?month=' + (month + 2) + '&amp;year=' + (year) + '" title="' + monthNames[month + 1] + ' ' + (year) + '">' + monthNames[month + 1] + ' ' + (year) + '</a>';
		}

		// previous month
		if (month == 0) {
			var prev_month = '<a href="?month=' + 12 + '&amp;year=' + (year - 1) + '" title="' + monthNames[11] + ' ' + (year - 1) + '">' + monthNames[11] + ' ' + (year - 1) + '</a>';
		} else {
			var prev_month = '<a href="?month=' + (month) + '&amp;year=' + (year) + '" title="' + monthNames[month - 1] + ' ' + (year) + '">' + monthNames[month - 1] + ' ' + (year) + '</a>';
		}

		$("h3#current-month").html(monthNames[month] + ' ' + year);

		var table = $('<table class="calendar-month " ' + 'id="calendar-month' + i + ' " cellspacing="0">');

		var headerRow = $("<tr>");
		for (d = 0; d < 7; d++) {
			headerRow.append('<th class="weekday">' + dayNames[d] + '</th>');
		}
		table.append(headerRow);

		var days = getDaysInMonth(month, year);
		var firstDayDate = new Date(year, month, 1);
		var firstDay = firstDayDate.getDay();

		var prev_days = getDaysInMonth(month, year);
		var firstDayDate = new Date(year, month, 1);
		var firstDay = firstDayDate.getDay();

		var prev_m = month == 0 ? 11 : month - 1;
		var prev_y = prev_m == 11 ? year - 1 : year;
		var prev_days = getDaysInMonth(prev_m, prev_y);
		firstDay = (firstDay == 0 && firstDayDate) ? 7 : firstDay;

		var next_m = month == 11 ? 0 : month + 1;

		var nextMonthDay = 0;
		var weekRow = $("<tr>");

		//loop through the days
		for (j = 0; j < 42; j++) {
			//if this day is BEFORE the current month's days
			if ((j < firstDay)) {
				var currentDay = (prev_days - firstDay + j + 1);
				var date = getDateOfDayMonthYear(currentDay, prev_m, year);
				var dayCell = $('<td class="other-month" data-date="' + date + '"><span class="day">' + currentDay + '</span></td>');
			}
				//if this day is AFTER the current month's days
			else if ((j >= firstDay + getDaysInMonth(month, year))) {
				nextMonthDay = nextMonthDay + 1;
				var date = getDateOfDayMonthYear(nextMonthDay, next_m, year);
				var dayCell = $('<td class="other-month" data-date="' + date + '"><span class="day">' + nextMonthDay + '</span></td>');
			}
				//if this day is in this current month
			else {
				var currentDay = (j - firstDay + 1);
				var currentDayClass = "";

				//if this is the current day
				if (currentDay == thisday && month == thismonth) {
					currentDayClass = "current-day";
				}
					//if this is weekend
				else if (j % 7 == 6 || j % 7 == 0) {
					//currentDayClass = "weekend";
				}

				var date = getDateOfDayMonthYear(currentDay, month, year);
				var dayCell = $('<td class="current-month ' + currentDayClass + '" data-date="' + date + '"><span class="day">' + currentDay + '</span></td>');
			}

			//add this day to the week row
			weekRow.append(dayCell);

			//if the end of the week
			if (j % 7 == 6) {
				//start a new row
				table.append(weekRow);
				weekRow = $("<tr>");
			}
		}

		table.find("tr:not(:first-child)").each(function () {
			if ($(this).find(".current-month").length == 0) {
				$(this).remove();
			}
		});

		el.empty();
		el.append(table);
	}

	function getDaysInMonth(month, year) {
		var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
		if ((month == 1) && (year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0))) {
			return 29;
		} else {
			return daysInMonth[month];
		}
	}

	function getDateOfDayMonthYear(day, month, year) {
		month = month + 1;
		//if (day < 10) { day = "0" + day; }
		//if (month < 10) { month = "0" + month; }

		var date = month + "/" + day + "/" + year;
		return date;
	}

	// jQuery plugin initialisation
	$.fn.calendarWidget = function (params) {
		calendarWidget(this, params);
		return this;
	};
});
