﻿var appVersion = "1.0.5";
//var pathPrefix = "../";
var pathPrefix = "http://www.asifapps.com/SalaryUS/";
var platform = "firefox"; // android /ios/firefox

var jqtouchOptions = {
	icon: 'jqtouch.png',
	statusBar: 'black',
	cacheGetRequests: true,
	backSelector: '.back, .goback',
	preloadImages: []
};

if (platform == "firefox") {
	jqtouchOptions.useFastTouch = false;
}

var jqtouch = $.jQTouch(jqtouchOptions);

sessionStorage.setItem("PhoneGapLoaded", false);
sessionStorage.setItem("JqueryLoaded", false);

var monthsNames = { "01": 'January', "02": 'February', "03": 'March', "04": 'April', "05": 'May', "06": 'June', "07": 'July', "08": 'August', "09": 'September', "10": 'October', "11": 'November', "12": 'December' };
var shortMonthsNames = { "01": 'Jan', "02": 'Feb', "03": 'Mar', "04": 'Apr', "05": 'May', "06": 'Jun', "07": 'Jul', "08": 'Aug', "09": 'Sep', "10": 'Oct', "11": 'Nov', "12": 'Dec' };

/* mobiscroll initalization options
------------------------------------*/

var mobiscrollDateOptions = {
	theme: "android-ics", // android-ics OR ios
	display: "bottom",
	mode: "scroller",
	dateOrder: "D MMdyy",
	dateFormat: "m/d/yy",
	timeFormat: "h:ii A",
	timeWheels: "hiiA",
	monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
	dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	cancelText: "Cancel",
	setText: "Set"
};

if (platform == "android") {
	mobiscrollDateOptions.theme = "android-ics";
}
else {
	mobiscrollDateOptions.theme = "ios";
}

/* PHONEGAP
--------------------------------*/

document.addEventListener("deviceready", onDeviceReady, false);

// PhoneGap is loaded and it is now safe to make calls PhoneGap methods
function onDeviceReady() {
	sessionStorage.setItem("PhoneGapLoaded", true);
	CheckIfInternetConnection();

	//save the user's device (OS and version)
	localStorage.setItem("Device", device.platform + " " + device.version);

	//count the Startup times of the app in the user's device
	var startupCounter = localStorage.getItem("StartupCounter");
	if (startupCounter == null) {
		startupCounter = 0;
	}
	else {
		startupCounter = parseInt(startupCounter);
	}
	startupCounter++;
	localStorage.setItem("StartupCounter", startupCounter);

	//if the app has been launched 8 times in this device 
	if (startupCounter == 8) {
		//if the user not selected "Never Show RateUs"
		if (localStorage.getItem("NeverShowRateUs") != true) {
			window.setTimeout(function () {
				//show RateUs alert
				navigator.notification.confirm(
                    'Do you find the application useful? Rate us in the Store and recommend it to other users.',  // message
                    function (button) {
                    	if (button == 1) {
                    		localStorage.setItem("NeverShowRateUs", true);
                    		window.location = pathPrefix + 'Contact/RateApp?platform=' + platform; // go to rate page
                    	}
                    	else if (button == 2) {
                    		localStorage.setItem("NeverShowRateUs", true);
                    	}
                    	else if (button == 3) {
                    		localStorage.setItem("StartupCounter", 0);
                    	}
                    },
                    'Rate Us',            // title
                    'Rate Us,Don\'t Ask,Ask me later'          // buttonLabels
                );
			}, 10000);
		}
	}

	/* iOS7 status bar is placed over the app content, so we need to show a bigger toolbar */
	if (window.device.platform == "iOS" && parseFloat(window.device.version) >= 7.0) {
		var rootClass = document.getElementById("jqt").className;
		document.getElementById("jqt").className = rootClass + " ios7plus";
	}
	navigator.splashscreen.hide();

	//when the app is being resumed from background
	document.addEventListener("resume", onResume, false);

	//when the user clicks on "Menu" button (android only)
	document.addEventListener("menubutton", onMenuButtonDown, false);

	//when the user clicks on "Back" button (android only)
	document.addEventListener("backbutton", onBackButtonDown, false);
}

//when the app is being resumed from background
function onResume() {
	var UniqueGuid = localStorage.getItem("UserUniqueGuid");

	if (UniqueGuid != null) {
		var internetConnection = sessionStorage.getItem("InternetConnection");

		//INTERNET CONNECTION
		if (internetConnection == "true") {
			var data = { "UniqueGuid": UniqueGuid, "AppVersion": appVersion, "Device": localStorage.getItem("Device") };

			//login the user again to the server
			$.post(pathPrefix + "Users/AutoLogin", data, function (result) {
			}, "json");
		}
			//NO INTERNET CONNECTION
		else {
			AutoLoginUser();
		}
	}

	//wait a bit and check if there is internet
	window.setTimeout(function () {
		CheckIfInternetConnection();
	}, 1500);

	// if currently in the MonthlyShifts page
	if ($("#jqt .current").attr("id") == "monthlyShifts") {
		$("#monthlyShifts").trigger("resumeOfApp");
	}
}

//when the user click the "Menu Button" on Android
function onMenuButtonDown() {
	var UniqueGuid = localStorage.getItem("UserUniqueGuid");

	//check the "localStorage" if the user is login
	if (UniqueGuid != null) {
		//if not already in the "menu" page
		if ($("#jqt .current").attr("id") != "menu") {
			//go to the menu page
			jqtouch.goTo("Menu.html", "slideup");
		}
	}
}

//when the user click the "Back Button" on Android
function onBackButtonDown() {
	var UniqueGuid = localStorage.getItem("UserUniqueGuid");

	//check the "localStorage" if the user is login
	if (UniqueGuid != null) {

		//if there is a popup menu open - close it
		if ($("#jqt .current .PopupMenu.show").length > 0) {
			hidePopupMenu();
			return;
		}

		//only if the prev page is not home
		if (jqtouch.history[1].id != "home") {
			jqtouch.goBack();
		}
	}
		//if not login
	else {
		jqtouch.goBack();
	}
}

function CheckIfInternetConnection() {
	var phonegapLoaded = sessionStorage.getItem("PhoneGapLoaded");
	var jqueryLoaded = sessionStorage.getItem("JqueryLoaded");

	sessionStorage.setItem("InternetConnection", true);

	//check if both PhoneGap and Jquery has been loaded
	if (phonegapLoaded == "true" && jqueryLoaded == "true") {
		var networkState = navigator.network.connection.type;

		//NO INTERNET CONNECTION
		if (/*networkState == Connection.UNKNOWN ||*/ networkState == Connection.NONE) {
			sessionStorage.setItem("InternetConnection", false);

			var UniqueGuid = localStorage.getItem("UserUniqueGuid");

			//check the "localStorage" if the user is login
			if (UniqueGuid != null) {
				jqtouch.goTo("OfflineMode.html");
			}
			else {
				showPopup("The application requires Internet Connection.<br />Check your connection and try to reopen the app.", false, true);
			}

			removeLoading();
		}
			//INTERNET CONNECTION
		else {
			//remove the popup about "no internet"
			$("#jqt .current .popup").remove();
		}
	}
}

/*---------------------------------*/

function InvokeWaitingAjaxCalls(callbackFunction) {
	//check if there are waiting ajax calls
	var waitingAjaxCallsValue = localStorage.getItem("WaitingAjaxCalls");
	if (waitingAjaxCallsValue != null) {
		var waitingAjaxCalls = JSON.parse(waitingAjaxCallsValue);

		if (waitingAjaxCalls.length > 0) {
			//loop through all the AjaxCalls waiting for being invoked (now that the app is online)
			for (var i = 0; i < waitingAjaxCalls.length; i++) {
				var lastCall = false;
				if (i == (waitingAjaxCalls.length - 1)) {
					lastCall = true;
				}

				//Invoke AJAX method
				$.post(waitingAjaxCalls[i].Action, waitingAjaxCalls[i].Data, function (result) {

					if (lastCall) {
						callbackFunction();
					}

				}, "json");
			}

			showPopup("Syncing offline mode shifts...", true);
		}
		else {
			callbackFunction();
		}

		localStorage.removeItem("WaitingAjaxCalls");
	}
	else {
		callbackFunction();
	}
}

//get the settings of this user from DB (Currency, AddShiftsToCalendar, etc) - save in localStorage
//these general settings will be used across the application pages
function GetUserSettings() {
	$.getJSON(pathPrefix + "Users/GetUserSettings", function (settings) {
		localStorage.setItem("UserUniqueGuid", settings.UniqueGuid);
		localStorage.setItem("CurrencyName", settings.CurrencyName);
		localStorage.setItem("HourSalary", settings.HourSalary);
		localStorage.setItem("DailySalary", settings.DailySalary);
		localStorage.setItem("AddShiftsToCalendar", settings.AddShiftsToCalendar);
		localStorage.setItem("CalendarLTR", settings.CalendarLTR);
		localStorage.setItem("ShowShiftDetailsAfterInsertion", settings.ShowShiftDetailsAfterInsertion);
		localStorage.setItem("IsUserHaveMonthlyBonuses", settings.IsUserHaveMonthlyBonuses);
	});
}

function AddUserPayPeriodsIfNeccesery(callback) {
	//Invoke AJAX method to Add User PayPeriods If Neccesery
	$.post(pathPrefix + "UserPayPeriods/AddUserPayPeriodsIfNeccesery", null, function (payPeriods) {
		//save the pay periods of this user
		localStorage.setItem("PayPeriods", JSON.stringify(payPeriods));
		if (callback != null) {
			callback();
		}
	}, "json");
}

// login the user automatically (if he was login before) - "remember me" feature
function AutoLoginUser() {
	var UniqueGuid = localStorage.getItem("UserUniqueGuid");

	var data = { "UniqueGuid": UniqueGuid, "AppVersion": appVersion, "Device": localStorage.getItem("Device") };

	showLoading();

	//check the "localStorage" if the user is login
	if (UniqueGuid != null) {
		$.post(pathPrefix + "Users/AutoLogin", data, function (result) {
			//user is login - redirect him to the specified page
			if (result.Key) {
				InvokeWaitingAjaxCalls(function () {
					jqtouch.goTo(result.Redirect);

					window.setTimeout(function () {
						//removeLoading();
					}, 2000);
				});

				GetUserSettings();

				AddUserPayPeriodsIfNeccesery();
			}
				//user not login
			else {
				removeLoading();
			}
		}, "json").error(function () {
			removeLoading();
		});
	}
	else {
		removeLoading();
	}
}

/* Number Textboxes
--------------------*/

function InitNumberTextboxes(page) {
	var numberElements = page.find("input[type=number]:not(.noInit),input[type=tel]:not(.noInit)");

	//if there are number elements in the page
	if (numberElements.length > 0) {
		numberElements.each(function () {
			var listItem = $(this).parents("li");

			//if there is label (or the numberElement has "small" class)
			if (listItem.children("label").length > 0 || $(this).hasClass("small")) {
				$(this).wrap("<div class='numberContainer' data-element='" + $(this).attr("id") + "'>");
				var container = $(this).parent(".numberContainer");
				container.append("<div class='numDown'>-</div>");
				container.prepend("<div class='numUp'>+</div>");

				listItem.addClass("numberContainerIncluded");
			}
				//there is NO label
			else {
				listItem.append("<div class='numDown'>-</div>");
				listItem.prepend("<div class='numUp'>+</div>");
			}
		});

		page.data("numberLoaded", true);
	}
}

/* Native Date selectors
--------------------------*/

function UpdateNativeDateSelectors() {
	//update the values of the native date selectors (iOS and firefox only)
	if (platform == "ios" || platform == "firefox") {
		//loop through the native date selectors
		$("#jqt .current input.nativeDateSelector").each(function () {
			var forElementId = $(this).attr("data-for");
			var dateElement = $(this).siblings("#" + forElementId);

			var regularDate = dateElement.val();
			var nativeFormatDate;

			if (regularDate != "") {
				if ($(this).attr("type") == "date") {
					// convert the regular date (31/12/2012) to native date (2012-12-31)
					nativeFormatDate = ConvertToIOSdate(regularDate);
				}
				else if ($(this).attr("type") == "time") {
					nativeFormatDate = regularDate;
				}
				else if ($(this).attr("type") == "datetime-local") {
					// convert the regular datetime (31/12/2012 14:30) to native datetime (2012-12-31T14:30:00)
					nativeFormatDate = ConvertToIOSdatetime(regularDate);
				}

				//update the native date element
				$(this).val(nativeFormatDate);
			}
		});
	}
}

/*---------------*/

var myScroll;

$(document).ready(function () {
	//default prefilter function for AJAX methods
	$.ajaxPrefilter(function (options) {
		if (options.xhrConstructParam) {
			options.xhr = function () {
				return new window.XMLHttpRequest(options.xhrConstructParam);
			}
		}
	});
	// fix for FirefoxOS bug (require "mozSystem" param in AJAX calls)
	var xhrConstructParam = null;
	if (platform == "firefox") {
		xhrConstructParam = {
			mozSystem: true
		};
	}

	//default settings for AJAX methods
	$.ajaxSetup({
		xhrConstructParam: xhrConstructParam,
		error: function (error) {
			// if the AJAX call is not "getShiftList"
			if (this.url.indexOf("GetShiftsList") < 0 && this.url.indexOf("MonthlySalary") < 0) {
				if (sessionStorage.getItem("InternetConnection") == "true") {
					//AJAX ERROR
					showPopup("An error occured during data processing.<br />Try to close the app and reopen it.<br /><br /><span style='font-size:12px;'>If the error reappear - contact us on AsifApps.com</span>", false);
				}
				removeLoading();
			}
		}
	});

	$("#jqt").addClass("platform_" + platform);

	sessionStorage.setItem("JqueryLoaded", true);
	CheckIfInternetConnection();

	ScrollingSupport();

	AutoLoginUser(); // login the user automatically (if he was login before) - "remember me" feature

	SetInitialUserPayPeriod();

	InitControls();

	PreloadImages();

	function PreloadImages() {
		var images = [
	        'css/images/icons/user.png',
	        'css/images/icons/salary.png',
            'css/images/icons/rates.png',
            'css/images/icons/settings.png',
            'css/images/icons/calendar.png',
            'css/images/icons/comments.png',
            'css/images/icons/graph.png',
            'css/images/icons/money.png',
            'css/images/icons/time.png',
            'css/images/icons/bonus.png',
            'css/images/icons/deduction.png',
            'css/images/icons/list.png',
            'css/images/icons/taxes.png'
		];

		$(images).each(function () {
			var image = $('<img />').attr('src', this);
		});
	}

	function InitControls() {
		//for every page that is being loaded
		$('#jqt').on('pageAnimationStart', 'div', function (event, info) {
			if (info.direction == 'in') {
				if ($(this).data("numberLoaded") != true) {
					InitNumberTextboxes($(this));
				}

				// fix for FirefoxOS bug (with display:none in class and "show()")
				if (platform == "firefox") {
					// replace "hidden" class with "display:none"
					$(this).find(".hidden:not(p)").removeClass("hidden").css("display", "none");
				}
			}
		});

		//when the user tap on number element - select all text
		$('#jqt').on('focus', 'input[type=number],input[type=tel]', function () {
			//select all text
			$(this)[0].setSelectionRange(0, 9999);
		});
		$('#jqt').on('mouseup', 'input[type=number],input[type=tel]', function (e) {
			return false;
		});

		//when the user tap on any button in Bottom Menu - close it
		$('#jqt').on('tap', '.BottomMenu a', function () {
			$("#jqt .fullScreenOverlay").remove();

			$("#jqt .current .BottomMenu").removeClass("show");
			window.setTimeout(function () {
				$("#jqt .current .BottomMenu").hide();
			}, 600);
		});

		//when the user tap on any button in Popup Menu - close it
		$('#jqt').on('tap', '.PopupMenu a', function () {
			hidePopupMenu();
		});

		/* Options Selector (AutoCalculated value OR Custom value)
        --------------------------*/

		//when changing the option in "OptionsSelector" - disable or enable the relevant textbox
		$("#jqt").on("tap", ".current .optionsSelector > div", function () {
			var toDisable = $(this).data("value");

			var textboxElementId = $(this).parent(".optionsSelector").data("for-input-id");
			var textboxElement = $("#jqt .current #" + textboxElementId);
			textboxElement.prop("disabled", toDisable);

			//highlight the selected
			$(this).siblings(".selected").removeClass("selected");
			$(this).addClass("selected");

			//if the user select to disable the textbox - bring back the Auto Calculated value
			if (toDisable) {
				var autoCalculatedValue = textboxElement.data("auto-value");
				textboxElement.val(autoCalculatedValue);
			}
			else {
			}
		});

		/* Colors Selector 
        -------------------*/

		//when click on a color
		$("#jqt").on("tap", ".current ol.ShiftColorsSelector li", function () {
			//highlight the selected color
			$(this).siblings(".selected").removeClass("selected");
			$(this).addClass("selected");

			//update the correspending hidden field
			var selectedColor = $(this).data("color");
			$(this).parent("ol.ShiftColorsSelector").siblings(":hidden#Color").val(selectedColor);
		});

		/* Dialog click events
        ------------*/

		$('#jqt').on('tap', '.dialog .close,.dialog .confirm', function () {
			$("#jqt .fullScreenOverlay").remove();

			//remove the dialog
			var dialogElement = $("#jqt .dialog");
			dialogElement.removeClass("show");
			window.setTimeout(function () {
				dialogElement.remove();
			}, 500);
		});

		/* Native Date selectors
        ---------------------------*/

		//after the user select a date (or datetime) in the native selector (ios only)
		$("#jqt").on("blur", "input.nativeDateSelector", function () {
			var forElementId = $(this).attr("data-for");
			var dateElement = $(this).siblings("#" + forElementId);

			var nativeFormatDate = $(this).val();
			var regularDate = "";

			if (nativeFormatDate != "") {
				if ($(this).attr("type") == "date") {
					// convert the native date (2012-12-31) to regular date (31/12/2012)
					regularDate = ConvertFromIOSdate(nativeFormatDate);
				}
				else if ($(this).attr("type") == "time") {
					regularDate = nativeFormatDate;
				}
				else if ($(this).attr("type") == "datetime-local") {
					// convert the native datetime (2012-12-31T14:30:00) to regular datetime (31/12/2012 14:30)
					regularDate = ConvertFromIOSdatetime(nativeFormatDate);
				}
			}

			//update the date element (which is the visible one)
			dateElement.val(regularDate).trigger("change");
		});

		/*---------------*/

		//define events for Number Up button
		$('#jqt').on('click', '.numUp', function () {
			clearInterval(this.interval);
		});

		//if "touchstart" event supported
		if ('ontouchstart' in document.documentElement) {
			$('#jqt').on('touchstart', '.numUp', function () {
				NumberMouseDown(this, "up");
			});
			$('#jqt').on('touchend', '.numUp', function () {
				clearInterval(this.interval);

				ShowHourRateTooltip(this);
			});
		}
		else {
			$('#jqt').on('mousedown', '.numUp', function () {
				NumberMouseDown(this, "up");
			});
			$('#jqt').on('mouseup', '.numUp', function () {
				clearInterval(this.interval);

				ShowHourRateTooltip(this);
			});
		}

		//define events for Number Down button
		$('#jqt').on('click', '.numDown', function () {
			clearInterval(this.interval);
		});

		//if "touchstart" event supported
		if ('ontouchstart' in document.documentElement) {
			$('#jqt').on('touchstart', '.numDown', function () {
				NumberMouseDown(this, "down");
			});
			$('#jqt').on('touchend', '.numDown', function () {
				clearInterval(this.interval);

				ShowHourRateTooltip(this);
			});
		}
		else {
			$('#jqt').on('mousedown', '.numDown', function () {
				NumberMouseDown(this, "down");
			});
			$('#jqt').on('mouseup', '.numDown', function () {
				clearInterval(this.interval);

				ShowHourRateTooltip(this);
			});
		}
	}

	$('#jqt').on('blur', '.rateTextbox', function () {
		var numUp = $(this).siblings(".numUp")[0];
		ShowHourRateTooltip(numUp);
	});

	function NumberMouseDown(sender, change) {
		var element = $(sender);
		var numberElement = element.siblings("input[type=number],input[type=tel]");

		if (numberElement.prop("disabled") == false) {
			ChangeNumberValue(element, change);

			var delayedOnce = false;
			var date = new Date();
			var curDate = null;
			var slowChangeCount = 0;

			sender.interval = setInterval(function () {
				curDate = new Date();
				if (!delayedOnce) {
					if (curDate - date > 500) delayedOnce = true;
				}
				else {
					if (slowChangeCount % 4 == 0 || curDate - date > 3000) {
						ChangeNumberValue(element, change);
					}
					slowChangeCount++;
				}
			}, 20);
		}
	}

	function ChangeNumberValue(sender, change) {
		var numberElement = sender.siblings("input[type=number],input[type=tel]");
		var step = parseFloat($(numberElement).attr("step"));
		var min = parseFloat($(numberElement).attr("min"));
		var max = parseFloat($(numberElement).attr("max"));

		//get the current number value
		var curValue = numberElement.val();
		if (curValue == "") {
			curValue = min;
			numberElement.val(min);
		}

		//define the step (according to attribute) - plus or minus
		if (change == "down") {
			step = -step;
		}

		//set the new value
		var newValue = parseFloat(curValue) + step;
		//check that the value is in range
		if (newValue >= min && newValue <= max) {

			//if this is float - round it to 1 digit after dot
			if (newValue.toString().indexOf(".") >= 0) {
				newValue = newValue.toFixed(2);
			}

			//if this have "," - remove it
			if (newValue.toString().indexOf(",") >= 0) {
				newValue = newValue.replace(",", "");
			}
			numberElement.val(newValue);
		}
		else {
			if (newValue < min) {
				numberElement.val(min);
			}
			else if (newValue > max) {
				numberElement.val(max);
			}
		}
	}

	var smallTooltipShowTimeout;
	var smallTooltipAnimateTimeout;
	var smallTooltipHideTimeout;

	//this function will be called after the user changes the value in a Rate field (שדה תעריף)
	function ShowHourRateTooltip(sender) {
		var numberElement = $(sender).siblings("input[type=number],input[type=tel]");
		var rateValue = numberElement.val();

		//check if this number textbox is Rate (שדה מסוג תעריף)
		if (numberElement.hasClass("rateTextbox")) {
			var hourSalary = localStorage.getItem("HourSalary");
			var currency = localStorage.getItem("CurrencyName");

			if (hourSalary != null) {
				hourSalary = parseFloat(hourSalary);
				var newHourSalary = (hourSalary * (rateValue));
				var text = "Per hour: " + currency + newHourSalary.toFixed(2);
				var smallTooltipDiv = $("#jqt .current .smallTooltip");
				smallTooltipDiv.html(text);

				//if the number textbox is a small one
				if (numberElement.hasClass("small")) {
					smallTooltipDiv.addClass("forSmallTextbox");
				}
				else {
					smallTooltipDiv.removeClass("forSmallTextbox");
				}

				//set the position of the tooltip
				numberElement.after(smallTooltipDiv);
				smallTooltipDiv.show();

				clearTimeout(smallTooltipShowTimeout);
				clearTimeout(smallTooltipAnimateTimeout);
				clearTimeout(smallTooltipHideTimeout);

				//show the small tooltip with the new HourSalary for this selected rate
				smallTooltipShowTimeout = window.setTimeout(function () {
					smallTooltipDiv.addClass("show");
				}, 0);
				smallTooltipAnimateTimeout = window.setTimeout(function () {
					smallTooltipDiv.removeClass("show");
				}, 1500);
				smallTooltipHideTimeout = window.setTimeout(function () {
					smallTooltipDiv.hide();
				}, 2000);
			}
		}
	}

	function ScrollingSupport() {
		// Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
		if (!Modernizr.overflowscrolling) {
			$('#jqt').on('pageAnimationEnd', '#about,#newUser,#news,#settings,#generalInfoContent,#quickSalary,#quickSalaryCalc,#presetShiftsManager,#presetShiftsSelect,#workingPlans,#addUserRateType,#editShiftRate,#addPaymentDay,#userRateTypesManager', function (e, info) { // Destroy and re-create the iScroll object on every navigation
				if (info.direction == 'in') {
					if (myScroll) { myScroll.destroy(); }

					var wrapperId = e.target.id + "wrapper";

					$(this).children(".scroll").wrap('<div id="scroller">'); //Adds the wrapper div
					$(this).children('#scroller').wrap('<div id="' + wrapperId + '" style="position: absolute;z-index: 1;top:44px;bottom: 0px;left: 0px;right: 0px;">'); // Adds the scroller div *inside* the wrapper div

					setTimeout(function () {
						myScroll = new iScroll(wrapperId, {
							onBeforeScrollStart: function (e) {
								var target = e.target;
								while (target.nodeType != 1) target = target.parentNode;

								if (target.tagName != 'SELECT' && target.tagName != 'INPUT' && target.tagName != 'TEXTAREA') {
									e.preventDefault();
								}
							}
						});
					}, 0);
				}
			});
		}
	}
});