﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#login', function (event, info) {
        if (info.direction == 'in') {

            //load Email from localStorage
            var rememberEmail = localStorage.getItem("RememberEmail");
            if (rememberEmail != null) {
                $("#login #Email").val(rememberEmail);
            }
        }
    });

    $("#jqt").on("tap", "#login #btnLogin", function () {
        var user = $("#login form").serializeObject();

        //validate required fields
        if (user.Email != "" && user.Password != "") {
            showLoading();

            user.AppVersion = appVersion;
            user.Device = localStorage.getItem("Device");

            //Invoke AJAX method to login this user
            $.post(pathPrefix + "Users/Login", user, function (result) {
                showPopup(result.Value, result.Key);

                //if success
                if (result.Key) {
                    localStorage.setItem("Email", user.Email);
                    localStorage.setItem("RememberEmail", user.Email);

                    //redirect to the specified page
                    window.setTimeout(function () {
                        removeLoading();

                        jqtouch.goTo(result.Redirect, 'slideleft');
                    }, 4000);

                    GetUserSettings();

                    AddUserPayPeriodsIfNeccesery();
                }
                else {
                    localStorage.removeItem("Email");

                    removeLoading();
                }
            }, "json");
        }
        else {
            showPopup("Please enter Email and Password.", false);
        }
    });

    //when click on Forgot Password - show Confirm Dialog
    $("#jqt").on("tap", "#login #btnForgotPassword", function () {
        var user = $("#login form").serializeObject();

        if (user.Email != "") {
            showDialog("<div class='title'>Forgot Password<span class='close'>X</span></div><div class='content'>Do you want to reset your password and get a new one?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "ForgotPasswordDialog");
        }
        else {
            showPopup("Please enter your Email Address.", false);
        }
    });
    $("#jqt").on("tap", "#login #ForgotPasswordDialog .confirm", function () {
        var user = $("#login form").serializeObject();

        showLoading();

        //Invoke AJAX method to send password mail this user
        $.post(pathPrefix + "Users/ForgotPassword", user, function (result) {
            showPopup(result.Value, result.Key);

            removeLoading();
        }, "json");
    });
});