﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#menu', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    //Define Scroller
                    var wrapperId = "menuScroll";
                    $(this).children(".scroll").wrap('<div id="scroller">'); //Adds the wrapper div
                    $(this).children('#scroller').wrap('<div id="' + wrapperId + '" style="position: absolute;z-index: 1;top:297px;bottom: 48px;left: 0px;right: 0px;">'); // Adds the scroller div *inside* the wrapper div

                    //change positions settings of other elements to support the iScroll
                    $("#menu .scroll").css({ marginRight: "0px", marginLeft: "0px", marginBottom: "0px", marginTop: "0px", border: "0px" });
                    $("#menu .info").css({ position: 'absolute', bottom: "0px", left: "0px", right: "0px" });
                    $("#menu #menuItems").after("<ul class='edgetoedge' style='position:absolute;bottom:40px;top:297px;left:0px;right:0px;'><li></li></ul>");

                    setTimeout(function () {
                        $("#menu").data("scroller", new iScroll(wrapperId));
                    }, 0);
                }

                $(this).data("loaded", true);
            }

            //only on Android - show the "CloseApp" button
            if (platform == "android") {
                $("#menu #btnCloseApp").show();
            }

            //show the current user's details
            $("#menu .email").html(localStorage.getItem("Email"));
            $("#menu #CurrentProfileName").html(localStorage.getItem("ProfileName"));
        }
    });

    //when this page loads first time (on animation END)
    $('#jqt').on('pageAnimationEnd', '#menu', function (event, info) {
        if (info.direction == 'in') {

            //Invoke AJAX method to get the list of news
            $.getJSON(pathPrefix + "News/GetNews", function (result) {
                //save the news list in the local storage
                localStorage.setItem("NewsItems", JSON.stringify(result));

                CheckNewsItemsAlreadyRead();

                //calculate how many unread news this user has
                var unreadNewsCount = result.length;

                var newsItems = JSON.parse(localStorage.getItem("NewsItems"));
                for (var i = 0; i < newsItems.length; i++) {
                    if (newsItems[i].AlreadyRead) {
                        unreadNewsCount--;
                    }
                }

                //show the count of unread news items
                if (unreadNewsCount > 0) {
                    $("#menu #UnreadNewsItemsCount").html(unreadNewsCount).show();
                }
                else {
                    $("#menu #UnreadNewsItemsCount").hide();
                }
            });
        }
    });

    //when user click User Options Menu - open the BottomMenu
    $("#jqt").on("tap", "#menu #btnUserOptionsMenu", function () {
        showPopupMenu();
    });

    //when click on Logout - show Confirm Dialog
    $("#jqt").on("tap", "#menu #Logout", function () {
        showDialog("<div class='title'>Logout<span class='close'>X</span></div><div class='content'>Are you sure you want to logout?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "LogoutDialog");
    });
    $("#jqt").on("tap", "#menu #LogoutDialog .confirm", function () {
        localStorage.removeItem("Email");
        localStorage.removeItem("ProfileName");
        localStorage.removeItem("UserUniqueGuid");
        MonthlyShiftsHelper.clearLocalStorageData();

        //Invoke AJAX method to logout the user (empty the session)
        $.post(pathPrefix + "Users/Logout", null, function () {
            jqtouch.goTo("#home");
        }, "json");
    });

    //when click on CloseApp - show CloseApp Dialog
    $("#jqt").on("tap", "#menu #btnCloseApp", function () {
        showDialog("<div class='title'>Quit<span class='close'>X</span></div><div class='content'>Do you want to quit the app?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "CloseAppDialog");
    });
    $("#jqt").on("tap", "#menu #CloseAppDialog .confirm", function () {
        navigator.app.exitApp();
    });

    //show welcome wizard
    $("#jqt").on("tap", "#menu #WelcomeWizard", function () {
        localStorage.removeItem("sawWelcomeWizard");

        jqtouch.goBack();
    });
});