﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#monthlyShifts', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {

                    //Define Scroller
                    var wrapperId = "shiftsScroll";
                    $(this).children(".scroll").wrap('<div id="scroller">'); //Adds the wrapper div
                    $(this).children('#scroller').wrap('<div id="' + wrapperId + '" class="ShiftsListView" style="position: absolute;z-index: 1;top:128px;bottom: 97px;left: 10px;right: 10px;">'); // Adds the scroller div *inside* the wrapper div

                    //change positions settings of other elements to support the iScroll
                    $("#monthlyShifts #ShiftsFooter").css({ position: 'absolute', bottom: "0px", left: "0px", right: "0px" });
                    $("#monthlyShifts #buttonsContainer").css({ position: 'absolute', bottom: "0px", left: "0px", right: "0px" });
                    $("#monthlyShifts #ShiftsList").css({ marginRight: "0px", marginLeft: "0px" });
                    $("#monthlyShifts #ShiftsHeader").after("<ul class='rounded ShiftsListView' style='position:absolute;bottom:41px;top:105px;left:0px;right:0px;'><li></li></ul>");

                    setTimeout(function () {
                        $("#monthlyShifts").data("scroller", new iScroll(wrapperId));
                    }, 0);
                }

                SetInitialUserPayPeriod();

                $(this).data("loaded", true);
            }
        }
    });

    //when this page loads first time (Animation END)
    $('#jqt').on('pageAnimationEnd', '#monthlyShifts', function (event, info) {
        if (info.direction == 'in') {

            // according to the view - show period label
            var selectedView = localStorage.getItem("MonthlyShiftsView");
            if (selectedView != null) {
                $("#monthlyShifts .MonthBar").attr("data-mode", selectedView);
                if (selectedView == "list") {
                    ShowCurrentPeriodLabel();
                }
                else if (selectedView == "calendar") {
                    GetCurrentMonth();
                }
            }
            else {
                // define the default View - list
                localStorage.setItem("MonthlyShiftsView", "list");
                ShowCurrentPeriodLabel();
            }

            //only on the first load - GetShiftsList
            if (!$(this).data("loadedAnimationEnd")) {
                //show full loading when fetching the shifts
                sessionStorage.setItem("MonthlyShiftsFullLoading", true);

                DrawCurrentMonthCalendar();
                GetShiftsList();
                sessionStorage.removeItem("ShouldUpdateShifts");

                $(this).data("loadedAnimationEnd", true);
            }

            //show the current profile name (or hide it, if there is no special profile)
            var profileName = localStorage.getItem("ProfileName");
            if (profileName != null) {
                $("#monthlyShifts .toolbar .desc").html(profileName);
                $("#monthlyShifts .toolbar h1").addClass("withDesc");
            }
            else {
                $("#monthlyShifts .toolbar .desc").html("");
                $("#monthlyShifts .toolbar h1").removeClass("withDesc");
            }

            //update the Shifts list (if neccesary)
            var shouldUpdateShifts = sessionStorage.getItem("ShouldUpdateShifts");
            if (shouldUpdateShifts != null) {
                sessionStorage.removeItem("ShouldUpdateShifts");

                // according to the view - show period label
                var selectedView = localStorage.getItem("MonthlyShiftsView");
                if (selectedView != null) {
                    $("#monthlyShifts .MonthBar").attr("data-mode", selectedView);
                    if (selectedView == "list") {
                        ShowCurrentPeriodLabel();
                    }
                    else if (selectedView == "calendar") {
                        GetCurrentMonth();
                    }
                }
                DrawCurrentMonthCalendar();

                GetShiftsList();

                ShowBackToCurrentPeriodButton();
            }

            /* Show Welcome Wizard
            -------------------*/
            var sawWelcomeWizard = localStorage.getItem("sawWelcomeWizard");
            if (sawWelcomeWizard == null) {
                window.setTimeout(function () {
                    showDialog("<div class='title'>Tutorial<span class='close'>X</span></div><div class='content'></div><div class='bottom'><a href='#' class='prev'>< Prev</a><a href='#' class='next'>Next ></a></div>", "WelcomeWizard", true);
                    ChangeToWizardStep(1);
                }, 1000);
            }

            //start the timer (to show TimeElapsed since current shift)
            currentShiftTimer = window.setInterval(UpdateTimeElapsedSinceCurrentShift, 10000);
        }
        //when existing this page
        else if (info.direction == "out") {
            //stop the timer
            window.clearInterval(currentShiftTimer);
            currentShiftTimer = null;
        }
    });

    //when the user press (long tap) - החלף פרופיל
    $('#jqt').on('press', '#monthlyShifts', function () {
        //go to the UserProfilesSelect page
        jqtouch.goTo("UserProfilesSelect.html", "slideup");
    });

    var initialMonthYear = GetInitialMonthYear();
    sessionStorage.setItem("currentMonth", initialMonthYear.Month);
    sessionStorage.setItem("currentYear", initialMonthYear.Year);
    sessionStorage.setItem("originalMonth", initialMonthYear.Month);
    sessionStorage.setItem("originalYear", initialMonthYear.Year);

    var currentShiftTimer;

    //when user click - go to previous month
    $("#jqt").on("tap", "#monthlyShifts .MonthBar .left", function () {
        if ($(".fullScreenOverlay").length == 0) {

            // define based on the view (calendar/list)
            var selectedView = localStorage.getItem("MonthlyShiftsView");
            if (selectedView != null) {
                if (selectedView == "list") {
                    GoToPreviousPeriod();
                    ShowCurrentPeriodLabel();
                }
                else if (selectedView == "calendar") {
                    var currentMonth = parseInt(sessionStorage.getItem("currentMonth"));
                    var currentYear = parseInt(sessionStorage.getItem("currentYear"));

                    //decrease the month number by one
                    currentMonth--;
                    if (currentMonth < 1) {
                        currentYear--;
                        currentMonth = 12;
                    }
                    sessionStorage.setItem("currentMonth", currentMonth);
                    sessionStorage.setItem("currentYear", currentYear);
                    GetCurrentMonth();

                    DrawCurrentMonthCalendar();
                }
            }

            //show full loading when fetching the shifts
            sessionStorage.setItem("MonthlyShiftsFullLoading", true);

            GetShiftsList();

            ShowBackToCurrentPeriodButton();
        }
    });

    //when user click - go to next month
    $("#jqt").on("tap", "#monthlyShifts .MonthBar .right", function () {
        if ($(".fullScreenOverlay").length == 0) {

            // define based on the view (calendar/list)
            var selectedView = localStorage.getItem("MonthlyShiftsView");
            if (selectedView != null) {
                if (selectedView == "list") {
                    GoToNextPeriod();
                    ShowCurrentPeriodLabel();
                }
                else if (selectedView == "calendar") {
                    var currentMonth = parseInt(sessionStorage.getItem("currentMonth"));
                    var currentYear = parseInt(sessionStorage.getItem("currentYear"));

                    //increase the month number by one
                    currentMonth++;
                    if (currentMonth > 12) {
                        currentYear++;
                        currentMonth = 1;
                    }
                    sessionStorage.setItem("currentMonth", currentMonth);
                    sessionStorage.setItem("currentYear", currentYear);
                    GetCurrentMonth();

                    DrawCurrentMonthCalendar();
                }
            }

            //show full loading when fetching the shifts
            sessionStorage.setItem("MonthlyShiftsFullLoading", true);

            GetShiftsList();

            ShowBackToCurrentPeriodButton();
        }
    });

    //if the shown period is not the original period (תקופה נוכחית במציאות) - show "BackToCurrentMonth" button
    function ShowBackToCurrentPeriodButton() {
        var currentUserPeriodID = parseInt(sessionStorage.getItem("currentUserPeriodID"));
        var originalUserPeriodID = parseInt(sessionStorage.getItem("originalUserPeriodID"));

        if (originalUserPeriodID != currentUserPeriodID) {
            $("#monthlyShifts #btnBackToCurrentMonth").show();
        }
        else {
            $("#monthlyShifts #btnBackToCurrentMonth").hide();
        }
    }

    //when user click on a Shift Row - go to ShiftDetails page
    $("#jqt").on("tap", "#monthlyShifts ul#ShiftsList li:not(.noShifts),#monthlyShifts ul#CalendarDateShiftsList li:not(.empty)", function () {
        var listItem = $(this).parents("li[data-shift-id]");
        if (listItem.length == 0) {
            listItem = $(this);
        }

        //save the ShiftID
        var shiftId = listItem.data("shift-id");

        //יום בתשלום
        if (listItem.data("is-payment") == true) {
            sessionStorage.setItem("EditPaymentDayId", shiftId);
            sessionStorage.setItem("ShouldUpdateShiftDetails", true);

            //go to the PaymentDay page
            jqtouch.goTo("AddPaymentDay.html", "slideup");
        }
        //משמרת רגילה
        else {
            sessionStorage.setItem("EditShiftId", shiftId);
            sessionStorage.setItem("ShouldUpdateShiftDetails", true);

            //go to the ShiftDetails page
            jqtouch.goTo("ShiftDetails.html", "slideup");
        }
    });

    //when user click Add Shift Menu - open the BottomMenu
    $("#jqt").on("tap", "#monthlyShifts #btnShiftsMenu", function () {
        showPopupMenu();
    });

    //when user click SendShiftsMail - show Confirm dialog
    $("#jqt").on("tap", "#monthlyShifts #btnSendShiftsMail", function () {
        showDialog("<div class='title'>Export to Email<span class='close'>X</span></div><div class='content'>Do you want to send the shift list to your email?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "SendShiftsMailDialog");
    });
    $("#jqt").on("tap", "#monthlyShifts #SendShiftsMailDialog .confirm", function () {
        showLoading();

        //send mail
        $.post(pathPrefix + "Shifts/SendShiftsOfUser", { "UserPayPeriodID": sessionStorage.getItem("currentUserPeriodID") }, function (result) {
            removeLoading();
            showPopup(result.Value, result.Key);
        }, "json");
    });

    //when user click BackToCurrentMonth - change the month to the current
    $("#jqt").on("tap", "#monthlyShifts #btnBackToCurrentMonth", function () {
        $(this).hide();

        //change to original period
        var originalUserPeriodID = parseInt(sessionStorage.getItem("originalUserPeriodID"));
        sessionStorage.setItem("currentUserPeriodID", originalUserPeriodID);

        //show full loading when fetching the shifts
        sessionStorage.setItem("MonthlyShiftsFullLoading", true);

        ShowCurrentPeriodLabel();
        DrawCurrentMonthCalendar();

        GetShiftsList();
    });

    //when user click ReloadShiftList - delete the shifts list from the localStorage and fetch it again from the server
    $("#jqt").on("tap", "#monthlyShifts #btnReloadShiftList", function () {
        var periodData = GetCurrentPeriodData();

        MonthlyShiftsHelper.removeMonthlyData(periodData);

        //show full loading when fetching the shifts
        sessionStorage.setItem("MonthlyShiftsFullLoading", true);

        DrawCurrentMonthCalendar();

        GetShiftsList();
    });

    //when the user click on the "Change View" button (שינוי תצוגה - רשימה או לוח שנה)
    $("#jqt").on("tap", "#monthlyShifts #changeViewButton", function () {
        var selectedView;

        if ($("#monthlyShifts #MonthCalendarView:visible").length == 0) {
            selectedView = "calendar";
            GetCurrentMonth();
            DrawCurrentMonthCalendar();
        }
        else {
            selectedView = "list"
            ShowCurrentPeriodLabel();
        }

        localStorage.setItem("MonthlyShiftsView", selectedView);
        ChangeView(selectedView);

        $("#monthlyShifts .MonthBar").attr("data-mode", selectedView);

        //show full loading when fetching the shifts
        sessionStorage.setItem("MonthlyShiftsFullLoading", true);
        GetShiftsList();
    });

    //change the view - Calendar or List (לוח שנה או רשימה)
    function ChangeView(view) {
        var image = $("#monthlyShifts #changeViewButton img");

        if (view == "list") {
            $("#monthlyShifts #MonthCalendarView").hide();
            $("#monthlyShifts .ShiftsListView").show();

            image.attr("src", image.data("calendar-image"));
        }
        else if (view == "calendar") {
            $("#monthlyShifts .ShiftsListView").hide();
            $("#monthlyShifts #MonthCalendarView").show();

            image.attr("src", image.data("list-image"));
        }
    }

    //when the user click on a day in the calendar view
    $("#jqt").on("tap", "#monthlyShifts #MonthCalendarView table tr td:not(.other-month)", function () {
        //save the selected day
        sessionStorage.setItem("CalendarViewSelectedDate", $(this).data("date"));

        $("#monthlyShifts #MonthCalendarView td.selected").removeClass("selected");
        $(this).addClass("selected");

        $("#monthlyShifts ul#CalendarDateShiftsList").empty();
        var shifts = $(this).children("span.day").data("date-shifts");
        if (shifts != null) {
            var currency = GetCurrencyName();

            var shiftRowCalendarTemplate = Handlebars.templates["shiftRowCalendarTemplate"];
            var paymentDayRowCalendarTemplate = Handlebars.templates["paymentDayRowCalendarTemplate"];

            var shiftsHtml = "";

            //bind the shifts list of this day to the calendar date list
            for (var i = 0; i < shifts.length; i++) {
                // get the shift's data
                var shiftData = shifts[i];
                shiftData.Currency = currency;
                if (shiftData.EndTime == "-") {
                    shiftData.EndTime = "?";
                }
                if (shiftData.HasComments != "") {
                    shiftData.ShortComments = "(" + ShortenString(shiftData.Comments, 27) + ")";
                }

                //append template according to the shift type (Shift or PaymentDay)
                if (shiftData.IsPaymentDay == false) {
                    shiftsHtml += $.trim(shiftRowCalendarTemplate(shiftData));
                }
                else {
                    shiftsHtml += $.trim(paymentDayRowCalendarTemplate(shiftData));
                }
            }
            $("#monthlyShifts ul#CalendarDateShiftsList").append(shiftsHtml);
        }
        else {
            $("#monthlyShifts ul#CalendarDateShiftsList").append("<li class='empty'>No Shifts</li>");
        }
    });

    //when user click Set Shift (התחל משמרת/סיים משמרת)
    $("#jqt").on("tap", "#monthlyShifts #btnSetShift", function () {
        var currentTime = GetCurrentDate() + " " + GetCurrentTime();

        showLoading();

        //insert a new shift (or update the current one) with a startDate/endDate
        $.post(pathPrefix + "Shifts/SetShift", { "currentTime": currentTime }, function (result) {
            removeLoading();

            //go back to original period and refresh the shifts list
            sessionStorage.setItem("currentUserPeriodID", sessionStorage.getItem("originalUserPeriodID"));
            //go back to original month and refresh the shifts list
            sessionStorage.setItem("currentMonth", sessionStorage.getItem("originalMonth"));
            sessionStorage.setItem("currentYear", sessionStorage.getItem("originalYear"));

            // according to the view - show period label
            var selectedView = localStorage.getItem("MonthlyShiftsView");
            if (selectedView != null) {
                if (selectedView == "list") {
                    ShowCurrentPeriodLabel();
                }
                else if (selectedView == "calendar") {
                    GetCurrentMonth();
                }
            }

            DrawCurrentMonthCalendar();

            GetShiftsList();

            //if this is shift end (סיום משמרת)
            if (result.EndShiftId != null) {
                $("#monthlyShifts #btnSetShift span").html("Check In");

                //if the user want to show shift details after insertion
                if (localStorage.getItem("ShowShiftDetailsAfterInsertion") == "true") {
                    sessionStorage.setItem("EditShiftId", result.AddedShift.ShiftID);
                    sessionStorage.setItem("ShouldUpdateShiftDetails", true);
                    sessionStorage.setItem("ShowSmallPopup", JSON.stringify(result));

                    window.setTimeout(function () {
                        //go to the ShiftDetails page
                        jqtouch.goTo("ShiftDetails.html", "slideup");
                    }, 1000);
                }

                AddShiftToIphoneCalendar(result.AddedShift);
            }
            //if this is shift start time (התחלת משמרת)
            else {
                $("#monthlyShifts #btnSetShift span").html("Check Out");
            }
        }, "json");
    });

    //draw the calendar for this current month
    function DrawCurrentMonthCalendar() {
        var currentMonth = parseInt(sessionStorage.getItem("currentMonth"));
        var currentYear = parseInt(sessionStorage.getItem("currentYear"));
        var data = {
            month: currentMonth - 1,
            year: currentYear
        };
        $("#monthlyShifts #MonthCalendarView #CalendarContainer").calendarWidget(data);

        //change the calendar table to LTR or RTL
        if (localStorage.getItem("CalendarLTR") == "true") {
            $("#monthlyShifts #MonthCalendarView #CalendarContainer table").addClass("ltr");
        }
    }

    function GetCurrentPeriodData() {
        var periodData = {};
        // according to the view - generate period data (UserPayPeriod or Month-Year)
        var selectedView = localStorage.getItem("MonthlyShiftsView");
        if (selectedView != null) {
            if (selectedView == "list") {
                periodData = {
                    userPeriodID: sessionStorage.getItem("currentUserPeriodID")
                };
            }
            else if (selectedView == "calendar") {
                periodData = {
                    month: sessionStorage.getItem("currentMonth"),
                    year: sessionStorage.getItem("currentYear")
                };
            }
        }
        return periodData;
    }

    function GetShiftsList() {
        var currency = GetCurrencyName();
        var shiftsIDs = new Array();

        var periodData = GetCurrentPeriodData();

        //show full loading (if neccesary) - otherwise show the small loading
        var monthlyShiftsFullLoading = sessionStorage.getItem("MonthlyShiftsFullLoading");
        var isPeriodInLocalStorage = MonthlyShiftsHelper.isPeriodInLocalStorage(periodData);
        if (monthlyShiftsFullLoading == "true" || isPeriodInLocalStorage == false) {
            sessionStorage.removeItem("MonthlyShiftsFullLoading");

            $('#monthlyShifts ul#ShiftsList').empty(); // clear the list

            showLoading(); // show the full loading
        }
        else {
            showSmallLoading(); // show the small loading

            window.setTimeout(function () { scrollListToBottom(6); }, 1);
        }

        //get the shifts of this user
        MonthlyShiftsHelper.getShiftsList(periodData, function (data) {
            $('#monthlyShifts ul#ShiftsList').empty();

            // create an array with all the shifts that should be displayed in the ListView
            var listViewShifts = [];
            for (var i = 0; i < data.Shifts.length; i++) {
                if (data.Shifts[i].ShowInListView == true) {
                    if (data.Shifts[i].IsDeleted == false) {
                        listViewShifts.push(data.Shifts[i]);
                    }
                }
            }

            // create an array with all the shifts that should be displayed in the CalendarView
            var calendarViewShifts = [];
            for (var i = 0; i < data.Shifts.length; i++) {
                if (data.Shifts[i].ShowInCalendarView == true) {
                    if (data.Shifts[i].IsDeleted == false) {
                        calendarViewShifts.push(data.Shifts[i]);
                    }
                }
            }

            /* LIST VIEW - Shifts Binding
            -----------------------------------*/
            if (listViewShifts.length > 0) {
                var shiftRowTemplate = Handlebars.templates["shiftRowTemplate"];

                var shiftsHtml = "";

                //loop through the shifts and create a row for each one
                for (var i = 0; i < listViewShifts.length; i++) {
                    var shiftData = listViewShifts[i];

                    //add to IDs array
                    if (shiftData.IsPaymentDay == false) {
                        shiftsIDs.push(shiftData.ShiftID);

                        InitShiftExtraColumns(shiftData);
                    }

                    // if today
                    if (shiftData.StartDate == GetCurrentDate()) {
                        shiftData.IsToday = true;
                    }

                    //bind item to the list
                    shiftsHtml += $.trim(shiftRowTemplate(shiftData));
                }
                $("#monthlyShifts ul#ShiftsList").append(shiftsHtml);

                //save the list of shifts IDs in the session storage (will be used in the shifts Next-Prev navigation)
                sessionStorage.setItem("ShiftsIDsList", JSON.stringify(shiftsIDs));

                $("#monthlyShifts #btnSendShiftsMail").show();

                //show or hide the MonthlyBonus button (עדכון תוספות שכר חודשיות)
                if (localStorage.getItem("IsUserHaveMonthlyBonuses") == "true") {
                    $("#monthlyShifts #btnUpdateMonthlyBonuses").show();
                }
                else {
                    $("#monthlyShifts #btnUpdateMonthlyBonuses").hide();
                }

                //show the relevant info in the left column
                var visibleColumn = $("#monthlyShifts ul#ShiftsHeader .DynamicColumn .DynamicColumnButton").data("visible-column");
                ShowShiftColumn(visibleColumn);
            }
            //there are no shifts
            else {
                $("#monthlyShifts ul#ShiftsList").append("<li class='noShifts'>No Shifts In Period</li>");

                $("#monthlyShifts #btnSendShiftsMail").hide();
                $("#monthlyShifts #btnUpdateMonthlyBonuses").hide();
                $("#monthlyShifts #btnUpdateMonthlyVAT").hide();
            }

            /* Scroll list to bottom
            --------------------------*/

            scrollListToBottom(listViewShifts.length);

            /* Footer data
            -----------------*/

            //set the sum info labels (סה"כ, בתחתית הטבלה)
            $("#monthlyShifts #DynamicColumnFooter .value [data-visible-column=0]").html(data.WorkingTimeSum);
            $("#monthlyShifts #DynamicColumnFooter .value [data-visible-column=1]").html(currency + data.MonthSalary);

            //check if this month salary is already recorded in DB (and the user can't edit shifts anymore)
            sessionStorage.setItem("IsMonthSalaryInDB", data.IsMonthSalaryInDB);

            /* Define text for "Set Shift" button
            ---------------------------------*/
            var userInShift = false;
            var ongoingShiftId;

            //if there are shifts
            if (listViewShifts.length > 0) {
                //check if this period is the current period
                if (sessionStorage.getItem("currentUserPeriodID") == sessionStorage.getItem("originalUserPeriodID")) {

                    //check if the user is currently in shift
                    for (var i = 0; i < listViewShifts.length; i++) {
                        if (listViewShifts[i].EndDate == "-") {
                            userInShift = true;
                            ongoingShift = listViewShifts[i];
                        }
                    }

                    //if the user is currently in shift
                    if (userInShift) {
                        $("#monthlyShifts #btnSetShift span").html("Check Out");
                        userInShift = true;
                    }
                    else {
                        $("#monthlyShifts #btnSetShift span").html("Check In");
                    }
                }
            }

            //if the user is currently in shift
            if (userInShift) {
                //save the ShiftTime of this current active shift (last shift)
                var ongoingShiftTime = ongoingShift.StartDate + " " + ongoingShift.StartTime;
                $("#monthlyShifts ul#ShiftsList li[data-shift-id='" + ongoingShift.ShiftID + "'] .TimeElapsed").attr("data-shift-time", ongoingShiftTime);

                UpdateTimeElapsedSinceCurrentShift();
            }

            /* CALENDAR VIEW - Shifts Binding
            -----------------------------------*/
            for (var i = 0; i < calendarViewShifts.length; i++) {
                var shiftData = calendarViewShifts[i];

                //add shift indicator for this date's cell
                var dayCell = $("#monthlyShifts #MonthCalendarView table tr td[data-date='" + shiftData.StartDate + "'] span");
                if (dayCell.children("ol.shiftsIndicators").length == 0) {
                    dayCell.append("<ol class='shiftsIndicators'></ol>");
                }
                dayCell.children("ol.shiftsIndicators").append("<li style='background-color:" + shiftData.Color + ";'></li>");

                //add the shift to the data collection of this date
                var shifts = dayCell.data("date-shifts");
                if (shifts == null) {
                    shifts = new Array();
                }
                shifts.push(shiftData);
                dayCell.data("date-shifts", shifts);
            }
            $("#monthlyShifts ul#CalendarDateShiftsList").empty();

            //if there was previously a selected date in the calendar - select it again
            var selectedDate = sessionStorage.getItem("CalendarViewSelectedDate");
            if (selectedDate != null) {
                $("#monthlyShifts #MonthCalendarView table tr td[data-date='" + selectedDate + "']").trigger("tap");
            }

            /* Change to selected view (list or calendar)
            ---------------------------------------------*/
            var selectedView = localStorage.getItem("MonthlyShiftsView");
            if (selectedView != null) {
                $("#monthlyShifts .MonthBar").attr("data-mode", selectedView);
                window.setTimeout(function () {
                    ChangeView(selectedView);
                }, 0);
            }

            removeSmallLoading();
            removeLoading();


            /* Show urgent message (הודעה חשובה)
            ----------------------------------------*/
            var sawWelcomeWizard = localStorage.getItem("sawWelcomeWizard");
            if (sawWelcomeWizard == "true") { // if there is no wizard
                if (data.UrgentMessage != null) { // if there is urgent message to show
                    var message = data.UrgentMessage;

                    var urgentMessagesAlreadyRead = [];
                    var urgentMessagesAlreadyReadJSON = localStorage.getItem("UrgentMessagesAlreadyRead");
                    if (urgentMessagesAlreadyReadJSON != null) {
                        urgentMessagesAlreadyRead = JSON.parse(urgentMessagesAlreadyReadJSON);
                    }

                    //if the user didn't read this urgent message yet
                    if (urgentMessagesAlreadyRead.indexOf(message.MessageID) < 0) {
                        showDialog("<div class='title'>" + message.MessageTitle + "<span class='close'>X</span></div><div class='content'>" + message.MessageText + "</div><div class='bottom'><a href='#' class='close full'>OK</a></div>", "UrgentMessage");

                        //add this message to the UrgentMessagesAlreadyRead list
                        urgentMessagesAlreadyRead.push(message.MessageID);
                    }

                    //save the AlreadyRead messages list
                    localStorage.setItem("UrgentMessagesAlreadyRead", JSON.stringify(urgentMessagesAlreadyRead));
                }
            }
        },
        // error callback
        function () {
            console.log("Get Shift List - error");

            // wait a bit and recall the function
            window.setTimeout(function () {
                //show full loading when fetching the shifts
                //sessionStorage.setItem("MonthlyShiftsFullLoading", true);

                GetShiftsList();
            }, 2000);
        });
    }

    // custom event - when the Phonegap app has been resumed from background
    $('#jqt').on("resumeOfApp", "#monthlyShifts", function () {
        // if the shift list has not been loaded
        if ($('#monthlyShifts ul#ShiftsList li').length == 0) {
            if ($("#jqt .loadingImage:visible").length == 0) {
                GetShiftsList();
            }
        }
    });

    function UpdateTimeElapsedSinceCurrentShift() {
        //show the TimeElapsed since the StartTime of this current shift
        var timeElapsedElement = $("#monthlyShifts ul#ShiftsList li .TimeElapsed[data-shift-time]");
        var lastShiftTime = timeElapsedElement.data("shift-time");

        //if the last shift is actually running (user is shift currently)
        if (lastShiftTime != null) {
            var timeElapsed = TimeElapsed(lastShiftTime);
            timeElapsedElement.html("Elapsed: " + timeElapsed.Hours + ":" + timeElapsed.Minutes);
            timeElapsedElement.show();
        }
    }

    //change the left column with the relevant info
    $("#jqt").on("tap", "#monthlyShifts ul#ShiftsHeader .DynamicColumn .DynamicColumnButton", function () {
        //define the different columns
        var columnTitles = new Array();
        columnTitles.push("Hours");
        columnTitles.push("Wage");
        columnTitles.push("Rates");
        columnTitles.push("Bonuses");
        columnTitles.push("Notes");

        //move to the next column
        var visibleColumn = parseInt($(this).data("visible-column"));
        visibleColumn++;
        if (visibleColumn > columnTitles.length - 1) {
            visibleColumn = 0;
        }

        //change the header text (and save the selected column id in the data)
        $(this).data("visible-column", visibleColumn);
        $(this).html(columnTitles[visibleColumn]);

        var footerLabel = "";
        if (visibleColumn == 0 || visibleColumn == 1) { // 1=שעות,0=שכר
            footerLabel = "Total " + columnTitles[visibleColumn];
        }
        $("#monthlyShifts #DynamicColumnFooter .label").html(footerLabel);

        ShowShiftColumn(visibleColumn);
    });

    function ShowShiftColumn(visibleColumn) {
        //change the left column for all rows in list
        $("#monthlyShifts ul#ShiftsList li > div.DynamicColumn > div").hide();
        $("#monthlyShifts ul#ShiftsList li > div.DynamicColumn > div[data-visible-column=" + visibleColumn + "]").show();

        //change the footer column
        $("#monthlyShifts #DynamicColumnFooter .value > div").hide();

        if (visibleColumn == 0 || visibleColumn == 1) { // 1=שעות,0=שכר
            $("#monthlyShifts #DynamicColumnFooter .value > div[data-visible-column=" + visibleColumn + "]").show();
        }
    }

    function InitShiftExtraColumns(shiftData) {
        //generate small table for Rates of this shift
        var ratesList = "";
        if (shiftData.RateRanges.length > 0) {
            for (var i = 0; i < shiftData.RateRanges.length; i++) {
                ratesList += "<div>@ " + shiftData.RateRanges[i].RateValue + "</div><div>" + shiftData.RateRanges[i].TotalHoursTime + "</div>";
            }
        }
        shiftData.RatesList = ratesList;

        //generate small table for Bonuses of this shift
        var bonusesList = "";
        if (shiftData.Bonuses.length > 0) {
            for (var i = 0; i < shiftData.Bonuses.length; i++) {
                bonusesList += "<div>" + shiftData.Bonuses[i].BonusName + "</div><div>" + shiftData.Bonuses[i].Bonus + "</div>";
            }
        }
        shiftData.BonusesList = bonusesList;
    }

    function scrollListToBottom(listViewShiftsLength) {
        // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
        if (!Modernizr.overflowscrolling) {
            window.setTimeout(function () {
                //set scroller
                var scroller = $('#monthlyShifts').data("scroller");
                scroller.refresh();
                if (listViewShiftsLength > 5) {
                    //scroll to bottom
                    scroller.scrollToElement("li:last-child", 0);
                }
            }, 0);
        }
        else {
            //scroll to bottom
            var list = $("#monthlyShifts ul#ShiftsList")[0];
            list.scrollTop = list.scrollHeight;
        }
    }

    /* Small loading image
    -------------------------*/

    function showSmallLoading() {
        $("#monthlyShifts #SmallLoadingContainer").show();
        $("#monthlyShifts .toolbar #btnReloadShiftList").hide();
    }

    function removeSmallLoading() {
        $("#monthlyShifts #SmallLoadingContainer").hide();
        $("#monthlyShifts .toolbar #btnReloadShiftList").show();
    }

    /* Welcome Wizard Steps
    -----------------------*/

    function ChangeToWizardStep(step) {
        //remove all highlighted elements
        removeHighlightedElements();

        //set the relevant content
        if (step == 1) {
            $("#jqt .dialog .content").html('Welcome to "My Wage" application. This tutorial will guide you with the basic options of the app.<br /><br />This is the "Shift List" page - the main page of the application.<br />Here you can manage your shifts and working hours - Add, Edit, Remove and Export.');

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 2) {
            $("#jqt .dialog .content").html('Once you start your shift, click on the highlighted button - "Check In". This will create a new shift with the current time.<br />Once finished your working day, you can click again on this button to close the shift.');
            $("#monthlyShifts #btnSetShift").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 3) {
            $("#jqt .dialog .content").html('Obviously you can manually add your shifts and working hours. To do that, click on "Actions" and select "New Shift".<br /><br />By clicking on the shift item in the list, you can also edit its data and delete it.');
            $("#monthlyShifts #btnShiftsMenu").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 4) {
            $("#jqt .dialog .content").html('Notice the highlighted arrows - You can use them to move between your pay periods.');
            $("#monthlyShifts .MonthBar .right,#monthlyShifts .MonthBar .left").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 5) {
            $("#jqt .dialog .content").html('This page display the list of all shifts in the current period. Every shift item includes its Start Time, End Time and Total Hours.<br />You can click on the highlighted header column to switch the column data and display the wage, bonuses, rates, notes...');
            $("#monthlyShifts ul#ShiftsHeader .DynamicColumn").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 6) {
            $("#jqt .dialog .content").html('To get full details about a specific shift - just click on the shift item in the list.<br />In addition to this, you can also edit the shift times, money, rates, bonues from this page.');

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 7) {
            $("#jqt .dialog .content").html('If you prefer to view your shifts in a Calendar view - you can do it.<br />By clicking on the highlighted button - your shifts will be structured in a calendar view.');
            $("#monthlyShifts #changeViewButton").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 8) {
            $("#jqt .dialog .content").html('Clicking on the highlighted "Payroll" button, will show you your current Payroll.<br />In the Payroll page, you will be able to see your gross pay, net pay, deductions, taxes and bonuses.<br />If you wish - you can send the data to your email.');
            $("#monthlyShifts a.button:eq(0)").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 9) {
            $("#jqt .dialog .content").html('This "Menu" button will show you all the different options of the application.<br /><br />These includes:<br />* Edit your personal details.<br />* Update your wage and rates settings.<br />* Define preset shifts.<br />* Quick wage calculator.');
            $("#monthlyShifts a.button:eq(1)").addClass("highlightElement");

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 10) {
            $("#jqt .dialog .content").html('That\'s it. We showed you the most frequently used options of the app.<br />Good luck!<br /><br />To view this tutorial again - click on "Menu" and select "App Tutorial".');

            localStorage.setItem("welcomeWizardStep", step);
        }
        else if (step == 11) {
            CloseWizard();
        }

        //show or hide the Previous button
        if (step == 1) {
            $("#jqt .dialog .bottom a.prev").css("visibility", "hidden");
            verticalCenterDialog();
        }
        else {
            $("#jqt .dialog .bottom a.prev").css("visibility", "visible");
        }

        if (step == 10) {
            $("#jqt .dialog .bottom a.next").html("Done");
        }
        else {
            $("#jqt .dialog .bottom a.next").html("Next >");
        }
    }

    function CloseWizard() {
        $("#jqt .fullScreenOverlay").remove();
        $("#jqt .dialog").remove();

        //remove all highlighted elements
        removeHighlightedElements();

        localStorage.setItem("sawWelcomeWizard", true);
        localStorage.removeItem("welcomeWizardStep");
    }

    function removeHighlightedElements() {
        var currentHighlightedElement = $("#jqt .highlightElement");
        currentHighlightedElement.removeClass("highlightElement");

        // fix a bug in Android (the "removeClass" alone doesn't stop the animation completely)
        currentHighlightedElement.hide();
        window.setTimeout(function () {
            currentHighlightedElement.show();
        }, 0);
    }

    /* Welcome Wizard Buttons
    -------------------------*/

    $('#jqt').on('tap', '#WelcomeWizard .title .close', function () {
        CloseWizard();
    });

    $('#jqt').on('tap', '#WelcomeWizard .bottom a.prev', function () {
        var currentStep = localStorage.getItem("welcomeWizardStep");
        ChangeToWizardStep(parseInt(currentStep) - 1);
    });

    $('#jqt').on('tap', '#WelcomeWizard .bottom a.next', function () {
        var currentStep = localStorage.getItem("welcomeWizardStep");
        ChangeToWizardStep(parseInt(currentStep) + 1);
    });
});