﻿var MonthlyShiftsHelper = {

    // get the MonthlyData from the localStorage
    getLocalStorageData: function () {
        if (localStorage.getItem("MonthlyData") == null) {
            localStorage.setItem("MonthlyData", JSON.stringify({}));
        }
        var monthlyData = JSON.parse(localStorage.getItem("MonthlyData"));
        return monthlyData;
    },

    // clear all the MonthlyData that was saved in the localStorage
    clearLocalStorageData: function () {
        localStorage.removeItem("MonthlyData");
    },

    getShiftsList: function (periodData, callback, errorCallback) {
        var that = this;

        var monthlyData = this.getLocalStorageData();
        var userId = localStorage.getItem("UserUniqueGuid");
        if (userId == null) { userId = ""; }

        // get the month data (can be by UserPayPeriod and can be for Month-Year)
        var localStorageSearchStr = "";
        if (periodData.userPeriodID != null) {
            localStorageSearchStr = periodData.userPeriodID + "_" + userId;
        }
        else if (periodData.month != null && periodData.year != null) {
            localStorageSearchStr = periodData.month + "_" + periodData.year + "_" + userId;
        }
        var currentMonthData = monthlyData[localStorageSearchStr];

        // the specified period have data in the localStorage - need to get only the latest updated shifts of this month
        if (currentMonthData != null) {

            // define the url (can be by UserPayPeriod and can be for Month-Year)
            var url = "";
            if (periodData.userPeriodID != null) {
                url = pathPrefix + "Shifts/GetShiftsList?UserPayPeriodID=" + periodData.userPeriodID + "&LastUpdate=" + currentMonthData.LastUpdate;
            }
            else if (periodData.month != null && periodData.year != null) {
                url = pathPrefix + "Shifts/GetShiftsList?Month=" + periodData.month + "&Year=" + periodData.year + "&LastUpdate=" + currentMonthData.LastUpdate;
            }

            $.getJSON(url, function (data) {
                //save the new "LastUpdate" time of this month
                currentMonthData.LastUpdate = data.LastUpdate;
                currentMonthData.IsMonthSalaryInDB = data.IsMonthSalaryInDB;
                currentMonthData.UrgentMessage = data.UrgentMessage;

                for (var i = 0; i < data.Shifts.length; i++) {
                    var shiftId = data.Shifts[i].ShiftID;

                    //search the shift in the current data (data from localStorage)
                    var shiftIndex = that.findShiftIndexById(currentMonthData, shiftId);

                    //this shift exists - so this is UPDATE
                    if (shiftIndex != null) {
                        currentMonthData.Shifts[shiftIndex] = data.Shifts[i];
                    }
                    //this shift doesn't exists - so this is NEW SHIFT
                    else {
                        currentMonthData.Shifts.push(data.Shifts[i]);
                    }
                }

                that.orderByDate(currentMonthData);

                that.calculateTotalSalary(currentMonthData);
                that.calculateTotalTime(currentMonthData);

                that.saveMonthlyData(periodData, currentMonthData); // save the data in localStorage

                callback(currentMonthData);
            }).fail(function () {
                errorCallback();
            });
        }
        // the specified period don't have data in the localStorage - need to get all the shifts of this month
        else {
            // define the url (can be by UserPayPeriod and can be for Month-Year)
            var url = "";
            if (periodData.userPeriodID != null) {
                url = pathPrefix + "Shifts/GetShiftsList?UserPayPeriodID=" + periodData.userPeriodID;
            }
            else if (periodData.month != null && periodData.year != null) {
                url = pathPrefix + "Shifts/GetShiftsList?Month=" + periodData.month + "&Year=" + periodData.year;
            }

            $.getJSON(url, function (data) {
                that.calculateTotalSalary(data);
                that.calculateTotalTime(data);

                that.saveMonthlyData(periodData, data); // save the data in localStorage

                callback(data);
            }).fail(function () {
                errorCallback();
            });
        }
    },

    // save the data in localStorage
    saveMonthlyData: function (periodData, data) {
        var monthlyData = this.getLocalStorageData();
        var userId = localStorage.getItem("UserUniqueGuid");
        if (userId == null) { userId = ""; }

        // save the month data (can be by UserPayPeriod and can be for Month-Year)
        var localStorageSearchStr = "";
        if (periodData.userPeriodID != null) {
            localStorageSearchStr = periodData.userPeriodID + "_" + userId;
        }
        else if (periodData.month != null && periodData.year != null) {
            localStorageSearchStr = periodData.month + "_" + periodData.year + "_" + userId;
        }
        monthlyData[localStorageSearchStr] = data;

        //save the updated "MonthlyData" array
        localStorage.setItem("MonthlyData", JSON.stringify(monthlyData));
    },

    // remove the monthly data from localStorage
    removeMonthlyData: function (periodData) {
        var monthlyData = this.getLocalStorageData();
        var userId = localStorage.getItem("UserUniqueGuid");
        if (userId == null) { userId = ""; }

        var localStorageSearchStr = "";
        if (periodData.userPeriodID != null) {
            localStorageSearchStr = periodData.userPeriodID + "_" + userId;
        }
        else if (periodData.month != null && periodData.year != null) {
            localStorageSearchStr = periodData.month + "_" + periodData.year + "_" + userId;
        }
        delete monthlyData[localStorageSearchStr];

        //save the updated "MonthlyData" array
        localStorage.setItem("MonthlyData", JSON.stringify(monthlyData));
    },

    isPeriodInLocalStorage: function (periodData) {
        var monthlyData = this.getLocalStorageData();
        var userId = localStorage.getItem("UserUniqueGuid");
        if (userId == null) { userId = ""; }

        // get the month data (can be by UserPayPeriod and can be for Month-Year)
        var localStorageSearchStr = "";
        if (periodData.userPeriodID != null) {
            localStorageSearchStr = periodData.userPeriodID + "_" + userId;
        }
        else if (periodData.month != null && periodData.year != null) {
            localStorageSearchStr = periodData.month + "_" + periodData.year + "_" + userId;
        }
        var currentMonthData = monthlyData[localStorageSearchStr];

        if (currentMonthData != null) {
            return true;
        }
        return false;
    },

    //search a shift with the specified ShiftID in the list
    findShiftIndexById: function (data, shiftId) {
        for (var i = 0; i < data.Shifts.length; i++) {
            if (data.Shifts[i].ShiftID == shiftId) {
                return i;
            }
        }
        return null;
    },

    orderByDate: function (data) {
        var that = this;

        // sort the shifts list by date
        data.Shifts.sort(function (a, b) {
            var firstStartTime = a.StartTime;
            if (firstStartTime == null) {
                firstStartTime = "00:00"; // paymentDay doesn't have StartTime
            }
            var secondStartTime = b.StartTime;
            if (secondStartTime == null) {
                secondStartTime = "00:00"; // paymentDay doesn't have StartTime
            }
            a = new Date(that.stringToDate(a.StartDate) + " " + firstStartTime);
            b = new Date(that.stringToDate(b.StartDate) + " " + secondStartTime);
            return a < b ? -1 : a > b ? 1 : 0;
        });
    },

    // calculate the total salary of this month
    calculateTotalSalary: function (data) {
        var totalSalary = 0;
        for (var i = 0; i < data.Shifts.length; i++) {
            if (data.Shifts[i].IsDeleted == false && data.Shifts[i].ShowInListView == true) {
                if (data.Shifts[i].Money != null) {
                    if (data.Shifts[i].Money != "") {
                        if (data.Shifts[i].Money != "-") {
                            var shiftMoney = data.Shifts[i].Money;
                            shiftMoney = shiftMoney.replace(/,/g, "");
                            totalSalary += parseFloat(shiftMoney);
                        }
                    }
                }
            }
        }

        data.MonthSalary = totalSalary.formatMoney(2, '.', ',');
    },

    // calculate the total working time of this month
    calculateTotalTime: function (data) {
        var totalMinutes = 0;
        for (var i = 0; i < data.Shifts.length; i++) {
            if (data.Shifts[i].IsDeleted == false && data.Shifts[i].ShowInListView == true) {
                if (data.Shifts[i].WorkingTime != null) {
                    if (data.Shifts[i].WorkingTime != "") {
                        if (data.Shifts[i].WorkingTime != "-") {
                            var shiftWorkingTime = data.Shifts[i].WorkingTime;
                            var shiftWorkingTimeParts = shiftWorkingTime.split(":");
                            var shiftHours = parseInt(shiftWorkingTimeParts[0], 10);
                            var shiftMinutes = parseInt(shiftWorkingTimeParts[1], 10);

                            totalMinutes += shiftMinutes + (shiftHours * 60);
                        }
                    }
                }
            }
        }

        if (totalMinutes > 0) {
            // sum the total hours,minutes in this format - HH:MM
            var hours = Math.floor((totalMinutes / 60));
            var minutes = (totalMinutes % 60);
            if (minutes < 10) {
                minutes = "0" + minutes;
            }
            data.WorkingTimeSum = hours + ":" + minutes;
        }
        else {
            data.WorkingTimeSum = "0:00";
        }
    },

    stringToDate: function (dateStr) {
        //var dateFormat = dateStr.substr(3, 2) + "/" + dateStr.substr(0, 2) + "/" + dateStr.substr(6, 4);
        return dateStr;
    }
};