﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#mySalary', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    //Define Scroller
                    var wrapperId = "mySalaryScroll";
                    $(this).children(".scroll").wrap('<div id="scroller">'); //Adds the wrapper div
                    $(this).children('#scroller').wrap('<div id="' + wrapperId + '" style="position: absolute;z-index: 1;top:75px;bottom: 0px;left: 0px;right: 0px;">'); // Adds the scroller div *inside* the wrapper div

                    setTimeout(function () {
                        $("#mySalary").data("scroller", new iScroll(wrapperId));
                    }, 0);
                }

                $(this).data("loaded", true);
            }
        }
    });

    //when this page loads first time (Animation END)
    $('#jqt').on('pageAnimationEnd', '#mySalary', function (event, info) {
        if (info.direction == 'in') {

            //check if there is a need to reload the salary
            var dontReloadMySalary = sessionStorage.getItem("DontReloadMySalary");
            if (dontReloadMySalary == null) {

                //update the Monthly Salary details
                ShowCurrentPeriodLabel();
                GetMonthlySalary();
            }
            else {
                sessionStorage.removeItem("DontReloadMySalary");
            }
        }
    });

    //when user click on an Explanation Icon
    $("#jqt").on("tap", "#mySalary a.explanationIcon,#mySalary #btnCreditPoints", function () {
        sessionStorage.setItem("DontReloadMySalary", true);
    });

    //when user click - go to previous month
    $("#jqt").on("tap", "#mySalary .MonthBar .left", function () {
        if ($(".fullScreenOverlay").length == 0) {
            GoToPreviousPeriod();

            ShowCurrentPeriodLabel();
            GetMonthlySalary();

            //when the month is being changed - update the shifts list after it
            sessionStorage.setItem("ShouldUpdateShifts", true);
            sessionStorage.setItem("MonthlyShiftsFullLoading", true);
        }
    });

    //when user click - go to next month
    $("#jqt").on("tap", "#mySalary .MonthBar .right", function () {
        if ($(".fullScreenOverlay").length == 0) {
            GoToNextPeriod();

            ShowCurrentPeriodLabel();
            GetMonthlySalary();

            //when the month is being changed - update the shifts list after it
            sessionStorage.setItem("ShouldUpdateShifts", true);
            sessionStorage.setItem("MonthlyShiftsFullLoading", true);
        }
    });

    //when user click SendMonthlySalaryMail - show Confirm dialog
    $("#jqt").on("tap", "#mySalary #SendMonthlySalaryMail", function () {
        showDialog("<div class='title'>Export to Email<span class='close'>X</span></div><div class='content'>Do you want to send the data to your email?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "SendMonthlySalaryMailDialog");
    });
    $("#jqt").on("tap", "#mySalary #SendMonthlySalaryMailDialog .confirm", function () {
        showLoading();

        //send mail
        $.post(pathPrefix + "Salary/SendMonthlySalary", { "UserPayPeriodID": sessionStorage.getItem("currentUserPeriodID") }, function (result) {
            removeLoading();
            showPopup(result.Value, result.Key);
        }, "json");
    });

    //when user click ReloadSalary - fetch it again from the server
    $("#jqt").on("tap", "#mySalary #btnReloadSalary", function () {
        GetMonthlySalary();
    });

    function EmptyLabels() {
        $("#mySalary #BaseGrossSalary").html("");
        $("#mySalary #GrossSalary").html("");

        $("#mySalary #IncomeTaxFederal").html("");
        $("#mySalary #IncomeTaxState").html("");
        $("#mySalary #MedicareTax").html("");
        $("#mySalary #SocialSecurityTax").html("");

        $("#mySalary #NetSalary").html("");
        $("#mySalary #NetSalaryWithBonuses").html("");

        $("#mySalary li.otherDeductionRow,#mySalary li.bonusTaxDeductibleRow,#mySalary li.bonusNotTaxDeductibleRow,#mySalary li.paymentDaySumRow").remove();
    }

    function GetMonthlySalary() {
        showLoading();

        EmptyLabels();

        //get the currency of this user
        var currency = GetCurrencyName();

        //Invoke AJAX method to get the Monthly salary of this user
        $.getJSON(pathPrefix + "Salary/MonthlySalary?UserPayPeriodID=" + sessionStorage.getItem("currentUserPeriodID") + "&rnd=" + Math.random(), function (result) {

            $("#mySalary #BaseGrossSalary").html(currency + result.BaseGrossSalaryWithoutPaymentDays);
            $("#mySalary #GrossSalary").html(currency + result.GrossSalary);

            $("#mySalary #IncomeTaxFederal").html(currency + result.IncomeTaxFederal);
            $("#mySalary #IncomeTaxState").html(currency + result.IncomeTaxState);
            $("#mySalary #MedicareTax").html(currency + result.MedicareTax);
            $("#mySalary #SocialSecurityTax").html(currency + result.SocialSecurityTax);

            //show or hide Vat Tax (מע"מ)
            if (result.VatTax != null) {
                $("#mySalary #VatTax").html(currency + result.VatTax);
                $("#mySalary #VatTaxRow").show();
            }
            else {
                $("#mySalary #VatTaxRow").hide();
            }

            window.setTimeout(function () {
                $("#mySalary #NetSalary").html(currency + result.NetSalary);
                $("#mySalary #NetSalaryWithBonuses").html(currency + result.NetSalaryWithBonuses);
            }, 100);

            $("#mySalary #WorkingHours").html(result.WorkingHours);
            $("#mySalary #ExtraHours").html(result.ExtraHours);
            $("#mySalary #Days").html(result.Days);
            $("#mySalary #WorkingDays").html(result.WorkingDays);

            $("#mySalary #CreditPoints").html(result.CreditPoints);

            /* Deductions - קיזוזים
            ---------------------------*/

            //remove all deductions
            $("#mySalary li.otherDeductionRow").remove();

            //if there is Other Deductions in this salary (קיזוזים והפרשות)
            if (result.Deductions.length > 0) {
                $("#mySalary #OtherDeductionsHeaderRow").show();

                //show all the Deductions in the list
                for (var i = 0; i < result.Deductions.length; i++) {
                    var deductionRow = $("<li class='otherDeductionRow'>" + result.Deductions[i].Name + " <small class='counter'>" + currency + result.Deductions[i].Sum + "</small></li>");
                    $("#mySalary #OtherDeductionsHeaderRow").after(deductionRow);
                }
            }
            else {
                $("#mySalary #OtherDeductionsHeaderRow").hide();
            }

            /* Bonuses TaxDeductible - תוספות שכר לפני מיסים
            ---------------------------*/

            //remove all bonuses
            $("#mySalary li.bonusTaxDeductibleRow").remove();

            //if there is Bonuses in this salary
            if (result.Bonuses_TaxDeductible.length > 0) {
                $("#mySalary #BonusesTaxDeductibleHeaderRow").show();

                //show all the Bonuses (TaxDeductible) in the list
                for (var i = 0; i < result.Bonuses_TaxDeductible.length; i++) {
                    var bonusRow = $("<li class='bonusTaxDeductibleRow'>" + result.Bonuses_TaxDeductible[i].Name + " <small class='counter'>" + currency + result.Bonuses_TaxDeductible[i].Sum + "</small></li>");
                    $("#mySalary #BonusesTaxDeductibleHeaderRow").after(bonusRow);
                }
            }
            else {
                $("#mySalary #BonusesTaxDeductibleHeaderRow").hide();
            }

            /* Bonuses NotTaxDeductible - תוספות שכר אחרי מיסים
            ---------------------------*/

            //remove all bonuses
            $("#mySalary li.bonusNotTaxDeductibleRow").remove();

            //if there is Bonuses in this salary (קיזוזים והפרשות)
            if (result.Bonuses_NotTaxDeductible.length > 0) {
                $("#mySalary #BonusesNotTaxDeductibleHeaderRow").show();
                $("#mySalary #NetWithBonusesRow").show();

                //show all the Bonuses (Not TaxDeductible) in the list
                for (var i = 0; i < result.Bonuses_NotTaxDeductible.length; i++) {
                    var bonusRow = $("<li class='bonusNotTaxDeductibleRow'>" + result.Bonuses_NotTaxDeductible[i].Name + " <small class='counter'>" + currency + result.Bonuses_NotTaxDeductible[i].Sum + "</small></li>");
                    $("#mySalary #BonusesNotTaxDeductibleHeaderRow").after(bonusRow);
                }
            }
            else {
                $("#mySalary #BonusesNotTaxDeductibleHeaderRow").hide();
                $("#mySalary #NetWithBonusesRow").hide();
            }

            /* RateRanges - סיכום תעריפים חודשי
            -------------------------------*/

            //remove all rate ranges
            $("#mySalary ol#RateRangeSums li:not(:first)").remove();

            //if there are rate ranges
            if (result.RateRangeSums.length > 0) {
                $("#mySalary #noRateRangeSums").hide();
                $("#mySalary ol#RateRangeSums").show();

                var rateRangeSumRowTemplate = Handlebars.templates["rateRangeSumRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.RateRangeSums.length; i++) {
                    listHtml += $.trim(rateRangeSumRowTemplate(result.RateRangeSums[i]));
                }

                //add footer row
                listHtml += $.trim(rateRangeSumRowTemplate({ "RateName": "-", "RateValue": "-", "TotalHours": result.RateRangesTotalHours }));

                $("#mySalary ol#RateRangeSums").append(listHtml);
            }
            else {
                $("#mySalary #noRateRangeSums").show();
                $("#mySalary ol#RateRangeSums").hide();
            }

            /* PaymentDaySums - סיכום חודשי של תשלומים יומיים
            ---------------------------*/

            //remove all payment days
            $("#mySalary li.paymentDaySumRow").remove();

            //if there is PaymentDaysSums in this salary (תשלומי יום מלא)
            if (result.PaymentDaySums.length > 0) {
                //show all the items in the list
                for (var i = 0; i < result.PaymentDaySums.length; i++) {
                    var paymentDaySumRow = $("<li class='paymentDaySumRow'>" + result.PaymentDaySums[i].Name + " <div class='recordsCounter'>" + result.PaymentDaySums[i].Count + "x</div> <small class='counter'>" + currency + result.PaymentDaySums[i].Sum + "</small></li>");
                    $("#mySalary #BaseGrossSalaryRow").after(paymentDaySumRow);
                }
            }

            /*---------------------------*/

            // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
            if (!Modernizr.overflowscrolling) {
                window.setTimeout(function () {
                    //set scroller
                    var scroller = $('#mySalary').data("scroller");
                    scroller.refresh();
                }, 0);
            }

            removeLoading();
        }).fail(function () {
            console.log("My Salary - error");

            // wait a bit and recall the function
            window.setTimeout(function () {
                GetMonthlySalary();
            }, 2000);
        });
    }
});