﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#newUser', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            $("#newUser form")[0].reset();
            LoadFormData();
        }
    });

    //when this page loads first time (Animation END)
    $('#jqt').on('pageAnimationEnd', '#newUser', function (event, info) {
        if (info.direction == 'in') {

            //show dialog (for INSERT MODE)
            window.setTimeout(function () {
                if (editMode != null) {
                    if (editMode == false) {
                        showDialog("<div class='title'>Tutorial<span class='close'>X</span></div><div class='content'></div><div class='bottom'><a href='#' class='prev'>< Prev</a><a href='#' class='next'>Next ></a></div>", "NewUserWizard", true);
                        ChangeToWizardStep(1);
                    }
                }
            }, 500);
        }
    });

    //when changing birth date - show/hide the degree div
    $("#jqt").on("change", "#newUser #BirthDate", function () {
        var dateValue = $(this).val();

        //if there is value in the date field
        if (dateValue != "") {
            var birthDate = new Date(dateValue);
            
            var age = calculate_age(birthDate.getMonth(), birthDate.getDate(), birthDate.getFullYear());

            $("#newUser #AgeLabel").html(age + " yo");
        }
    });

    //when changing the option in "OptionsSelector"
    $("#jqt").on("tap", "#newUser .optionsSelector > div", function () {
        //set the value in the relevant hidden field
        var value = $(this).data("value");
        $(this).siblings(":hidden").val(value);
    });

    $("#jqt").on("change", "#newUser select", function () {
        var selectedVal = $(this).find("option:selected").html();

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedVal);
    });

    //ADD USER
    $("#jqt").on("tap", "#newUser #btnAddUser", function () {
        var user = $("#newUser form").serializeObject();

        if (user.BirthDate != "" && user.Email != "" && user.Password != "" && user.FederalFilingStatusID != "" && user.StateID != "") {
            if (user.Email.indexOf("@") >= 0 && user.Email.indexOf(".") >= 0) {
                showLoading();

                //Invoke AJAX method to add new user
                $.post(pathPrefix + "Users/Add", user, function (result) {
                    showPopup(result.Value, result.Key);

                    //if success
                    if (result.Key) {
                        localStorage.setItem("Email", user.Email);
                        localStorage.setItem("RememberEmail", user.Email);

                        window.setTimeout(function () {
                            jqtouch.goTo("SalaryForm.html", 'slideleft');
                            removeLoading();
                        }, 2000);
                    }
                    else {
                        removeLoading();
                    }
                }, "json");
            }
            else {
                showPopup("Invalid email address.", false);
            }
        }
        else {
            showPopup("Please enter all required fields.", false);
        }

        return false;
    });

    //EDIT USER
    $("#jqt").on("tap", "#newUser #btnEditUser", function () {
        var user = $("#newUser form").serializeObject();

        if (user.BirthDate != "" && user.Email != "" && user.FederalFilingStatusID != "" && user.StateID != "") {
            showLoading();

            //Invoke AJAX method to update this user
            $.post(pathPrefix + "Users/Update", user, function (result) {
                localStorage.setItem("Email", user.Email);
                localStorage.setItem("RememberEmail", user.Email);

                jqtouch.goBack();
                removeLoading();
            }, "json");
        }
        else {
            showPopup("Please enter all required fields.", false);
        }

        return false;
    });

    function calculate_age(birth_month, birth_day, birth_year) {
        today_date = new Date();
        today_year = today_date.getFullYear();
        today_month = today_date.getMonth();
        today_day = today_date.getDate();
        age = today_year - birth_year;

        if (today_month < (birth_month)) {
            age--;
        }

        if (((birth_month) == today_month) && (today_day < birth_day)) {
            age--;
        }

        return age;
    }

    var editMode = null;

    function LoadFormData() {
        //Invoke AJAX method to get the list of states
        $.getJSON(pathPrefix + "States/GetStates", function (result) {
            $("#newUser #StateID option:not(:first)").remove();

            //bind the list of states
            if (result != null && result != "") {
                for (var i = 0; i < result.length; i++) {
                    $("#newUser #StateID").append("<option value='" + result[i].StateID + "'>" + result[i].StateName + "</option>");
                }
            }

            //Invoke AJAX method to get the current data of this user (to allow him EDIT)
            $.getJSON(pathPrefix + "Users/GetUserData", function (result) {
                if (result != null && result != "") {
                    var BirthDate = result.BirthDate;

                    var birthDateElement = $("#newUser #BirthDate");
                    birthDateElement.val(BirthDate);
                    birthDateElement.trigger("change");

                    //set value for FederalFilingStatusID
                    var filingStatusElement = $("#newUser #FederalFilingStatusID");
                    filingStatusElement.val(result.FederalFilingStatusID);
                    filingStatusElement.trigger("change");

                    //set value for StateID
                    var stateElement = $("#newUser #StateID");
                    stateElement.val(result.StateID);
                    stateElement.trigger("change");

                    $("#newUser #Email").val(result.Email);
                    $("#newUser #DependentsNumber").val(result.DependentsNumber); // מספר ילדים

                    //זכר-נקבה
                    $("#newUser #isFemaleDiv .optionsSelector > div[data-value=" + result.IsFemale + "]").trigger("tap");

                    //EDIT MODE - show relevant button
                    $("#newUser #btnAddUser").hide();
                    $("#newUser #btnEditUser").show();
                    $("#newUser h1").html("User Details");
		            $("#newUser #Password").attr("placeholder", "Enter New Password (to change)");
                    editMode = true;
                }
                //INSERT MODE
                else {
                    editMode = false;
                }

                //add "mobiscroll" plugin to show date picker
                $("#newUser #BirthDate").mobiscroll().date(mobiscrollDateOptions);

                //update the values of the native date selectors (iOS only)
                UpdateNativeDateSelectors();
            });
        });
    }

    /* NewUser Wizard Steps
    -----------------------*/

    function ChangeToWizardStep(step) {
        //set the relevant content
        if (step == 1) {
            $("#jqt .dialog .content").html('Welcome to "My Wage" application. This is the registration page.<br />Here you will enter your user details and create your profile in the app.<br /><br />Your personal details will be used to calculate your tax-filing classification and won\'t be used elsewhere.');

            localStorage.setItem("newUserWizardStep", step);
        }
        else if (step == 2) {
            $("#jqt .dialog .content").html('The email address you\'ll enter here will be your ID in the app.');

            localStorage.setItem("newUserWizardStep", step);
        }
        else if (step == 3) {
            $("#jqt .dialog .content").html('If you\'re working in more than one job - you will be able to create multiple profiles after this initial registration.');

            localStorage.setItem("newUserWizardStep", step);
        }
        else if (step == 4) {
            CloseWizard();
        }

        //show or hide the Previous button
        if (step == 1) {
            $("#jqt .dialog .bottom a.prev").css("visibility", "hidden");
            verticalCenterDialog();
        }
        else {
            $("#jqt .dialog .bottom a.prev").css("visibility", "visible");
        }

        if (step == 3) {
            $("#jqt .dialog .bottom a.next").html("Done");
        }
        else {
            $("#jqt .dialog .bottom a.next").html("Next >");
        }
    }

    function CloseWizard() {
        $("#jqt .fullScreenOverlay").remove();
        $("#jqt .dialog").remove();

        localStorage.removeItem("newUserWizardStep");
    }

    /* NewUser Wizard Buttons
    -------------------------*/

    $('#jqt').on('tap', '#NewUserWizard .title .close', function () {
        CloseWizard();
    });

    $('#jqt').on('tap', '#NewUserWizard .bottom a.prev', function () {
        var currentStep = localStorage.getItem("newUserWizardStep");
        ChangeToWizardStep(parseInt(currentStep) - 1);
    });

    $('#jqt').on('tap', '#NewUserWizard .bottom a.next', function () {
        var currentStep = localStorage.getItem("newUserWizardStep");
        ChangeToWizardStep(parseInt(currentStep) + 1);
    });
});