﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#news', function (event, info) {
        if (info.direction == 'in') {
            LoadFormData();
        }
    });

    //when the user click on a link in the News list
    $("#jqt").on("tap", "#news ul li a[data-news-id]", function () {
        var newsId = $(this).data("news-id");
        sessionStorage.setItem("NewsItemId", newsId);

        jqtouch.goTo("NewsItem.html", "slideleft");
    });

    function LoadFormData() {
        CheckNewsItemsAlreadyRead();

        //get the news list from the local storage
        var newsItemsJSON = localStorage.getItem("NewsItems");

        if (newsItemsJSON != null) {
            var newsItems = JSON.parse(newsItemsJSON);

            $("#news #NewsItems").empty();

            var newsItemRowTemplate = Handlebars.templates["newsItemRowTemplate"];

            var listHtml = "";

            //bind the news items list
            for (var i = 0; i < newsItems.length; i++) {
                listHtml += $.trim(newsItemRowTemplate(newsItems[i]));
            }
            $("#news #NewsItems").append(listHtml);
        }
    }

    /*----------------------------------------------------*/

    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#newsItem', function (event, info) {
        if (info.direction == 'in') {

            var newsItemId = sessionStorage.getItem("NewsItemId");
            if (newsItemId != null) {
                newsItemId = parseInt(newsItemId);

                showLoading();

                //Invoke AJAX method to get the specified news item
                $.getJSON(pathPrefix + "News/GetNewsItem?NewsID=" + newsItemId, function (result) {
                    $("#newsItem #NewsItemDate").html(result.Date);
                    $("#newsItem #NewsItemTitle").html(result.Title);
                    $("#newsItem #NewsItemText").html(result.Text);

                    removeLoading();
                });

                //add this news item to the NewsItemsAlreadyRead list
                var newsItemsAlreadyRead = new Array();

                var newsItemsAlreadyReadJSON = localStorage.getItem("NewsItemsAlreadyRead");
                if (newsItemsAlreadyReadJSON != null) {
                    newsItemsAlreadyRead = JSON.parse(newsItemsAlreadyReadJSON);
                }

                //if not exist already
                if (newsItemsAlreadyRead.indexOf(newsItemId) < 0) {
                    newsItemsAlreadyRead.push(newsItemId);
                }

                //save the AlreadyRead news list
                localStorage.setItem("NewsItemsAlreadyRead", JSON.stringify(newsItemsAlreadyRead));
            }
        }
    });

    //when the user clicks on "Unread News Item" (סמן פריט כ"לא נקרא")
    $("#jqt").on("tap", "#newsItem #btnUnreadNewsItem", function () {
        var newsItemId = sessionStorage.getItem("NewsItemId");

        if (newsItemId != null) {
            newsItemId = parseInt(newsItemId);

            var newsItemsAlreadyReadJSON = localStorage.getItem("NewsItemsAlreadyRead");
            if (newsItemsAlreadyReadJSON != null) {
                var newsItemsAlreadyRead = JSON.parse(newsItemsAlreadyReadJSON);

                //remove this news item from the AlreadyRead list
                var newsItemIndex = newsItemsAlreadyRead.indexOf(newsItemId);
                if (newsItemIndex >= 0) {
                    newsItemsAlreadyRead.splice(newsItemIndex, 1);
                }

                //save the AlreadyRead news list
                localStorage.setItem("NewsItemsAlreadyRead", JSON.stringify(newsItemsAlreadyRead));
            }

            showSmallPopup("The message has been marked as unread.", true);
        }
    });
});