﻿$(document).ready(function () {
    //when this page loads
    $('#jqt').on('pageAnimationStart', '#offlineMode', function (event, info) {
        if (info.direction == 'in') {

            $("#offlineMode #userEmail").html(localStorage.getItem("Email"));
            LoadAjaxCallsList();
        }
    });

    var row;
    var deleteIndex;

    //when the user delete call from the AjaxCalls list
    $("#jqt").on("tap", "#offlineMode #AjaxCallsList li .deleteAjaxCall", function () {
        row = $(this).parents("li");
        deleteIndex = row.index("#offlineMode #AjaxCallsList li");

        showDialog("<div class='title'>Remove Shift<span class='close'>X</span></div><div class='content'>Do you want to remove this shift?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "DeleteAjaxCallDialog");
    });
    $("#jqt").on("tap", "#offlineMode #DeleteAjaxCallDialog .confirm", function () {
        var waitingAjaxCallsValue = localStorage.getItem("WaitingAjaxCalls");
        if (waitingAjaxCallsValue != null) {
            var waitingAjaxCalls = JSON.parse(waitingAjaxCallsValue);

            //delete the specified AjaxCall from the array
            waitingAjaxCalls.splice(parseInt(deleteIndex) - 1, 1);

            //save the updated "WaitingAjaxCalls" array
            localStorage.setItem("WaitingAjaxCalls", JSON.stringify(waitingAjaxCalls));
        }

        LoadAjaxCallsList();
    });

    //Set Shift (התחל/סיים משמרת במצב מנותק)
    $("#jqt").on("tap", "#offlineMode #btnOfflineModeSetShift", function () {
        var currentTime = GetCurrentDate() + " " + GetCurrentTime();

        //add the AjaxCall to the localStorage
        var waitingAjaxCalls = new Array();

        var waitingAjaxCallsValue = localStorage.getItem("WaitingAjaxCalls");
        if (waitingAjaxCallsValue != null) {
            waitingAjaxCalls = JSON.parse(waitingAjaxCallsValue);
        }

        var call = {
            "Action": pathPrefix + "Shifts/SetShift",
            "Data":
            {
                "currentTime": currentTime
            }
        };
        waitingAjaxCalls.push(call);

        //save the updated "WaitingAjaxCalls" array
        localStorage.setItem("WaitingAjaxCalls", JSON.stringify(waitingAjaxCalls));

        LoadAjaxCallsList();
    });

    function LoadAjaxCallsList() {
        var waitingAjaxCallsValue = localStorage.getItem("WaitingAjaxCalls");
        if (waitingAjaxCallsValue != null) {
            var waitingAjaxCalls = JSON.parse(waitingAjaxCallsValue);

            $("#offlineMode ol#AjaxCallsList li:not(:first)").remove();

            if (waitingAjaxCalls.length == 0) {
                $("#offlineMode ol#AjaxCallsList").hide();
            }
            else {
                $("#offlineMode ol#AjaxCallsList").show();

                var ajaxCallRowTemplate = Handlebars.templates["ajaxCallRowTemplate"];

                var listHtml = "";

                //loop through the AjaxCalls saved and bind to the list
                for (var i = 0; i < waitingAjaxCalls.length; i++) {
                    listHtml += $.trim(ajaxCallRowTemplate(waitingAjaxCalls[i].Data));
                }
                $("#offlineMode ol#AjaxCallsList").append(listHtml);
            }
        }
        else {
            $("#offlineMode ol#AjaxCallsList").hide();
        }
    }
});