﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#presetShiftsManager', function (event, info) {
        if (info.direction == 'in') {

            LoadFormData();
        }
    });

    //when user click Edit on specific preset shift
    $("#jqt").on("tap", "#presetShiftsManager ul#PresetShiftsList li > a.EditButton", function () {
        var row = $(this).parents("li[data-preset-shift-id]");
        var presetShiftId = row.data("preset-shift-id");

        sessionStorage.setItem("EditPresetShiftId", presetShiftId);

        jqtouch.goTo("AddPresetShift.html", "slideup");
    });

    //when clicking on delete preset shifts
    $("#jqt").on("tap", "#presetShiftsManager #btnDeletePresetShifts", function () {
        if ($(this).hasClass("clicked")) {
            $(this).html("Delete");
            $(this).removeClass("clicked");

            //change all the "clicked" buttons back to regular mode
            $("#presetShiftsManager ul#PresetShiftsList li .Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            //hide the delete button
            $("#presetShiftsManager ul#PresetShiftsList li .Edit a").hide();
            $("#presetShiftsManager ul#PresetShiftsList li").removeClass("deleteActive");
        }
        else {
            $(this).html("Cancel");
            $(this).addClass("clicked");

            //show the delete button
            $("#presetShiftsManager ul#PresetShiftsList li .Edit a").show();
            $("#presetShiftsManager ul#PresetShiftsList li").addClass("deleteActive");
        }
    });

    //when user click Delete on specific preset shift
    $("#jqt").on("tap", "#presetShiftsManager ul#PresetShiftsList li > div.Edit a", function () {

        //if the delete button is active
        if ($(this).hasClass("clicked")) {
            var row = $(this).parents("li[data-preset-shift-id]");
            var presetShiftId = row.data("preset-shift-id");

            showLoading();

            //Invoke AJAX to delete the shift
            $.post(pathPrefix + "PresetShifts/DeletePresetShift", { "PresetShiftID": presetShiftId }, function (result) {
                row.remove();
                removeLoading();
            });

            $(this).removeClass("clicked");
        }
        else {
            //change all the "clicked" buttons back to regular mode
            $("#presetShiftsManager ul#PresetShiftsList li > div.Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            $(this).find("span").html("Del");
            $(this).addClass("clicked").addClass("small");
        }
    });

    function LoadFormData() {
        $("#presetShiftsManager ul#PresetShiftsList").empty();

        //get list of preset shists
        $.getJSON(pathPrefix + "PresetShifts/GetPresetShifts", function (result) {
            //there are no shifts - show message
            if (result.length == 0) {
                $("#presetShiftsManager .info").show();
                $("#presetShiftsManager #PresetShiftsListContainer").hide();
            }
            else {
                var presetShiftRowTemplate = Handlebars.templates["presetShiftRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.length; i++) {
                    var data = result[i];

                    data.TimeDescription = "Changing Times";
                    //if there are fixed StartTime-EndTime
                    if (data.StartTime != null && data.EndTime != null) {
                        if (data.StartTime != "" && data.EndTime != "") {
                            data.TimeDescription = data.StartTime + " - " + data.EndTime;
                        }
                    }

                    //if there is fixed money for this presetShift (שכר מוגדר מראש)
                    if (data.Money != null) {
                        if (data.Money != "") {
                            var currency = GetCurrencyName();
                            data.MoneyDescription = "(" + currency + data.Money + ")";
                        }
                    }

                    listHtml += $.trim(presetShiftRowTemplate(data));
                }
                $("#presetShiftsManager ul#PresetShiftsList").append(listHtml);

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    window.setTimeout(function () {
                        if (myScroll) {
                            myScroll.refresh();
                        }
                    }, 0);
                }

                $("#presetShiftsManager .info").hide();
                $("#presetShiftsManager #PresetShiftsListContainer").show();
            }
        });
    }
});