﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#presetShiftsSelect', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            $("#presetShiftsSelect form")[0].reset();

            LoadFormData();
        }
    });

    //when this page loads first time
    $('#jqt').on('pageAnimationEnd', '#presetShiftsSelect', function (event, info) {
        if (info.direction == 'in') {

            //update the values of the native date selectors (iOS only)
            UpdateNativeDateSelectors();
        }
    });

    //when changing the ShiftDate value
    $("#jqt").on("change", "#presetShiftsSelect #ShiftDate", ShowDayName);


    //when changing the StartDateFake value (which is the upper one, the one that the user can click on)
    $("#jqt").on("change", "#presetShiftsSelect #StartTimeFake", function () {
        //update the real textbox value
        var startDate = $(this).val();
        $("#presetShiftsSelect #StartTime").val(startDate);

        var currentEndDate = $("#presetShiftsSelect #EndTime").val();

        //check that there is no EndDate entered already
        if (currentEndDate == "") {
            //add one minute to the EndDate (in the Fake textbox - so that when the user click - it will be shown as the initial date
            var startDate = $(this).val();
            if (startDate != "") {
                var endDate = AddOneMinute(startDate);
                var endDateElement = $("#presetShiftsSelect #EndTimeFake");
                endDateElement.val(endDate);

                //update the "mobiscroll" plugin value
                var dateTimeParts = endDate.split(" ");
                var dateParts = dateTimeParts[0].split("/");
                var timeParts = dateTimeParts[1].split(":");
                var endDateObj = new Date(dateParts[2], parseInt(dateParts[0], 10) - 1, dateParts[1], timeParts[0], timeParts[1], 0, 0);
                // add am-pm (12 hours if PM)
                if (endDate.toUpperCase().indexOf("PM") >= 0) {
                    endDateObj.setHours(endDateObj.getHours() + 12);
                }
                endDateElement.mobiscroll("setDate", endDateObj, false);

                //update the values of the native date selectors (iOS only)
                UpdateNativeDateSelectors();
            }
        }
    });

    //when changing the EndDateFake value (which is the upper one, the one that the user can click on)
    $("#jqt").on("change", "#presetShiftsSelect #EndTimeFake", function () {
        //update the real textbox value
        var endDate = $(this).val();
        $("#presetShiftsSelect #EndTime").val(endDate);
    });

    //set specific presetShift as selected
    $("#jqt").on("tap", "#presetShiftsSelect ul#PresetShiftsSelectList li", function () {
        $(this).siblings(".selected").removeClass("selected");
        $(this).addClass("selected");

        //if this presetShift has StartTime-EndTime defined (שעות קבועות)
        var startTime = $(this).data("start-time");
        if (startTime != null && startTime != "") {
            $("#presetShiftsSelect #dateSelectionDiv").show();
            $("#presetShiftsSelect #timesSelectionDiv").hide();

            $("#presetShiftsSelect #dateSelectionDiv input").prop("disabled", false);
            $("#presetShiftsSelect #timesSelectionDiv input").prop("disabled", true);
        }
        else {
            $("#presetShiftsSelect #dateSelectionDiv").hide();
            $("#presetShiftsSelect #timesSelectionDiv").show();

            $("#presetShiftsSelect #dateSelectionDiv input").prop("disabled", true);
            $("#presetShiftsSelect #timesSelectionDiv input").prop("disabled", false);
        }
    });

    //SELECT PRESET SHIFT (and add shift)
    $("#jqt").on("tap", "#presetShiftsSelect #btnSelectPresetShift", function () {
        var data = $("#presetShiftsSelect form").serializeObject();
        data.PresetShiftID = $("#presetShiftsSelect ul#PresetShiftsSelectList li.selected").data("preset-shift-id");

        if (data.PresetShiftID != null) {
            if ($("#timesSelectionDiv:visible").length == 0 || (data.StartTime != "" && data.EndTime != "")) {
                showLoading();

                //Invoke AJAX method to add this selected preset shift as a shift if this user's shifts
                $.post(pathPrefix + "Shifts/SetPresetShift", data, function (result) {
                    //if success
                    if (result.Key) {
                        sessionStorage.setItem("ShouldUpdateShifts", true);

                        jqtouch.goBack();

                        AddShiftToIphoneCalendar(result.AddedShift);
                    }
                    else {
                        showPopup(result.Value, result.Key);
                    }
                    removeLoading();
                }, "json");
            }
            else {
                showPopup("Please enter start and end times.", false);
            }
        }
        else {
            showPopup("Please select a shift.", false);
        }
    });

    function LoadFormData() {
        $("#presetShiftsSelect ul#PresetShiftsSelectList").empty();

        $("#presetShiftsSelect #dateSelectionDiv").hide();
        $("#presetShiftsSelect #timesSelectionDiv").hide();

        //get list of preset shists
        $.getJSON(pathPrefix + "PresetShifts/GetPresetShifts", function (result) {
            //there are no shifts - show message
            if (result.length == 0) {
                $("#presetShiftsSelect .info").show();
                $("#presetShiftsSelect #PresetShiftsListContainer").hide();
            }
            else {
                var presetShiftSelectRowTemplate = Handlebars.templates["presetShiftSelectRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.length; i++) {
                    var data = result[i];

                    data.TimeDescription = "Changing Times";
                    //if there are fixed StartTime-EndTime (שעות קבועות)
                    if (data.StartTime != null && data.EndTime != null) {
                        if (data.StartTime != "" && data.EndTime != "") {
                            data.TimeDescription = data.StartTime + " - " + data.EndTime;
                        }
                    }

                    //if there is fixed money for this presetShift (שכר מוגדר מראש)
                    if (data.Money != null) {
                        if (data.Money != "") {
                            var currency = GetCurrencyName();
                            data.MoneyDescription = "(" + currency + data.Money + ")";
                        }
                    }

                    listHtml += $.trim(presetShiftSelectRowTemplate(data));
                }
                $("#presetShiftsSelect ul#PresetShiftsSelectList").append(listHtml);

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    window.setTimeout(function () {
                        if (myScroll) {
                            myScroll.refresh();
                        }
                    }, 0);
                }

                $("#presetShiftsSelect .info").hide();
                $("#presetShiftsSelect #PresetShiftsListContainer").show();
            }
        });

        /*show the current date in the "ShiftDate" field
        -----------------------------------------------*/

        var shiftDate = GetCurrentDate();

        var selectedView = localStorage.getItem("MonthlyShiftsView");
        var selectedDate = sessionStorage.getItem("CalendarViewSelectedDate");

        //if there is a selected date in the calendar (and the user's view is the calendar)
        if (selectedView == "calendar" && selectedDate != null) {
            shiftDate = selectedDate;

            var startTimeInitialValue = selectedDate + " " + GetCurrentTime();
            //set this as the default date (in the Fake textbox - so that when the user click - it will be shown as the initial date, but won't be shown on the textbox)
            $("#presetShiftsSelect #StartTimeFake").val(startTimeInitialValue);
        }

        var shiftDateElement = $("#presetShiftsSelect #ShiftDate");
        shiftDateElement.val(shiftDate).trigger("change");

        //add "mobiscroll" plugin to show date picker (for ShiftDate)
        shiftDateElement.mobiscroll().date(mobiscrollDateOptions);

        //add "mobiscroll" plugin to show datetime picker (for StartTime-EndTime)
        var dateFields = $("#presetShiftsSelect #StartTime,#presetShiftsSelect #EndTime,#presetShiftsSelect #StartTimeFake,#presetShiftsSelect #EndTimeFake");
        dateFields.mobiscroll().datetime(mobiscrollDateOptions);
    }
});