﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationEnd', '#quickSalary', function (event, info) {
        if (info.direction == 'in') {
            GetCurrencyName();
        }
    });

    //CALC SALARY
    $("#jqt").on("tap", "#quickSalary #btnCalcSalary", function () {
        var data = $("#quickSalary form").serializeObject();
        sessionStorage.setItem("QuickSalaryFormData", JSON.stringify(data));

        if (data.HourSalary != "" && data.Hours != "" && data.HourSalary != "0" && data.Hours != "0") {

            //Invoke AJAX method to calc quick salary
            $.post(pathPrefix + "Salary/QuickSalary", data, function (result) {
                sessionStorage.setItem("QuickSalaryData", JSON.stringify(result));

                jqtouch.goTo("QuickSalaryCalc.html", "slideleft");
            }, "json");
        }
        else {
            showPopup("Please enter all required fields.", false);
        }
    });

    //when this page loads first time
    $('#jqt').on('pageAnimationEnd', '#quickSalaryCalc', function (event, info) {
        if (info.direction == 'in') {

            var quickSalaryData = sessionStorage.getItem("QuickSalaryData");

            if (quickSalaryData != null) {
                sessionStorage.removeItem("QuickSalaryData");

                quickSalaryData = JSON.parse(quickSalaryData);
                var currency = GetCurrencyName();

                $("#quickSalaryCalc #BaseGrossSalary").html(currency + quickSalaryData.BaseGrossSalary);
                $("#quickSalaryCalc #GrossSalary").html(currency + quickSalaryData.GrossSalary);
                $("#quickSalaryCalc #DrivingBonus").html(currency + quickSalaryData.DrivingBonus);
                $("#quickSalaryCalc #IncomeTax").html(currency + quickSalaryData.IncomeTax);
                $("#quickSalaryCalc #HealthyTax").html(currency + quickSalaryData.HealthyTax);
                $("#quickSalaryCalc #InsuranceTax").html(currency + quickSalaryData.InsuranceTax);
                $("#quickSalaryCalc #NetSalary").html(currency + quickSalaryData.NetSalary);
            }
        }
    });

    //when user click SendQuickSalaryMail - show Confirm dialog
    $("#jqt").on("tap", "#quickSalaryCalc #SendQuickSalaryMail", function () {
        showDialog("<div class='title'>Export to Email<span class='close'>X</span></div><div class='content'>Do you want to send the data to your email?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "SendQuickSalaryMailDialog");
    });
    $("#jqt").on("tap", "#quickSalaryCalc #SendQuickSalaryMailDialog .confirm", function () {
        //get the form data
        var quickSalaryFormData = sessionStorage.getItem("QuickSalaryFormData");
        if (quickSalaryFormData != null) {
            showLoading();

            var data = JSON.parse(quickSalaryFormData);

            //send mail
            $.post(pathPrefix + "Salary/SendQuickSalary", data, function (result) {
                removeLoading();
                showPopup(result.Value, result.Key);
            }, "json");
        }
    });
});