﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#salaryForm', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            $("#salaryForm form")[0].reset();
            LoadFormData();
        }
    });

    //when this page loads first time (Animation END)
    $('#jqt').on('pageAnimationEnd', '#salaryForm', function (event, info) {
        if (info.direction == 'in') {

            //show dialog (for INSERT MODE)
            window.setTimeout(function () {
                if (editMode != null) {
                    if (editMode == false) {
                        showDialog("<div class='title'>Tutorial<span class='close'>X</span></div><div class='content'></div><div class='bottom'><a href='#' class='close full'>Done</a></div>", "SalaryWizard", true);
                        ChangeToWizardStep(1);
                    }
                }
            }, 500);

            GetCurrencyName();
        }
    });

    //when changing any checkbox value on this page - change the Value of the relevant hidden field
    $("#jqt").on("change", "#salaryForm input[type=checkbox]", UpdateCheckboxValue);

    //when changing BreakTimeDeduction - show/hide the BreakTimeLength div
    $("#jqt").on("change", "#salaryForm #BreakTimeDeduction", function () {
        var BreakTimeDeduction = $(this).prop("checked");

        if (BreakTimeDeduction == true) {
            $("#salaryForm #breakTimeLengthDiv").show();
            $("#salaryForm #BreakTimeLength").val("30");
        }
        else {
            $("#salaryForm #breakTimeLengthDiv").hide();
            $("#salaryForm #BreakTimeLength").val("");
        }
    });

    var data;

    //UPDATE SALARY
    $("#jqt").on("tap", "#salaryForm #btnUpdateSalary", function () {
        var inputElements = $("#salaryForm form");
        data = inputElements.serializeObject();

        //count the textboxes with no value (only visible textboxes)
        var hiddenSalarySections = $("#salaryForm .salarySection:not(:visible)");
        hiddenSalarySections.css({ "position": "absolute", "bottom": "-500px" }).show();
        var emptyTextboxes = inputElements.find("[type=tel][value='']:visible,[type=number][value='']:visible").length;
        hiddenSalarySections.hide().css({ "position": "static" });

        //if all textboxes have values
        if (data.HourSalary != "" && emptyTextboxes == 0) {
            if (editMode) {
                showDialog("<div class='title'>Wage Changes<span class='close'>X</span></div><div class='content'>You are about to change your Wage Settings.<br />Do you want these changes to affect existing shifts in the current period as well?</div><div class='bottom'><a href='#' class='confirm'>Yes, change all period's shifts</a><a href='#' class='close'>No, only new shifts</a></div>", "UpdateSalaryFormDialog");
            }
            else {
                InvokeUpdateSalary(false);
            }
        }
        else {
            showPopup("Please enter all required fields.", false);
        }
    });

    //buttons for dialog (ask the user if he wants to recalculate the shifts after these settings changes)
    $("#jqt").on("tap", "#salaryForm #UpdateSalaryFormDialog .confirm", function () {
        InvokeUpdateSalary(true);
    });
    $("#jqt").on("tap", "#salaryForm #UpdateSalaryFormDialog .close", function () {
        InvokeUpdateSalary(false);
    });

    //this function will invoke AJAX to update the salary settings (and if the user choose - it will also reCalculate the current shifts)
    function InvokeUpdateSalary(reCalculateShifts) {
        showLoading();

        //Invoke AJAX method to update the salary settings data
        $.post(pathPrefix + "Users/UpdateSalary", data, function () {
            if (reCalculateShifts == false) {
                EndUpdateSalary();
            }
            else {
                //Invoke AJAX method to recalculate the shifts with the new salary settings
                $.post(pathPrefix + "Shifts/ReCalculateAllShifts", { "UserPayPeriodID": sessionStorage.getItem("currentUserPeriodID") }, function () {
                    EndUpdateSalary();
                }, "json");
            }

            GetUserSettings();
        }, "json");
    }

    //this function will be called after the SalarySettings have been updated
    function EndUpdateSalary() {
        if (editMode) {
            sessionStorage.setItem("ShouldUpdateShifts", true);
            jqtouch.goBack();
        }
        else {
            jqtouch.goTo("UserPayPeriod.html", 'slideleft');
        }

        removeLoading();
    }

    var editMode = null;

    function LoadFormData() {
        //Invoke AJAX method to get the current salary data of this user (to allow him EDIT)
        $.getJSON(pathPrefix + "Users/GetSalaryData", function (result) {
            if (result != null && result != "") {
                $("#salaryForm #HourSalary").val(result.HourSalary);

                //if the user has Break Time Deduction
                if (result.BreakTimeDeduction) {
                    var breakTimeDeduction = $("#salaryForm #BreakTimeDeduction");
                    breakTimeDeduction.prop("checked", true);
                    breakTimeDeduction.trigger("change");

                    $("#salaryForm #BreakTimeLength").val(result.BreakTimeLength);
                }

                //EDIT MODE - show back button
                $("#salaryForm .goback").show();
                editMode = true;
            }
            //INSERT MODE
            else {
                editMode = false;
            }
        });
    }

    /* Salary Wizard Steps
    -----------------------*/

    function ChangeToWizardStep(step) {
        //set the relevant content
        if (step == 1) {
            $("#jqt .dialog .content").html('Welcome to the "Wage Settings" page.<br />Here you define your pay per hour.<br /><br />According to the data you will enter here, the application will calculate your gross and net pay.<br />Obviously you will be able to update this data later.');

            localStorage.setItem("salaryWizardStep", step);
        }
        else if (step == 2) {
            CloseWizard();
        }

        //show or hide the Previous button
        if (step == 1) {
            $("#jqt .dialog .bottom a.prev").css("visibility", "hidden");
            verticalCenterDialog();
        }
        else {
            $("#jqt .dialog .bottom a.prev").css("visibility", "visible");
        }

        if (step == 1) {
            $("#jqt .dialog .bottom a.next").html("Done");
        }
        else {
            $("#jqt .dialog .bottom a.next").html("Next >");
        }
    }

    function CloseWizard() {
        $("#jqt .fullScreenOverlay").remove();
        $("#jqt .dialog").remove();

        localStorage.removeItem("salaryWizardStep");
    }

    /* Salary Wizard Buttons
    -------------------------*/

    $('#jqt').on('tap', '#SalaryWizard .title .close', function () {
        CloseWizard();
    });

    $('#jqt').on('tap', '#SalaryWizard .bottom a.prev', function () {
        var currentStep = localStorage.getItem("salaryWizardStep");
        ChangeToWizardStep(parseInt(currentStep) - 1);
    });

    $('#jqt').on('tap', '#SalaryWizard .bottom a.next', function () {
        var currentStep = localStorage.getItem("salaryWizardStep");
        ChangeToWizardStep(parseInt(currentStep) + 1);
    });
});