﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#salaryRates', function (event, info) {
        if (info.direction == 'in') {

            $("#salaryRates form")[0].reset();
            LoadFormData();
        }
    });

    //when changing UseExtraHours value - show/hide the relevant elements
    $("#jqt").on("change", "#salaryRates #UseExtraHours", function () {
        var useExtraHours = $(this).prop("checked");

        if (useExtraHours) {
            $("#salaryRates .extraHoursDiv").show();
        }
        else {
            $("#salaryRates .extraHoursDiv").hide();
        }
    });

    //when changing ExtraHours value - update the relevant ExtraExtraHours label
    $("#jqt").on("change", "#salaryRates #ExtraHours", function () {
        var extraHours = $(this).val();
        $("#salaryRates #ExtraExtraHoursLabel").html("After " + extraHours + " Hours");
    });

    //UPDATE SALARY RATES
    $("#jqt").on("tap", "#salaryRates #btnUpdateSalaryRates", function () {
        showDialog("<div class='title'>Wage Changes<span class='close'>X</span></div><div class='content'>You are about to change your Wage Settings.<br />Do you want these changes to affect existing shifts in the current period as well?</div><div class='bottom'><a href='#' class='confirm'>Yes, change all period's shifts</a><a href='#' class='close'>No, only new shifts</a></div>", "UpdateSalaryRatesDialog");
    });

    //buttons for dialog (ask the user if he wants to recalculate the shifts after these settings changes)
    $("#jqt").on("tap", "#salaryRates #UpdateSalaryRatesDialog .confirm", function () {
        InvokeUpdateSalaryRates(true);
    });
    $("#jqt").on("tap", "#salaryRates #UpdateSalaryRatesDialog .close", function () {
        InvokeUpdateSalaryRates(false);
    });

    //this function will invoke AJAX to update the salary rates (and if the user choose - it will also reCalculate the current shifts)
    function InvokeUpdateSalaryRates(reCalculateShifts) {
        showLoading();

        var data = $("#salaryRates form").serializeObject();

        //if the user define that he is not using Extra Hours (שעות נוספות) - change all extrahours rates to 100%
        if ($("#salaryRates #UseExtraHours").prop("checked") == false) {
            data.ExtraHoursRate = 100;
            data.ExtraExtraHoursRate = 100;
        }

        //Invoke AJAX method to update the SalaryRates data
        $.post(pathPrefix + "Users/UpdateSalaryRates", data, function (result) {
            if (reCalculateShifts == false) {
                EndUpdateSalaryRates();
            }
            else {
                //Invoke AJAX method to recalculate the shifts with the new salary settings
                $.post(pathPrefix + "Shifts/ReCalculateAllShifts", { "UserPayPeriodID": sessionStorage.getItem("currentUserPeriodID") }, function () {
                    sessionStorage.setItem("ShouldUpdateShifts", true);
                    EndUpdateSalaryRates();
                }, "json");
            }
        }, "json");
    }

    //this function will be called after the SalaryRates have been updated
    function EndUpdateSalaryRates() {
        jqtouch.goBack();
        removeLoading();
    }

    function LoadFormData() {
        //Invoke AJAX method to get the current SalaryRates data of this user (to allow him EDIT)
        $.getJSON(pathPrefix + "Users/GetSalaryRatesData", function (result) {
            if (result != null && result != "") {
                $("#salaryRates #StandardHours").val(result.StandardHours);
                $("#salaryRates #ExtraHours").val(result.ExtraHours).trigger("change");
                $("#salaryRates #ExtraHoursRate").val(result.ExtraHoursRate);
                $("#salaryRates #ExtraExtraHoursRate").val(result.ExtraExtraHoursRate);

                //check or uncheck the "UseExtraHours" checkbox (if the user have 100% in all extra hours - he is not using ExtraHours)
                var useExtraHours = $("#salaryRates #UseExtraHours");
                if (result.ExtraHoursRate == 1 && result.ExtraExtraHoursRate == 1) {
                    useExtraHours.prop("checked", false);
                }
                else {
                    useExtraHours.prop("checked", true)
                }
                useExtraHours.trigger("change");
            }
        });
    }
});