﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#settings', function (event, info) {
        if (info.direction == 'in') {

            $("#settings form")[0].reset();
            LoadFormData();
        }
    });

    //when changing any checkbox value on this page - change the Value of the relevant hidden field
    $("#jqt").on("change", "#settings input[type=checkbox]", UpdateCheckboxValue);

    $("#jqt").on("change", "#settings #CurrencyID", function () {
        var selectedType = $(this).find("option:selected").html();

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedType);
    });

    //when changing the option in "OptionsSelector"
    $("#jqt").on("tap", "#settings .optionsSelector > div", function () {
        //set the value in the relevant hidden field
        var value = $(this).data("value");
        $(this).siblings(":hidden").val(value);
    });

    //UPDATE SETTINGS
    $("#jqt").on("tap", "#settings #btnUpdateSettings", function () {
        showLoading();

        var data = $("#settings form").serializeObject();

        //Invoke AJAX method to update the settings data
        $.post(pathPrefix + "Users/UpdateSettings", data, function (result) {
            GetUserSettings();

            sessionStorage.setItem("ShouldUpdateShifts", true);
            jqtouch.goBack();
            removeLoading();
        }, "json");

        return false;
    });

    function LoadFormData() {
        //Invoke AJAX method to get the current settings data of this user (to allow him EDIT)
        $.getJSON(pathPrefix + "Users/GetSettingsData", function (result) {
            if (result != null && result != "") {
                //$("#settings #CurrencyID").val(result.CurrencyID);
                //$("#settings #CurrencyID").trigger("change");

                //if the user SendEmail
                if (result.SendEmails) {
                    var sendEmails = $("#settings #SendEmails");
                    sendEmails.prop("checked", true);
                    sendEmails.trigger("change");
                }
                //if the user select "RoundTime"
                if (result.RoundTime) {
                    var roundTime = $("#settings #RoundTime");
                    roundTime.prop("checked", true);
                    roundTime.trigger("change");
                }
                //if the user select "ShowShiftDetailsAfterInsertion"
                if (result.ShowShiftDetailsAfterInsertion) {
                    var showShiftDetails = $("#settings #ShowShiftDetailsAfterInsertion");
                    showShiftDetails.prop("checked", true);
                    showShiftDetails.trigger("change");
                }
                
                //if the user select "AddShiftsToCalendar"
                /*if (result.AddShiftsToCalendar) {
                    var addShiftsToCalendar = $("#settings #AddShiftsToCalendar");
                    addShiftsToCalendar.prop("checked", true);
                    addShiftsToCalendar.trigger("change");
                }*/

                //if the user select "CalendarLTR"
                $("#settings #calendarLTRDiv .optionsSelector > div[data-value=" + result.CalendarLTR + "]").trigger("tap");
            }
        });
    }
});