﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#shiftDetails', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    //Define Scroller
                    var wrapperId = "shiftDetailsScroll";
                    $(this).children(".scroll").wrap('<div id="scroller">'); //Adds the wrapper div
                    $(this).children('#scroller').wrap('<div id="' + wrapperId + '" style="position: absolute;z-index: 1;top:75px;bottom: 0px;left: 0px;right: 0px;">'); // Adds the scroller div *inside* the wrapper div

                    setTimeout(function () {
                        $("#shiftDetails").data("scroller", new iScroll(wrapperId));
                    }, 0);
                }

                $(this).data("loaded", true);
            }
        }
    });

    //when this page loads
    $('#jqt').on('pageAnimationEnd', '#shiftDetails', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loadedAnimationEnd")) {
                //init the ShiftColorsSelector
                InitColorsSelector($("#shiftDetails ol.ShiftColorsSelector"));

                $(this).data("loadedAnimationEnd", true);
            }

            //get the shiftId to show details of
            var editShiftId = sessionStorage.getItem("EditShiftId");
            if (editShiftId != null) {

                //update the Shift details (if neccesary)
                var shouldUpdateShiftDetails = sessionStorage.getItem("ShouldUpdateShiftDetails");
                if (shouldUpdateShiftDetails != null) {
                    sessionStorage.removeItem("ShouldUpdateShiftDetails");

                    LoadFormData(editShiftId);
                }

                //show a small popup with message (if neccesary)
                var smallPopup = sessionStorage.getItem("ShowSmallPopup");
                if (smallPopup != null) {
                    sessionStorage.removeItem("ShowSmallPopup");

                    var popupDetails = JSON.parse(smallPopup);
                    showSmallPopup(popupDetails.Value, popupDetails.Key);
                }

                //show the nextShift and prevShift buttons (arrows)
                var shiftIndex = GetShiftIndex(editShiftId);
                ShowHideNextPrevButtons(shiftIndex);
            }
        }
    });

    //when click on Delete Shift - show Confirm Dialog
    $("#jqt").on("tap", "#shiftDetails #btnDeleteShift:not(.disabled)", function () {
        showDialog("<div class='title'>Delete Shift<span class='close'>X</span></div><div class='content'>Do you want to delete this shift?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "DeleteShiftDialog");
    });
    $("#jqt").on("tap", "#shiftDetails #DeleteShiftDialog .confirm", function () {
        showLoading();

        var editShiftId = sessionStorage.getItem("EditShiftId");

        //Invoke AJAX to delete the shift
        $.post(pathPrefix + "Shifts/DeleteShift", { "ShiftID": editShiftId }, function () {
            sessionStorage.setItem("ShouldUpdateShifts", true);

            jqtouch.goBack();
            removeLoading();
        }, "json");
    });

    //when click on a color
    $("#jqt").on("tap", "#shiftDetails ol.ShiftColorsSelector li", function () {
        var data = {
            "ShiftID": sessionStorage.getItem("EditShiftId"),
            "Color": $(this).data("color")
        };

        //Invoke AJAX to edit the shift's color
        $.post(pathPrefix + "Shifts/EditShiftColor", data, function () {
            sessionStorage.setItem("ShouldUpdateShifts", true);
        }, "json");
    });

    //when click on a previous shift
    $("#jqt").on("tap", "#shiftDetails .MonthBar .left", function () {
        GoToShift(-1);
    });

    //when click on a next shift
    $("#jqt").on("tap", "#shiftDetails .MonthBar .right", function () {
        GoToShift(1);
    });

    //this function will move to the next or prev shift (by clicking on the arrows buttons)
    function GoToShift(offset) {
        var currentShiftId = parseInt(sessionStorage.getItem("EditShiftId"));

        //get the shift index of the shift to go to
        var currentShiftIndex = GetShiftIndex(currentShiftId);
        var goToShiftIndex = currentShiftIndex + offset;

        var shiftsIDsListJSON = sessionStorage.getItem("ShiftsIDsList");
        if (shiftsIDsListJSON != null) {
            var shiftsIDsList = JSON.parse(shiftsIDsListJSON);

            //load the next/prev shift
            var goToShiftID = shiftsIDsList[goToShiftIndex];
            if (goToShiftID != null) {
                sessionStorage.setItem("EditShiftId", goToShiftID);

                LoadFormData(goToShiftID);
            }

            ShowHideNextPrevButtons(goToShiftIndex);
        }
    }

    //find the index of the specified shift in the list
    function GetShiftIndex(shiftId) {
        var shiftsIDsListJSON = sessionStorage.getItem("ShiftsIDsList");
        if (shiftsIDsListJSON != null) {
            var shiftsIDsList = JSON.parse(shiftsIDsListJSON);

            //loop through the list of ShiftIDs
            for (var i = 0; i < shiftsIDsList.length; i++) {
                //find the specified shift by its id
                if (shiftsIDsList[i] == shiftId) {
                    return i;
                }
            }
        }
    }

    function ShowHideNextPrevButtons(goToShiftIndex) {
        var shiftsIDsListJSON = sessionStorage.getItem("ShiftsIDsList");
        if (shiftsIDsListJSON != null) {
            var shiftsIDsList = JSON.parse(shiftsIDsListJSON);

            //if this is the FIRST SHIFT
            if (goToShiftIndex == 0) {
                $("#shiftDetails .MonthBar .left").addClass("notVisible");
                $("#shiftDetails .MonthBar .right").removeClass("notVisible");
            }
            else {
                $("#shiftDetails .MonthBar .left").removeClass("notVisible");
            }
            //if this is the LAST SHIFT
            if (goToShiftIndex == shiftsIDsList.length - 1) {
                $("#shiftDetails .MonthBar .left").removeClass("notVisible");
                $("#shiftDetails .MonthBar .right").addClass("notVisible");
            }
            else {
                $("#shiftDetails .MonthBar .right").removeClass("notVisible");
            }
        }
    }

    function LoadFormData(id) {
        showLoading();

        //Invoke AJAX method to get the current data of this shift
        $.getJSON(pathPrefix + "Shifts/GetShift?id=" + id, function (result) {
            if (result != null && result != "") {
                //save this shift in the SessionStorage
                sessionStorage.setItem("EditShiftData", JSON.stringify(result));

                var currencyName = GetCurrencyName();

                $("#shiftDetails #ShiftDate").html(result.StartDate + " (" + result.StartDayName + ")");

                //set the times values
                $("#shiftDetails #TimesSection li:eq(0) .value").html(result.StartTime);
                $("#shiftDetails #TimesSection li:eq(2) .value").html(result.EndTime);
                $("#shiftDetails #TimesSection li:eq(3) .value").html(result.WorkingTime);

                //if there are no RateRanges records for this shift (the shift has been calculated in the old system)
                if (result.RateRanges.length == 0) {
                    $("#shiftDetails #RateRangesSection .section > ol").hide();
                    var noShiftRates = $("#shiftDetails #RateRangesSection .section #noShiftRates");
                    noShiftRates.show();

                    //show the ShiftRate of this shift (using the old system)
                    if (result.CustomShiftRate) {
                        noShiftRates.html((result.ShiftRate * 100) + "%");
                    }
                    else {
                        noShiftRates.html("Auto Calculated (" + (result.ShiftRate * 100) + "%)");
                    }
                }
                //if there are RateRanges records
                else {
                    $("#shiftDetails #RateRangesSection .section > ol").show();
                    $("#shiftDetails #RateRangesSection .section #noShiftRates").hide();

                    //bind to the list
                    $("#shiftDetails #RateRangesSection .section > ol li:not(:first)").remove();

                    var shiftRateRowTemplate = Handlebars.templates["shiftRateRowTemplate"];

                    var listHtml = "";

                    //loop through the items and bind them to the list
                    for (var i = 0; i < result.RateRanges.length; i++) {
                        listHtml += $.trim(shiftRateRowTemplate(result.RateRanges[i]));
                    }
                    $("#shiftDetails #RateRangesSection .section > ol").append(listHtml);
                }

                //set the money value
                $("#shiftDetails #MoneySection .section > div").html(AppendCurrencyName(result.Money, currencyName));

                //set the shift bonuses (בונוסים ותוספות)
                if (result.Bonuses.length == 0) {
                    $("#shiftDetails #BonusesSection .section > ol").hide();
                    $("#shiftDetails #BonusesSection .section #noShiftBonuses").show();
                }
                else {
                    $("#shiftDetails #BonusesSection .section > ol").show();
                    $("#shiftDetails #BonusesSection .section #noShiftBonuses").hide();

                    //bind to the list
                    $("#shiftDetails #BonusesSection .section > ol li:not(:first)").remove();

                    var shiftBonusRowTemplate = Handlebars.templates["shiftBonusRowTemplate"];

                    var listHtml = "";

                    //loop through the items and bind them to the list
                    for (var i = 0; i < result.Bonuses.length; i++) {
                        result.Bonuses[i].Currency = currencyName;

                        listHtml += $.trim(shiftBonusRowTemplate(result.Bonuses[i]));
                    }
                    $("#shiftDetails #BonusesSection .section > ol").append(listHtml);
                }

                //set the breakTimeDeduction value
                if (result.BreakTimeLength != "") {
                    $("#shiftDetails #DeductionsSection .section > div").html(result.BreakTimeLength + " Minutes");
                }

                //set the comments value
                if (result.Comments != null && result.Comments != "") {
                    $("#shiftDetails #CommentsSection .section > div").html(result.Comments);
                }
                else {
                    $("#shiftDetails #CommentsSection .section > div").html("None");
                }

                //if there is no EndDate (משמרת עוד לא הסתיימה)
                if (result.EndDate == "-") {
                    $("#shiftDetails #RateRangesSection").hide();
                    $("#shiftDetails #MoneySection").hide();
                    $("#shiftDetails #DeductionsSection").hide();
                    $("#shiftDetails #btnDefineAsPresetShift").hide();
                }
                else {
                    $("#shiftDetails #RateRangesSection").show();
                    $("#shiftDetails #MoneySection").show();
                    $("#shiftDetails #btnDefineAsPresetShift").show();

                    //if the user has BreakTimeLength (זמן הפסקה מקוזז משכר)
                    if (result.BreakTimeLength != "") {
                        $("#shiftDetails #DeductionsSection").show();
                    }
                    else {
                        $("#shiftDetails #DeductionsSection").hide();
                    }
                }

                //check if this month salary is already recorded in DB (and the user can't edit shifts anymore)
                var IsMonthSalaryInDB = sessionStorage.getItem("IsMonthSalaryInDB");
                if (IsMonthSalaryInDB == "true") {
                    //hide all edit buttons and delete button
                    $("#shiftDetails #Content > div:not(#CommentsSection) .whiteButton").hide();
                    $("#shiftDetails #btnDeleteShift").addClass("disabled");
                }
                else {
                    //show all edit buttons and delete button
                    $("#shiftDetails #Content > div:not(#CommentsSection) .whiteButton").show();
                    $("#shiftDetails #btnDeleteShift").removeClass("disabled");
                }

                //highlight the shift's selected color
                $("#shiftDetails ol.ShiftColorsSelector li.selected").removeClass("selected");
                $("#shiftDetails ol.ShiftColorsSelector li[data-color='" + result.Color + "']").addClass("selected");

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    window.setTimeout(function () {
                        //set scroller
                        var scroller = $('#shiftDetails').data("scroller");
                        scroller.refresh();
                    }, 0);
                }

                removeLoading();
            }
        });
    }

    function AppendCurrencyName(val, currencyName) {
        if (currencyName) {
            if (val != "-") {
                return currencyName + val;
            }
        }
        return val;
    }
});