﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#userBonusesManager', function (event, info) {
        if (info.direction == 'in') {

            LoadFormData();
        }
    });

    //when user click Edit on specific bonus
    $("#jqt").on("tap", "#userBonusesManager ul#BonusesList li > a.EditButton", function () {
        var row = $(this).parents("li[data-bonus-id]");
        var bonusId = row.data("bonus-id");

        sessionStorage.setItem("EditUserBonusId", bonusId);

        jqtouch.goTo("AddUserBonus.html", "slideup");
    });

    //when clicking on delete bonuses
    $("#jqt").on("tap", "#userBonusesManager #btnDeleteBonuses", function () {
        if ($(this).hasClass("clicked")) {
            $(this).html("Delete");
            $(this).removeClass("clicked");

            //change all the "clicked" buttons back to regular mode
            $("#userBonusesManager ul#BonusesList li .Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            //hide the delete button
            $("#userBonusesManager ul#BonusesList li .Edit a").hide();
            $("#userBonusesManager ul#BonusesList li").removeClass("deleteActive");
        }
        else {
            $(this).html("Cancel");
            $(this).addClass("clicked");

            //show the delete button
            $("#userBonusesManager ul#BonusesList li .Edit a").show();
            $("#userBonusesManager ul#BonusesList li").addClass("deleteActive");
        }
    });

    //when user click Delete on specific user bonus
    $("#jqt").on("tap", "#userBonusesManager ul#BonusesList li > div.Edit a", function () {

        //if the delete button is active
        if ($(this).hasClass("clicked")) {
            var row = $(this).parents("li[data-bonus-id]");
            var bonusId = row.data("bonus-id");

            showLoading();

            //Invoke AJAX to delete the bonus
            $.post(pathPrefix + "UserBonuses/DeleteUserBonus", { "UserBonusID": bonusId }, function (result) {
                row.remove();
                removeLoading();

                GetUserSettings();
            });

            $(this).removeClass("clicked");
        }
        else {
            //change all the "clicked" buttons back to regular mode
            $("#userBonusesManager ul#BonusesList li > div.Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            $(this).find("span").html("Del");
            $(this).addClass("clicked").addClass("small");
        }
    });

    function LoadFormData() {
        $("#userBonusesManager ul#BonusesList").empty();

        //get list of bonuses
        $.getJSON(pathPrefix + "UserBonuses/GetUserBonuses", function (result) {
            //there are no bonuses - show message
            if (result.length == 0) {
                $("#userBonusesManager #noBonuses").show();
                $("#userBonusesManager #BonusesListContainer").hide();
            }
            else {
                var currency = GetCurrencyName();

                var bonusRowTemplate = Handlebars.templates["bonusRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.length; i++) {
                    result[i].DefaultValueText = result[i].DefaultValueText.replace('{{Currency}}', currency);

                    listHtml += $.trim(bonusRowTemplate(result[i]));
                }
                $("#userBonusesManager ul#BonusesList").append(listHtml);

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    window.setTimeout(function () {
                        if (myScroll) {
                            myScroll.refresh();
                        }
                    }, 0);
                }

                $("#userBonusesManager #noBonuses").hide();
                $("#userBonusesManager #BonusesListContainer").show();
            }
        });
    }
});