﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#userDeductionsManager', function (event, info) {
        if (info.direction == 'in') {

            LoadFormData();
        }
    });

    //when user click Edit on specific deduction
    $("#jqt").on("tap", "#userDeductionsManager ul#DeductionsList li > a.EditButton", function () {
        var row = $(this).parents("li[data-deduction-id]");
        var deductionId = row.data("deduction-id");

        sessionStorage.setItem("EditUserDeductionId", deductionId);

        jqtouch.goTo("AddUserDeduction.html", "slideup");
    });

    //when clicking on delete deductions
    $("#jqt").on("tap", "#userDeductionsManager #btnDeleteDeductions", function () {
        if ($(this).hasClass("clicked")) {
            $(this).html("Delete");
            $(this).removeClass("clicked");

            //change all the "clicked" buttons back to regular mode
            $("#userDeductionsManager ul#DeductionsList li .Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            //hide the delete button
            $("#userDeductionsManager ul#DeductionsList li .Edit a").hide();
            $("#userDeductionsManager ul#DeductionsList li").removeClass("deleteActive");
        }
        else {
            $(this).html("Cancel");
            $(this).addClass("clicked");

            //show the delete button
            $("#userDeductionsManager ul#DeductionsList li .Edit a").show();
            $("#userDeductionsManager ul#DeductionsList li").addClass("deleteActive");
        }
    });

    //when user click Delete on specific user deduction
    $("#jqt").on("tap", "#userDeductionsManager ul#DeductionsList li > div.Edit a", function () {

        //if the delete button is active
        if ($(this).hasClass("clicked")) {
            var row = $(this).parents("li[data-deduction-id]");
            var deductionId = row.data("deduction-id");

            showLoading();

            //Invoke AJAX to delete the deduction
            $.post(pathPrefix + "UserDeductions/DeleteUserDeduction", { "DeductionID": deductionId }, function (result) {
                row.remove();
                removeLoading();
            });

            $(this).removeClass("clicked");
        }
        else {
            //change all the "clicked" buttons back to regular mode
            $("#userDeductionsManager ul#DeductionsList li > div.Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            $(this).find("span").html("Del");
            $(this).addClass("clicked").addClass("small");
        }
    });

    function LoadFormData() {
        $("#userDeductionsManager ul#DeductionsList").empty();

        //get list of deductions
        $.getJSON(pathPrefix + "UserDeductions/GetUserDeductions", function (result) {
            //there are no deductions - show message
            if (result.length == 0) {
                $("#userDeductionsManager #noDeductions").show();
                $("#userDeductionsManager #DeductionsListContainer").hide();
            }
            else {
                var currency = GetCurrencyName();

                var deductionRowTemplate = Handlebars.templates["deductionRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.length; i++) {
                    result[i].DeductionText = result[i].DeductionText.replace('{{Currency}}', currency);

                    listHtml += $.trim(deductionRowTemplate(result[i]));
                }
                $("#userDeductionsManager ul#DeductionsList").append(listHtml);

                // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
                if (!Modernizr.overflowscrolling) {
                    window.setTimeout(function () {
                        if (myScroll) {
                            myScroll.refresh();
                        }
                    }, 0);
                }

                $("#userDeductionsManager #noDeductions").hide();
                $("#userDeductionsManager #DeductionsListContainer").show();
            }
        });
    }
});