﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#userPayPeriod', function (event, info) {
        if (info.direction == 'in') {

            $("#userPayPeriod form")[0].reset();
            LoadFormData();
        }
    });

    $("#jqt").on("change", "#userPayPeriod #WeekPayDay", function () {
        var selectedVal = $(this).find("option:selected").html();

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedVal);
    });

    //when the user change the PayFrequency
    $("#jqt").on("change", "#userPayPeriod #PayFrequency", function () {
        var selectedVal = $(this).find("option:selected").html();

        //because the Select element is hidden (due to bug in IOS4) - show the selected type in a sibling span
        $(this).siblings("span").html(selectedVal);

        //hide all fields
        $("#userPayPeriod #WeekPayDayDiv").hide();
        $("#userPayPeriod #ExamplePayDateDiv").hide();
        $("#userPayPeriod #MonthPayDayDiv").hide();
        $("#userPayPeriod #MonthPayDay2Div").hide();
        $("#userPayPeriod #WeekPayDay").prop("disabled", true);
        $("#userPayPeriod #MonthPayDay").prop("disabled", true);
        $("#userPayPeriod #MonthPayDay2").prop("disabled", true);
        $("#userPayPeriod #ExamplePayDate").prop("disabled", true);

        //set the relevant changes according to the user frequency selection
        if (selectedVal == "Weekly") {
            $("#userPayPeriod #paychecksCountLabel").html("A weekly pay period results in 52 paychecks in a year");

            //show and enable the relevant field
            $("#userPayPeriod #WeekPayDayDiv").show();
            $("#userPayPeriod #WeekPayDay").prop("disabled", false);
        }
        else if (selectedVal == "Bi-Weekly") {
            $("#userPayPeriod #paychecksCountLabel").html("A bi-weekly (every other week) pay period results in 26 paychecks in a year");

            //show and enable the relevant field
            $("#userPayPeriod #ExamplePayDateDiv").show();
            $("#userPayPeriod #ExamplePayDate").prop("disabled", false);
        }
        else if (selectedVal == "Semi-Monthly") {
            $("#userPayPeriod #paychecksCountLabel").html("A semi-monthly (twice a month) pay period results in 24 paychecks in a year");

            //show and enable the relevant field
            $("#userPayPeriod #MonthPayDayDiv").show();
            $("#userPayPeriod #MonthPayDay2Div").show();
            $("#userPayPeriod #MonthPayDay").prop("disabled", false);
            $("#userPayPeriod #MonthPayDay2").prop("disabled", false);
        }
        else if (selectedVal == "Monthly") {
            $("#userPayPeriod #paychecksCountLabel").html("A monthly pay period results in 12 paychecks in a year");

            //show and enable the relevant field
            $("#userPayPeriod #MonthPayDayDiv").show();
            $("#userPayPeriod #MonthPayDay").prop("disabled", false);
        }
    });

    //when changing the Date value
    $("#jqt").on("blur", "#userPayPeriod #ExamplePayDate", ShowDayName);
    $("#jqt").on("blur", "#userPayPeriod #ExamplePayDate", FieldChange_UpdatePeriodsExamples);

    //when changing any form value
    $("#jqt").on("change", "#userPayPeriod :input", FieldChange_UpdatePeriodsExamples);

    $("#jqt").on("touchend", "#userPayPeriod #MonthPayDayDiv .numUp,#userPayPeriod #MonthPayDayDiv .numDown, #userPayPeriod #MonthPayDay2Div .numUp,#userPayPeriod #MonthPayDay2Div .numDown", FieldChange_UpdatePeriodsExamples);

    function ValidateForm(data) {
        //check if there are validation errors
        var errors = [];

        if (data.PayFrequency == "") {
            errors.push("Please select Pay Frequency");
        }
        else {
            if (data.PayFrequency == "Weekly") {
                if (data.WeekPayDay == "") {
                    errors.push("Please select Weekly Payday");
                }
            }
            else if (data.PayFrequency == "Bi-Weekly") {
                if (data.ExamplePayDate == "") {
                    errors.push("Please select Period Start Example");
                }

                var curDate = new Date();
                var exampleDate = new Date(data.ExamplePayDate);

                if (exampleDate.getTime() >= curDate.getTime()) {
                    errors.push("Please select a past date in the Period Start Example");
                }
            }
            else if (data.PayFrequency == "Semi-Monthly") {
                if (data.MonthPayDay == "" || data.MonthPayDay2 == "") {
                    errors.push("Please select Monthly Payday");
                }
                else {
                    var monthPayday = parseInt(data.MonthPayDay);
                    var monthPayday2 = parseInt(data.MonthPayDay2);
                    if (monthPayday >= monthPayday2) {
                        errors.push("Your selected Monthly Paydays are invalid");
                    }
                }
            }
            else if (data.PayFrequency == "Monthly") {
                if (data.MonthPayDay == "") {
                    errors.push("Please select Monthly Payday");
                }
            }
        }

        return errors;
    }

    function FieldChange_UpdatePeriodsExamples() {
        var data = $("#userPayPeriod form").serializeObject();

        var errors = ValidateForm(data);

        if (errors.length == 0) {
            var dataStr = $("#userPayPeriod form").serialize();

            $("#userPayPeriod #Examples li:not(:first)").remove();

            //Invoke AJAX method to get examples for pay periods
            $.getJSON(pathPrefix + "UserPayPeriods/GetPeriodsExamples?" + dataStr, function (result) {
                var payPeriodRowTemplate = Handlebars.templates["payPeriodRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.length; i++) {
                    result[i].Number = i + 1;
                    listHtml += $.trim(payPeriodRowTemplate(result[i]));
                }
                $("#userPayPeriod #Examples").append(listHtml);
            });

            $("#userPayPeriod #PeriodsExampleContainer").show();
        }
        else {
            $("#userPayPeriod #PeriodsExampleContainer").hide();
        }
    }

    var data;

    //UPDATE PAY PERIOD
    $("#jqt").on("tap", "#userPayPeriod #btnUpdatePeriod", function () {
        data = $("#userPayPeriod form").serializeObject();

        var errors = ValidateForm(data);

        if (errors.length == 0) {
            if (editMode) {
                showDialog("<div class='title'>Pay Period Change<span class='close'>X</span></div><div class='content'>Are you sure you want to change your pay periods settings?<br />Be careful - this will also effect all data related to specific periods.</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "UpdatePayPeriodFormDialog");
            }
            else {
                InvokeUpdatePayPeriod();
            }
        }
        else {
            showPopup(errors.join("<br />"), false);
        }
    });

    //buttons for dialog (confirm the pay periods update)
    $("#jqt").on("tap", "#userPayPeriod #UpdatePayPeriodFormDialog .confirm", function () {
        InvokeUpdatePayPeriod();
    });

    function InvokeUpdatePayPeriod() {
        showLoading();

        //Invoke AJAX method to update the pay period data
        $.post(pathPrefix + "UserPayPeriods/UpdatePayFrequencyData", data, function (payPeriods) {
            //save the pay periods of this user
            localStorage.setItem("PayPeriods", JSON.stringify(payPeriods));
            SetInitialUserPayPeriod();

            if (editMode) {
                sessionStorage.setItem("ShouldUpdateShifts", true);
                jqtouch.goBack();
            }
            else {
                jqtouch.goTo("MonthlyShifts.html", 'slideleft');
            }

            removeLoading();
        }, "json");
    }

    var editMode = null;

    function LoadFormData() {
        //Invoke AJAX method to get the current pay period data of this user (to allow him EDIT)
        $.getJSON(pathPrefix + "UserPayPeriods/GetUserPayFrequencyData", function (result) {

            if (result != null && result != "") {
                if (result.WeekPayDay != null) {
                    var weekPayDay = $("#userPayPeriod #WeekPayDay");
                    weekPayDay.val(result.WeekPayDay);
                    weekPayDay.trigger("change");
                }
                if (result.ExamplePayDate != null) {
                    var date = result.ExamplePayDate;

                    $("#userPayPeriod #ExamplePayDate").val(date).trigger("change");
                }
                if (result.MonthPayDay != null) {
                    $("#userPayPeriod #MonthPayDay").val(result.MonthPayDay);
                }
                if (result.MonthPayDay2 != null) {
                    $("#userPayPeriod #MonthPayDay2").val(result.MonthPayDay2);
                }

                var payFrequency = $("#userPayPeriod #PayFrequency");
                payFrequency.val(result.PayFrequency);
                payFrequency.trigger("change");

                //EDIT MODE - show back button
                $("#userPayPeriod .goback").show();
                editMode = true;
            }
            //INSERT MODE
            else {
                editMode = false;
            }

            //add "mobiscroll" plugin to show date picker
            var dateFields = $("#userPayPeriod #ExamplePayDate");
            dateFields.mobiscroll().date(mobiscrollDateOptions);
        });
    }
});