﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#userProfilesManager', function (event, info) {
        if (info.direction == 'in') {

            LoadFormData();
        }
    });

    //when user click Edit on specific user profile
    $("#jqt").on("tap", "#userProfilesManager ul#ProfilesList li > a.EditButton", function () {
        var row = $(this).parents("li[data-user-id]");
        var userId = row.data("user-id");
        var profileName = row.data("profile-name");

        sessionStorage.setItem("EditUserProfileId", userId);
        sessionStorage.setItem("EditUserProfileName", profileName);

        jqtouch.goTo("AddUserProfile.html", "slideup");
    });

    //when clicking on delete UserProfiles
    $("#jqt").on("tap", "#userProfilesManager #btnDeleteUserProfiles", function () {
        if ($(this).hasClass("clicked")) {
            $(this).html("Delete");
            $(this).removeClass("clicked");

            //change all the "clicked" buttons back to regular mode
            $("#userProfilesManager ul#ProfilesList li .Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            //hide the delete button
            $("#userProfilesManager ul#ProfilesList li .Edit a").hide();
            $("#userProfilesManager ul#ProfilesList li").removeClass("deleteActive");
        }
        else {
            $(this).html("Cancel");
            $(this).addClass("clicked");

            //show the delete button
            $("#userProfilesManager ul#ProfilesList li .Edit a").show();
            $("#userProfilesManager ul#ProfilesList li").addClass("deleteActive");
        }
    });

    var deleteUserId;
    var deleteRow;

    //when user click Delete on specific user profile
    $("#jqt").on("tap", "#userProfilesManager ul#ProfilesList li > div.Edit a:not(.disabled)", function () {
        deleteRow = $(this).parents("li[data-user-id]");
        deleteUserId = deleteRow.data("user-id");

        showDialog("<div class='title'>Delete Profile<span class='close'>X</span></div><div class='content'>All the data and shifts of this profile will be deleted. Are you sure?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "DeleteProfileDialog");
    });
    $("#jqt").on("tap", "#userProfilesManager #DeleteProfileDialog .confirm", function () {
        showLoading();

        //Invoke AJAX to delete the profile
        $.post(pathPrefix + "UserProfiles/DeleteUserProfile", { "UserID": deleteUserId }, function (result) {
            deleteRow.remove();
            removeLoading();
        });
    });

    function LoadFormData() {
        $("#userProfilesManager ul#ProfilesList").empty();

        //get list of profiles
        $.getJSON(pathPrefix + "UserProfiles/GetUserProfiles", function (result) {
            var profileRowTemplate = Handlebars.templates["profileRowTemplate"];

            var listHtml = "";

            //bind the list
            for (var i = 0; i < result.length; i++) {
                if (result[i].IsDeletable == false || result[i].IsLogin) {
                    result[i].Disabled = "disabled";
                }

                listHtml += $.trim(profileRowTemplate(result[i]));
            }
            $("#userProfilesManager ul#ProfilesList").append(listHtml);

            // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
            if (!Modernizr.overflowscrolling) {
                window.setTimeout(function () {
                    if (myScroll) {
                        myScroll.refresh();
                    }
                }, 0);
            }
        });
    }
});