﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#userProfilesSelect', function (event, info) {
        if (info.direction == 'in') {

            LoadFormData();
        }
    });

    var userUniqueGuid;
    var profileName;

    //SELECT USER PROFILE
    $("#jqt").on("tap", "#userProfilesSelect ul#ProfilesListSelect li:not(.true) a", function () {
        userUniqueGuid = $(this).data("user-guid");
        profileName = $(this).data("profile-name");

        showDialog("<div class='title'>Switch Profile<span class='close'>X</span></div><div class='content'>Do you want to switch to this profile?</div><div class='bottom'><a href='#' class='confirm'>Yes</a><a href='#' class='close'>No</a></div>", "ProfileSelectDialog");
    });
    $("#jqt").on("tap", "#userProfilesSelect #ProfileSelectDialog .confirm", function () {
        localStorage.setItem("UserUniqueGuid", userUniqueGuid);
        localStorage.setItem("ProfileName", profileName);

        var data = { "UniqueGuid": userUniqueGuid, "AppVersion": appVersion, "Device": localStorage.getItem("Device") };

        //Invoke AJAX method to login this user's profile
        $.post(pathPrefix + "Users/AutoLogin", data, function (result) {
            sessionStorage.setItem("ShouldUpdateShifts", true);

            GetUserSettings();

            AddUserPayPeriodsIfNeccesery(function () {
                SetInitialUserPayPeriod();
                jqtouch.goBack();
            });
        }, "json");
    });

    function LoadFormData() {
        $("#userProfilesSelect ul#ProfilesListSelect").empty();

        //get list of profiles
        $.getJSON(pathPrefix + "UserProfiles/GetUserProfiles", function (result) {

            var profileSelectRowTemplate = Handlebars.templates["profileSelectRowTemplate"];

            var listHtml = "";

            //bind the list
            for (var i = 0; i < result.length; i++) {
                listHtml += $.trim(profileSelectRowTemplate(result[i]));
            }
            $("#userProfilesSelect ul#ProfilesListSelect").append(listHtml);
        });
    }
});