﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#userRateTypesManager', function (event, info) {
        if (info.direction == 'in') {

            LoadFormData();
        }
    });

    //when user click Edit on specific user rate
    $("#jqt").on("tap", "#userRateTypesManager ul#RateTypesList li > a.EditButton", function () {
        var row = $(this).parents("li[data-rate-type-id]");
        var rateId = row.data("rate-type-id");

        sessionStorage.setItem("EditUserRateTypeId", rateId);

        jqtouch.goTo("AddUserRateType.html", "slideup");
    });

    //when clicking on delete rates
    $("#jqt").on("tap", "#userRateTypesManager #btnDeleteRateTypes", function () {
        if ($(this).hasClass("clicked")) {
            $(this).html("Delete");
            $(this).removeClass("clicked");

            //change all the "clicked" buttons back to regular mode
            $("#userRateTypesManager ul#RateTypesList li .Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            //hide the delete button
            $("#userRateTypesManager ul#RateTypesList li .Edit a").hide();
            $("#userRateTypesManager ul#RateTypesList li").removeClass("deleteActive");
        }
        else {
            $(this).html("Cancel");
            $(this).addClass("clicked");

            //show the delete button
            $("#userRateTypesManager ul#RateTypesList li .Edit a").show();
            $("#userRateTypesManager ul#RateTypesList li").addClass("deleteActive");
        }
    });

    //when user click Delete on specific rate
    $("#jqt").on("tap", "#userRateTypesManager ul#RateTypesList li > div.Edit a", function () {

        //if the delete button is active
        if ($(this).hasClass("clicked")) {
            var row = $(this).parents("li[data-rate-type-id]");
            var rateId = row.data("rate-type-id");

            showLoading();

            //Invoke AJAX to delete the rate
            $.post(pathPrefix + "UserRateTypes/DeleteUserRateType", { "RateTypeID": rateId }, function (result) {
                row.remove();

                removeLoading();
            });

            $(this).removeClass("clicked");
        }
        else {
            //change all the "clicked" buttons back to regular mode
            $("#userRateTypesManager ul#RateTypesList li > div.Edit a.clicked").removeClass("clicked").removeClass("small").find("span").html("-");

            $(this).find("span").html("Del");
            $(this).addClass("clicked").addClass("small");
        }
    });

    function LoadFormData() {
        $("#userRateTypesManager ul#RateTypesList").empty();

        //get list of rate types
        $.getJSON(pathPrefix + "UserRateTypes/GetUserRateTypes", function (result) {
            //there are no rates
            if (result.length == 0) {
                $("#userRateTypesManager #RateTypesListContainer").hide();
            }
            else {
                var rateTypeRowTemplate = Handlebars.templates["rateTypeRowTemplate"];

                var listHtml = "";

                //bind the list
                for (var i = 0; i < result.length; i++) {
                    listHtml += $.trim(rateTypeRowTemplate(result[i]));
                }
                $("#userRateTypesManager ul#RateTypesList").append(listHtml);

                $("#userRateTypesManager #RateTypesListContainer").show();
            }
        });
    }
});