﻿$(document).ready(function () {
    //when this page loads first time
    $('#jqt').on('pageAnimationStart', '#workingPlans', function (event, info) {
        if (info.direction == 'in') {

            if (!$(this).data("loaded")) {

                $(this).data("loaded", true);
            }

            //how many days to add to the current day
            $("#workingPlans #btnNextWeek").data("add-days", 7);

            //load the data
            var currentDate = GetCurrentDate();
            LoadFormData(currentDate);
        }
    });

    //add days from next week
    $("#jqt").on("tap", "#workingPlans #btnNextWeek", function () {
        var addDaysValue = $(this).data("add-days");
        var addDays = 7;

        if (addDaysValue != null) {
            addDays = parseInt(addDaysValue);
        }

        //how many days to add to the current day
        $(this).data("add-days", addDays + 7);

        //get current date
        var currentDate = new Date();
        currentDate.setDate(currentDate.getDate() + addDays);

        var curr_day = currentDate.getDate();
        var curr_month = currentDate.getMonth() + 1;
        var curr_year = currentDate.getFullYear();

        var nextWeekDay = (curr_day < 10 ? "0" + curr_day : curr_day) + "/" + (curr_month < 10 ? "0" + curr_month : curr_month) + "/" + curr_year;

        LoadFormData(nextWeekDay);
    });

    function LoadFormData(date) {
        $("#workingPlans #WeekDays").empty();

        showLoading();

        //Invoke AJAX method to get the week days of the specified date
        $.post(pathPrefix + "WorkingPlans/GetWeekDays", { "date": date }, function (result) {
            var workingPlansDayRowTemplate = Handlebars.templates["workingPlansDayRowTemplate"];

            var listHtml = "";

            //bind the list
            for (var i = 0; i < result.length; i++) {
                listHtml += $.trim(workingPlansDayRowTemplate(result[i]));
            }
            $("#workingPlans #WeekDays").append(listHtml);

            // Check if the browser don't supports the overflowScrolling (iOS5 native scrolling)
            if (!Modernizr.overflowscrolling) {
                window.setTimeout(function () {
                    if (myScroll) {
                        myScroll.refresh();
                    }
                }, 0);
            }

            //add "mobiscroll" plugin to show date picker
            var timeElements = $("#workingPlans #StartTime,#workingPlans #EndTime");
            timeElements.mobiscroll().time(mobiscrollDateOptions);

            //update the values of the native date selectors (iOS only)
            UpdateNativeDateSelectors();

            //when updating the StartTime or EndTime of a workingPlan
            timeElements.on("change", function () {
                var list = $(this).parents("ul");

                var data = {
                    "Day": list.data("date"),
                    "StartTime": list.find("#StartTime").val(),
                    "EndTime": list.find("#EndTime").val()
                };

                $.post(pathPrefix + "WorkingPlans/SetWorkingPlan", data, function () {
                }, "json");
            });

            removeLoading();
        }, "json");
    }
});