/**
 *
 *
 *
 * @title: myDay
 * @author:istvan.szalontai12@gmail.com
 * @TODO:
 *  - recreation, appointment category
 *  - should fix the cleanup() function
 *  - upload to ffmarket
 * @history:
 * 2014-03-12 : bug fix: add-->save, stopper flickering, go twitter
 * 2014-03-11 : publish
 * 2014-03-10 : countdown, hide pointer
 * 2014-03-09 : NONE
 * 2014-03-08 : NONE
 * 2014-03-07 : better clock animation 24 frame, twitter button
 * 2014-03-06 : saving from and loading to stream to localStorage, clock 0-width fixed
 * 2014-03-05 : add almost fixed, ffos icon, delete fixed, favicon
 * 2014-03-04 : edit fixed
 * 2014-02-20 : development has been started
 *
 
 Subm-4250
 M287C3V
 */
window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
// start animating
requestAnimationFrame(animate);
var w = window.innerWidth;
window.onresize = function(event) {
    w = window.innerWidth;
};

const MAXITEMS=15;
var i = 0,j;
var event = ['Company job','LightPink', 'Appointment','CornflowerBlue','Other job','PaleTurquoise' , 'Break','PaleGreen' , 'Family','Gold' , 'Commuting','Red', 'Friends','LightGray', 'Recreation','Bisque', 'Please select', 'SteelBlue'];
var raw = '5-07:00-0-09:00-3-12:00-0-13:00-5-17:00-0-18:50';
var sep = '-';
var row = [];
var d = new Date();
var currentRow, currentEvent, currentFromHour, currentFromMin, currentToHour, currentToMin;//Globals
init();//entry point


function init()
{
	if (localStorage.schedule)
  {
		raw = localStorage.schedule;
  }
	else
  {
		writeLocalStorage();
  }
	updateSchedule();
	drawSchedule();
}

function writeLocalStorage()
{
	localStorage.schedule = raw;
	console.log('localStorage written');
}

function animate()
{
	var d = new Date();
	requestAnimationFrame(animate);
	
	if(d.valueOf()>=row[0].timevalue && d.valueOf()<=row[row.length-1].timevalue)
	{
		i=0;
		while(d.valueOf()-row[i].timevalue >= 0 && i<row.length-1)
		{
			i++;
		}
		i--;
		
		var pp = ((d.valueOf()-row[i].timevalue)*(w-f('pointer').offsetWidth))/(row[i+1].timevalue-row[i].timevalue);
		var tt = ((d.valueOf()-row[i].timevalue)*(w-f('time').offsetWidth))/(row[i+1].timevalue-row[i].timevalue);
		var cd = row[i+1].timevalue - d.valueOf()+1000;
		//console.log(cd);
		
		
		f('pointer').style.left = pp+'px';
		f('time').style.left = tt+'px';
		f('pointer').style.top = row[i].top+'%';
		f('pointer').style.height = row[i].height+'%';
		f('time').style.top = row[i].top+'%';
		f('stopper').style.backgroundPosition = -Math.floor((d.valueOf()%1000)/1000*24)*24+'px 0px';
		f('timetext').innerHTML = '&nbsp;'+d.toTimeString().substr(0,8);
		f('stoppermini').style.backgroundPosition = -Math.floor((cd%1000)/1000*24)*16+'px 0px';
		f('countdown').innerHTML = '&nbsp;'+getTimeString(cd);
	}else{
		/*
		f('time').style.top = '0%';
		hide('time');
		*/
		f('time').style.top = '-100px';
		f('pointer').style.top = '-100px';
	}
}

function getTimeString(n)
{
	var allsec = Math.floor(n/1000);
	var msec = Math.floor(n/100)%10;
	var sec = allsec%60+'';
	var min = (Math.floor(allsec/60))%60+'';
	var hour = (Math.floor(allsec/3600))+'';
	//console.log(sec.length);
	if(sec.length == 1)sec = '0'+sec;
	if(min.length == 1)min = '0'+min;
	return hour+':'+min+':'+sec+'.'+msec;
}

function updateSchedule()
{
	var stream = raw.split(sep);
	for(i=0; i<stream.length/2; i++)
	{
		var k=stream[i*2+1].split(':');
		row.push(new rowentity(stream[i*2], k[0], k[1], new Date(d.getFullYear(), d.getMonth(), d.getDate(), k[0], k[1], 0, 0).valueOf(), 0, 0));
	}
}

function drawSchedule()
{
	//recalculate rows top and height
	var timetotal = row[row.length-1].timevalue - row[0].timevalue;
	var s=0;
	for(i=0; i<row.length-1; i++)
	{
		row[i].height = (row[i+1].timevalue - row[i].timevalue) / timetotal*100;
		row[i].top = s;
		s += row[i].height;
	}
	//draw
	var a = '';
	for(i=0; i<row.length-1; i++)
	{
		a += '<div style="background-color:'+event[row[i].event*2+1]+';height:'+row[i].height+'%"><div class="text">'+event[row[i].event*2]+' ['+row[i].hour+':'+row[i].min+' - '+row[i+1].hour+':'+row[i+1].min+']</div></div>';
	}
	a += '<div id="btn_settings" onmousedown="openOption()"></div>';
	a += '<div id="btn_close" onmousedown="window.close()"></div>';
	a += '<div id="btn_credits" onmousedown="openCredits()"></div>';
	f('display').innerHTML = a;
}

function drawEditor()
{
	var a = '<div id="title">&nbsp;Settings</div><div id="btn_back" onmousedown="backToSchedule()"></div>';

	a += '<table>';
	for(i=0; i<row.length-1; i++)
	{
		a += '<tr>';
		a += '<td style="width:5%;"><div style="background-color:'+event[row[i].event*2+1]+';">&nbsp;&nbsp;</div></td>';
		a += '<td style="width:25%;">'+event[row[i].event*2]+'</td>';
		a += '<td style="width:40%;">'+row[i].hour+':'+row[i].min+' &ndash; '+row[i+1].hour+':'+row[i+1].min+'</td>';
		a += '<td><div class="btn_edit" onmousedown="editItem('+i+')"></div></td>';
		a += '<td><div class="btn_delete" onmousedown="deleteItem('+i+')"></div></td>';
		a += '</tr>';
		a += '<tr><td style="background-color:#E0E0E0;" colspan="5"></td></tr>';
	}
	a += '<tr><td colspan="5"><div class="btn_add" style=""onmousedown="newItem()"></div></td></tr>';
	a += '</table>';
	
	f('display').innerHTML = a;
}

function editItem(n)
{
	currentRow = n;
	currentEvent = row[n].event;
	currentFromHour = row[n].hour
	currentFromMin = row[n].min;
	currentToHour = row[n+1].hour;
	currentToMin = row[n+1].min;
	drawEditItem();
}

function drawEditItem()
{
	var a = '<div id="title">&nbsp;Edit event</div><div id="btn_back" onmousedown="drawEditor()"></div>';
	a += '<table>';
	a += '<tr>';
	a += '<td>Event:</td>';
	a += '<td colspan="3"><div class="btn" style="background-color:'+event[currentEvent*2+1]+';color:black;" onmousedown="selectEvent(0)">'+event[currentEvent*2]+'</div></td>';
	a += '</tr>';
	
	a += '<tr>';
	a += '<td>From:</td>';
	a += '<td><div class="btn" onmousedown="selectHour(2)">'+currentFromHour+'</div></td>';
	a += '<td>:</td>';
	a += '<td><div class="btn" onmousedown="selectMin(2)">'+currentFromMin+'</div></td>';
	a += '</tr>';
	
	a += '<tr>';
	a += '<td>To:</td>';
	a += '<td><div class="btn" onmousedown="selectHour(3)">'+currentToHour+'</div></td>';
	a += '<td>:</td>';
	a += '<td><div class="btn" onmousedown="selectMin(3)">'+currentToMin+'</div></td>';
	a += '</tr>';
	
	a += '<tr><td colspan="4"><div class="btn" onmousedown="modifyItem()">Modify</div></td>';
	a += '</tr>';
	a += '</table>';
	f('display').innerHTML = a;
}

function newItem()
{
	currentEvent = (event.length-2)/2;
	currentFromHour = row[row.length-1].hour;
	currentFromMin = row[row.length-1].min;
	currentToHour = row[row.length-1].hour;
	currentToMin = row[row.length-1].min;
	drawAddItem();
}

function drawAddItem()
{
	var a = '<div id="title">&nbsp;New event</div><div id="btn_back" onmousedown="drawEditor()"></div>';
	a += '<table>';
	a += '<tr>';
	a += '<td>Event:</td>';
	if(currentEvent*2 == event.length-2)
	{
		a += '<td colspan="3"><div class="btn" style="background-color:'+event[currentEvent*2+1]+';color:white;" onmousedown="selectEvent(1)">'+event[currentEvent*2]+'</div></td>';
	}else{
		a += '<td colspan="3"><div class="btn" style="background-color:'+event[currentEvent*2+1]+';color:black;" onmousedown="selectEvent(1)">'+event[currentEvent*2]+'</div></td>';
	}
	a += '</tr>';
	
	a += '<tr>';
	a += '<td>From:</td>';
	a += '<td><div class="btn" onmousedown="selectHour(0)">'+currentFromHour+'</div></td>';
	a += '<td>:</td>';
	a += '<td><div class="btn" onmousedown="selectMin(0)">'+currentFromMin+'</div></td>';
	a += '</tr>';
	
	a += '<tr>';
	a += '<td>To:</td>';
	a += '<td><div class="btn" onmousedown="selectHour(1)">'+currentToHour+'</div></td>';
	a += '<td>:</td>';
	a += '<td><div class="btn" onmousedown="selectMin(1)">'+currentToMin+'</div></td>';
	a += '</tr>';
	
	a += '<tr><td colspan="4"><div class="btn" onmousedown="addItem()">Add</div></td></tr>';
	a += '</table>';
	f('display').innerHTML = a;
}

function addItem()
{
	if(isValid())
	{
		row.push(new rowentity(currentEvent, currentFromHour, currentFromMin, getTodayValue(currentFromHour, currentFromMin), 0, 0));
		/*
		hatulrol berakja elsonek
		*/
		insertFromToFirst(row.length-1);
		
		/*
		cleanup functionba alul
		*/
		
		/*
		beviszi a masik ele
		*/
		var n = bubbleFirst();
		row[n+1].hour = currentToHour;
		row[n+1].min = currentToMin;
		row[n+1].timevalue = getTodayValue(currentToHour, currentToMin);
		
		/*
		kitorli aki problemas
		*/
		var wasDel;
		do
		{
			wasDel = 0;
			for(i=1;i<row.length;i++)
			{
				if(row[i].timevalue < row[i-1].timevalue)
				{
					deleteRow(i);
					wasDel = 1;
					console.log('deleted row');
				}
			}
			console.log('wasDel = '+wasDel);
		}while(wasDel == 1);		
		
		createStream();
		writeLocalStorage();
	}
	drawEditor();
}

function modifyItem()
{
	if(isValid())
	{
		row[currentRow].event = currentEvent;
		row[currentRow].hour = currentFromHour;
		row[currentRow].min = currentFromMin;
		row[currentRow].timevalue = getTodayValue(currentFromHour, currentFromMin);
		row[currentRow+1].hour = currentToHour;
		row[currentRow+1].min = currentToMin;
		row[currentRow+1].timevalue = getTodayValue(currentToHour, currentToMin);
		
		createStream();
		writeLocalStorage();
	}
	drawEditor();
}

function selectEvent(n)//n=caller 0=edit  1=add
{
	if(n==0) a = '<div id="title">&nbsp;Select event</div><div id="btn_back" onmousedown="drawEditItem()"></div>';
	if(n==1) a = '<div id="title">&nbsp;Select event</div><div id="btn_back" onmousedown="drawAddItem()"></div>';
	a += '<table>';
	for(i=0; i<event.length-2; i+=2)
	{
		if(n==0) a += '<tr><td><div class="btn" style="background-color:'+event[i+1]+';color:black;" onmousedown="backFromEventToEdit('+(i/2)+')">'+event[i]+'</div></td></tr>';
		if(n==1) a += '<tr><td><div class="btn" style="background-color:'+event[i+1]+';color:black;" onmousedown="backFromEventToAdd('+(i/2)+')">'+event[i]+'</div></td></tr>';
	}
	a += '</table>';
	f('display').innerHTML = a;
}

function backFromEventToEdit(n)
{
	currentEvent = n;
	drawEditItem();
}

function backFromEventToAdd(n)
{
	currentEvent = n;
	drawAddItem();
}

function selectHour(n)//n=caller 0=add from  1=add to 2=edit from 3=edit to
{
	var i,j,k,a;
	var hour = ['04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23'];
	
	if(n==0 || n==1) a = '<div id="title">&nbsp;Select hour</div><div id="btn_back" onmousedown="drawAddItem()"></div>';
	if(n==2 || n==3) a = '<div id="title">&nbsp;Select hour</div><div id="btn_back" onmousedown="drawEditItem()"></div>';
	
	a += '<table>';
	for(i=0;i<hour.length;i++)
	{
		if(i%4 == 0) a += '<tr>';
		if(n==0)a += '<td><div class="btn" onmousedown="backFromFromhourToAdd(\''+hour[i]+'\')">'+hour[i]+'</div></td>';
		if(n==1)a += '<td><div class="btn" onmousedown="backFromTohourToAdd(\''+hour[i]+'\')">'+hour[i]+'</div></td>';
		if(n==2)a += '<td><div class="btn" onmousedown="backFromFromhourToEdit(\''+hour[i]+'\')">'+hour[i]+'</div></td>';
		if(n==3)a += '<td><div class="btn" onmousedown="backFromTohourToEdit(\''+hour[i]+'\')">'+hour[i]+'</div></td>';
		if((i+1)%4 == 0) a += '</tr>';
	}
	a += '</table>';
	f('display').innerHTML = a;
}

function backFromFromhourToAdd(n)
{
	currentFromHour = n;
	drawAddItem();
}

function backFromTohourToAdd(n)
{
	currentToHour = n;
	drawAddItem();
}

function backFromFromhourToEdit(n)
{
	currentFromHour = n;
	drawEditItem();
}

function backFromTohourToEdit(n)
{
	currentToHour = n;
	drawEditItem();
}

function selectMin(n)//n=caller 0=add from  1=add to 2=edit from 3=edit to
{
	var min = ['00','10','15','20','30','40','45','50'];
	var a;
	if(n==0 || n==1) a = '<div id="title">&nbsp;Select minute</div><div id="btn_back" onmousedown="drawAddItem()"></div>';
	if(n==2 || n==3) a = '<div id="title">&nbsp;Select minute</div><div id="btn_back" onmousedown="drawEditItem()"></div>';
	
	a += '<table>';
	for(i=0;i<min.length;i++) 
	{
		if(i%4 == 0) a += '<tr>';
		if(n==0)a += '<td><div class="btn" onmousedown="backFromFromminToAdd(\''+min[i]+'\')">'+min[i]+'</div></td>';
		if(n==1)a += '<td><div class="btn" onmousedown="backFromTominToAdd(\''+min[i]+'\')">'+min[i]+'</div></td>';
		if(n==2)a += '<td><div class="btn" onmousedown="backFromFromminToEdit(\''+min[i]+'\')">'+min[i]+'</div></td>';
		if(n==3)a += '<td><div class="btn" onmousedown="backFromTominToEdit(\''+min[i]+'\')">'+min[i]+'</div></td>';
		if((i+1)%4 == 0) a += '</tr>';
	}
	a += '</table>';
	f('display').innerHTML = a;
}

function backFromFromminToAdd(n)
{
	currentFromMin = n;
	drawAddItem();
}

function backFromTominToAdd(n)
{
	currentToMin = n;
	drawAddItem();
}

function backFromFromminToEdit(n)
{
	currentFromMin = n;
	drawEditItem();
}

function backFromTominToEdit(n)
{
	currentToMin = n;
	drawEditItem();
}

function openCredits()
{
	hide('pointer');
	hide('time');
	var a = '<div id="title">&nbsp;Credits</div><div id="btn_back" onmousedown="backToSchedule()"></div>';
	a += '<table>';
	a += '<tr><td align="center"><img src="gfx/icon-30.png"><strong>&nbsp;myDay</strong></td></tr>';
	a += '<tr><td align="center">Manage your time! Manage your day!</td></tr>';
	a += '<tr><td align="center">-------------------------------------------</td></tr>';
	a += '<tr><td align="center">Programmed by:</td></tr>';
	a += '<tr><td align="center">Istva&#769;n Szalontai</td></tr>';
	a += '<tr><td align="center"><a href="mailto:istvan.szalontai12@gmail.com">istvan.szalontai12@gmail.com</a></td></tr>';
	a += '<tr><td align="center">&copy; 2014 All Rights Reserved</td></tr>';
	a += '<tr><td align="center">----------------------------------</td></tr>';
	a += '<tr><td align="center">Follow me on Twitter:</td></tr>';
	a += '<tr><td align="center"><a href="https://twitter.com/szalontaiistvan" target="_blank"><div id="btn_twitter"></div></a></td></tr>';
	a += '<tr><td align="center">Version: 0.91</td></tr>';
	a += '</table>';
	f('display').innerHTML = a;
}

function deleteItem(n)
{
	deleteRow(n);
	createStream();
	writeLocalStorage();
	drawEditor();
}

function openOption()
{
	hide('pointer');
	hide('time');
	drawEditor();
}

function backToSchedule()
{
	show('pointer');
	show('time');
	drawSchedule();
}

function backToSetting()
{
	drawEditor();
}

function rowentity(event, hour, min, timevalue, top, height)
{
	this.event = event;
	this.hour = hour;
	this.min = min;
	this.timevalue = timevalue;
	this.top = top;
	this.height = height;
}

function swapRows(n,m)
{
	var tevent = row[n].event;
	var thour = row[n].hour;
	var tmin = row[n].min;
	var ttimevalue = row[n].timevalue;

	row[n].event = row[m].event;
	row[n].hour = row[m].hour;
	row[n].min = row[m].min;
	row[n].timevalue = row[m].timevalue;
	
	row[m].event = tevent;
	row[m].hour = thour;
	row[m].min = tmin;
	row[m].timevalue = ttimevalue;
}

function bubbleFirst()
{
	var n=0;
	for(i=0;i<row.length-3;i++)
	{
		if(row[i].timevalue > row[i+1].timevalue)
		{
			//console.log(row[i].timevalue+' - '+row[i+1].timevalue);
			swapRows(i,i+1);
			n = i+1;
		}
	}
	return n;
}

function insertFromToFirst(n)
{
	var tevent = row[n].event;
	var thour = row[n].hour;
	var tmin = row[n].min;
	var ttimevalue = row[n].timevalue;
	
	for(i=n;i>0;i--)
	{
		row[i].event = row[i-1].event;
		row[i].hour = row[i-1].hour;
		row[i].min = row[i-1].min;
		row[i].timevalue = row[i-1].timevalue;
	}
	
	row[0].event = tevent;
	row[0].hour = thour;
	row[0].min = tmin;
	row[0].timevalue = ttimevalue;
}

function deleteRow(n)
{
	//end behaves different way!
	if(n!=row.length-2)
	{
		for(i=n; i<row.length-1; i++)
		{
			row[i].event = row[i+1].event;
			row[i].hour = row[i+1].hour;
			row[i].min = row[i+1].min;
			row[i].timevalue = row[i+1].timevalue;
		}
	}
	row.pop();
}

function createStream()
{
	var a = '';
	for (i=0; i<row.length; i++)
	{
		a += row[i].event;
		a += sep;
		a += row[i].hour;
		a += ':';
		a += row[i].min;
		
		if(i != row.length-1)a += sep;
		
	}
	raw = a;
	console.log(a);
}

function isValid()
{
	var isCount = (row.length < MAXITEMS);
	var isEvent = (currentEvent*2 != event.length-2);
	var isInterval = (900000 <= (getTodayValue(currentToHour, currentToMin) - getTodayValue(currentFromHour, currentFromMin)));
	return isEvent && isInterval;
}

function getTodayValue(hh,mm)
{
	var v = new Date(d.getFullYear(), d.getMonth(), d.getDate(), hh, mm, 0, 0).valueOf();
	return v;
}

function f(n)
{
	return document.getElementById(n);
}

function show(n)
{
	f(n).style.visibility = 'visible';
}

function hide(n)
{
	f(n).style.visibility = 'hidden';
}
