jQuery.githubUser = function(username, callback) {
   jQuery.getJSON('https://api.github.com/users/'+username+'/repos?callback=?',callback)
}
 
jQuery.fn.loadRepositories = function(username) {
    this.html("<div style='text-align:center;'>Querying GitHub for " + username +"'s repositories...</div>");
     
    var target = this;
    $.githubUser(username, function(data) {
        var repos = data.data; // JSON Parsing
        sortByName(repos);    
     
        var list = $('<div/>');
        target.empty().append(list);
        $(repos).each(function() {
            if (this.name != (username.toLowerCase()+'.github.com')) {
                list.append("<div class='github-box'><div class='github-box-header'><h3><a href='" + this.url + "'>" + this.full_name + "</a></h3><div class='github-stats'><a class='repo-stars' title='Stars' data-icon='7' href='" + this.url + "/watchers'>" + this.watchers + "</a><a class='repo-forks' title='Forks' data-icon='f' href='" + this.url + "/network'>" + this.forks + "</a><a class='repo-issues' title='Issues' data-icon='i' href='" + this.url + "/issues'>" + this.open_issues + "</a></div></div><div class='github-box-content'><p>" + this.description + " &mdash; <a href='" + this.url + "#readme'>Read More</a></p></div><div class='github-box-download'><p class='repo-update'>Latest commit to <strong>master</strong></p><a class='repo-download' title='Download as zip' data-icon='w' href='" + this.url + "/zipball/master'></a></div></div>");
            }
        });      
      });
      
    function sortByName(repos) {
        repos.sort(function(a,b) {
        return a.name - b.name;
	});
    }
};


	$("#btnViewSettings").click(function(){
		var key  = localStorage.key('settings');  
		var data = JSON.parse(localStorage.getItem(key));
	  	//Change to the settings page
		$("#projects").attr('aria-hidden', 'true');
          	$("#settings").removeAttr('aria-hidden');
		//set values
		$("#repoUser").val(data['user']);
    	});

	$("#btnViewProjects").click(function(){
	  	//Change to the settings page
		$("#settings").attr('aria-hidden', 'true');
          	$("#projects").removeAttr('aria-hidden');
		getList();
    	});

	$("#btnSaveRepo").click(function(){ 
		 var repo = {
		 	"user" :  $("#repoUser").val()
	         }
		 var mygithubSettings = 'settings';
		 //Save it in local storage
		 if (window.localStorage) {
		      localStorage.setItem(mygithubSettings, JSON.stringify(repo));
		      alert("Your settings has been saved");
		 }
		 //empty values
		 $("#repoUser").val("");
		 $("#repoUser").focus();
		 //change page
		 $("#settings").attr('aria-hidden', 'true');
          	 $("#projects").removeAttr('aria-hidden');
		 $("#settings").attr('aria-hidden', 'true');
          	 $("#projects").removeAttr('aria-hidden');
		 getList();		  
	});

	//Clear all list
	$("#btnReload").click(function() {
		   if(confirm('Are you sure you want to reset the application?') === true) {
			localStorage.clear();
			//Set title
	 		$("#repoList").html("");
			$("#repoUser").val("");
			alert("All products have got cleared");
		   }	   
	});


function getList() {
	$("#repoList").html("");
  
	var key  = localStorage.key('settings');  
	var data = JSON.parse(localStorage.getItem(key));
	if(data != null) {
		var user = data['user'];	
		$("#repoList").loadRepositories(user);
	} else {
		$("#repoList").html('<div style="text-align:center;">Please set up your Github username</div>');
	}
}
