$(document).ready(function() {

	populate();

	$("#new").click(function() {
		$("#text").val("");
		$("#note").show();
		$("#text").focus();
	});

	$("#back").click(function() {
		$("#note").hide();
	});

	$("#save").click(function() {
		var text = $("#text").val();
		var list = getStorage("mynotes") || [];
		var name = ((new Date()).getTime()).toString();
		list.unshift(name);
		setStorage("mynotes", list);
		localStorage.setItem(name, text);
		$("#notes").html("");
		populate();
		$("#note").hide();
	});

	$(document).delegate(".del", "click", function() {
		var name = ($(this).parents(".note")).data("name");
		console.log(name);
		var list = getStorage("mynotes");
		var k = list.indexOf(name.toString());
		console.log(k);
		list.splice(k, 1);
		setStorage("mynotes", list);
		localStorage.removeItem(name);
		$("#notes").html("");
		populate();
	});
});


function getStorage(key) {
	if(localStorage.getItem(key)) {
		return JSON.parse(localStorage.getItem(key));
	}
	else {
		return false;
	}
}

function setStorage(key, value) {
	localStorage.setItem(key, JSON.stringify(value));
}

function populate() {
	var list = getStorage("mynotes") || [];
	$.each(list, function(key, val) {
		var obj = localStorage.getItem(val);
		var time = new Date(parseInt(val));
		$("#notes").append('<div class="note" data-name="'+val+'"><div class="time"><span>'+time.toLocaleDateString()+'</span><a href="#" class="del">Delete</a></div>'+obj+'</div>');
	});
}