/**
 * https://github.com/toosha01/ajax-javascript
 * Simple, lightwight and easy to use ajax function in pure javascript
 * @param  String url     Target URL
 * @param  Object options Please read README.md
 * @return 
 * 			-1 : No target URL
 * 			-2 : Creating XMLHTTP error
 * 			-3 : XMLHTTP Request error
 * 			-4 ; XMLHTTP Response error
 */
function ajax( url , options )
{
	if ( !url ) {
		console.log( "No Target URL is provided. URL : " + url );
		return -1;
	}
	
	var parameters = '';
	var callback = false; // callback function
	
	// Getting provided callback function
	if ( typeof options.callback === 'function' ) {
		callback = options.callback;
	} else if ( typeof options.callback === 'string' ) {
		callback = window[ options.callback ];
	}
	
	// Creating url string from the parameters
	if ( options.data instanceof Object ) {
		for ( key in options.data ) {
			if ( parameters.length > 0 ) parameters = parameters + '&';
			parameters = parameters + key + '=' + options.data[ key ];
		}
	} else if ( typeof options.data === 'string' ) {
		parameters = parameters + options.data;
	}
	
	// jsonp part
	if ( options.jsonp ) {
		var cbnum = Math.random().toString(16).slice(2);
		var script = document.createElement( 'script' );

		if ( parameters.length > 0 ) {
			parameters = '?' + parameters + '&callback=cb' + cbnum;
		} else {
			parameters = '?callback=cb' + cbnum;
		}

		window[ 'cb' + cbnum ] = function( data ) {

			try {
				callback( data );
			}
			finally {
				delete window[ 'cb' + cbnum ];
				script.parentNode.removeChild( script );
			}
		}

		script.src = url + parameters;

		document.body.appendChild( script );

	// Local ajax part
	} else {
		var xmlhttp;

		if ( window.XMLHttpRequest ) {// code for IE7+, Firefox, Chrome, Opera, Safari
			xmlhttp = new XMLHttpRequest();
		} else {// code for IE6, IE5
			xmlhttp = new ActiveXObject( "Microsoft.XMLHTTP" );
		}

		if ( !xmlhttp ) {
			//console.log( "XMLHTTP initiating is failed" );
			callback('{"error":"XMLHTTP initiating is failed"}');
			return -2;
		}
		
		if ( callback ) {
			
			xmlhttp.onreadystatechange = function() {
				if ( xmlhttp.readyState == 4 ) {
					if ( xmlhttp.status == 200 || xmlhttp.status == 0 ) {
						callback( xmlhttp.responseText );
					} else {
						//console.log( "XMLHTTP Response error : " + xmlhttp.statusText );
						callback('{"error":"'+xmlhttp.statusText+'"}');
						return -4;
					}
				}
			}
		}

		try {
			//alert(options.isPost+" - "+options.isJson+" - "+options.auth);
			//alert(parameters);
			if ( options.isPost )
			{
				//alert("Calling: "+url);
				//alert("Passing: "+parameters);
				//alert("Auth: "+options.auth);
				
				xmlhttp.open( "POST" , url , true );
				
				if ( options.auth != "" )
					xmlhttp.setRequestHeader( "Authorization",options.auth );
				if ( options.isJson )
					xmlhttp.setRequestHeader( "Content-type","application/json; charset=utf-8" );
				else
					xmlhttp.setRequestHeader( "Content-type","application/x-www-form-urlencoded" );
				
				xmlhttp.send( parameters );
				
				if ( callback ) {
					xmlhttp.onreadystatechange = function() {
						//alert("STATUS: "+xmlhttp.status+"\nREADYSTATE ("+xmlhttp.readyState+")\nRESPONSE JSON: "+xmlhttp.responseJSON+"\nRESPONSE TEXT: "+xmlhttp.responseText+"\n\n");
						if ( xmlhttp.readyState == 4 ) {
							if ( xmlhttp.status == 200 || xmlhttp.status == 0 ) {
								//alert("STATUS: "+xmlhttp.status+"\nREADYSTATE ("+xmlhttp.readyState+")\nRESPONSE JSON: "+xmlhttp.responseJSON+"\nRESPONSE TEXT: "+xmlhttp.responseText+"\n\n");
								//alert("RESPONSE TEXT: "+xmlhttp.responseText);
								callback( xmlhttp.responseText );
							} else {
								//console.log( "XMLHTTP Response error : " + xmlhttp.statusText );
								callback('{"error":"'+xmlhttp.statusText+'"}');
								return -4;
							}
						}
					}
				}
			}
			else
			{
				//alert("Calling: "+url);
				//alert("Passing: "+parameters);
				
				xmlhttp.open( "GET" , url + '?' + parameters , true );
				xmlhttp.send();
			}
		} catch ( err ) {
			//console.log( "XMLHTTP Request error : " + err.message );
			callback('{"error":"'+err.message+'"}');
			return -3;
		}
	}
}
