﻿var honapok = [["Január",[31]], ["Február",[29]], ["Március",[31]], ["Április",[30]], ["Május",[31]], ["Június",[30]], ["Július",[31]], ["Augusztus",[31]], ["Szeptember",[30]], ["Október",[31]], ["November",[30]], ["December",[31]]];

var abc = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"];

//ABC betűinek hozzáadása a select-hez
function addAbc(){
	$("#slcAbc").empty();
	$("#slcAbc").append("<option>Kezdőbetű...</option>");
	
	$.each(abc, function(index, value) {
	 var betu = $("<option>");
	 betu.text(value);
	 $("#slcAbc").append(betu);
	});
	$("#slcAbc").selectmenu();
}

//Hónapok hozzáadása a select-hez
function addHonapok(){
	$("#slcHonap").empty();
	$("#slcHonap").append("<option>Hónap</option>");
	
	$.each(honapok, function(index, value) {
	 var honap = $("<option>");
	 honap.text(value[0]);
	 $("#slcHonap").append(honap);
	});
	$("#slcHonap").selectmenu();
}

//Napok hozzáadása a select-hez
function addNapok(){
	var honapindex = $("#slcHonap").prop('selectedIndex');
	var napindex = $("#slcNap").prop('selectedIndex');
	
	$("#slcNap").empty();
	$("#slcNap").append("<option>Nap</option>");
	
	if(honapindex > 0)
	{
		for (var i=1;i<=honapok[honapindex-1][1];i++)
		{ 
			var nap = $("<option>");
			nap.text(i);
			$("#slcNap").append(nap);
		}
		$("#slcNap").selectmenu();
		
		if(napindex <= honapok[honapindex-1][1])
		{
			$("#slcNap").prop('selectedIndex', napindex);
		}
		else
		{
			$("#slcNap").prop('selectedIndex', honapok[honapindex-1][1]);
		}
	}
	else
	{
		$("#slcNap").val("Nap");
	}
	
	$("#slcNap").selectmenu('refresh', true);
}

//Betölti az egy névhez tartozó névnapokat
function NameDetails(variable){
	var index = $(variable).find("a").attr("data-index");
	var name = data[index].name;
	
	$("#namelist_name").text(name);

	$("#namelist_list").empty();
	$("#namelist_list").append("<li data-role=\"list-divider\">Névnapok</li>");
	
	$.each(data[index].dates, function(index, value) {
		
		var element = $("<li>");
		var link = $("<a>");
		link.attr("href", "#day");
		link.attr("data-day", value.date);
		link.text(NumberDateToText(value.date));
		element.append(link);
		
		if(value.main){
			var main = $("<div>");
			main.attr("class","ui-li-count");
			main.text("!");
			element.append(main);
		}
		
		$("#namelist_list").append(element);
		
		
	});
	
	try {
		$('#namelist_list').listview('refresh');
	} catch (ex) {}
}

//Szöveggé alakítja a hónap számát
function NumberDateToText(numberdate){
	return honapok[numberdate.split(".")[0]-1][0] + " " + numberdate.split(".")[1] + ".";
}

//Listázza az adott naphoz tartozó neveket
function searchNameByDay(){
	var honapindex = $("#slcHonap").prop('selectedIndex');
	var napindex = $("#slcNap").prop('selectedIndex');
	
	if(honapindex > 0 && napindex > 0)
	{	
		//Töltőképernyő megjelenítése
		/*$.mobile.loading( 'show', {
			text: 'Keresés',
			textVisible: true,
			theme: 'a',
			html: ""
			});
		
		$("#srcnametitle").slideUp();
		$("#srcnamelist").slideUp();
			
		var element = $("<li>");
		element.text("Béla");
		$("#srcnamelist").empty();
		$("#srcnamelist").append(element);
		$('#srcnamelist').listview('refresh');
		$("#srcnamelist").slideDown();
		
		//Képernyő elrejtése
		$.mobile.loading( "hide");*/
		searchNameByDateClicked(honapindex + "." + napindex + ".");
	}
}

//Listázza kezdőbetű alapján a jeveket
function searchNameByFirstLetter(){
	var kezdobetu = $("#slcAbc").val().toLowerCase();
	
	$("#abclist").slideUp();
	
	$("#abclist").promise().done(function(){
	$("#abclist").empty();
	
	if(kezdobetu.length == 1)
	{
		//Töltőképernyő megjelenítése
		$.mobile.loading( 'show', {
			text: 'Keresés',
			textVisible: true,
			theme: 'a',
			html: ""
			});
			
		
	
		$.each(data, function(index, value) {
		
			var nevelsobetu = value.name.charAt(0).toLowerCase();
			nevelsobetu = nevelsobetu.replace("á","a").
							replace("é","e").replace("í","i").
							replace("ó","o").replace("ö","o").
							replace("ő","o").replace("ü","u").
							replace("ű","u").replace("ú","u");
		
			if(nevelsobetu == kezdobetu)
			{
				var element = $("<li>");
				var link = $("<a>");
				link.attr("href", "#namelist");
				link.attr("data-index", index);
				link.text(value.name);
				element.append(link);
				$("#abclist").append(element);
			}
		});
		
		$('#abclist').listview('refresh');
		
		//Képernyő elrejtése
		$.mobile.loading( "hide");
		
		$("#abclist").slideDown();
	}
	});
	
}

//Listázza a kereséssel való egyezés alapján a neveket
function searchNameByName(){
	var searchtext = $("#namesearch_fasttext").val();
	
	if(searchtext.length >= 3){
		$("#namesearch_fastlist").slideUp();
		$("#namesearch_fastlist").promise().done(function(){
		$("#namesearch_fastlist").empty();
		
		var count = 0;
		
		$.each(data, function(index, value) {
		
		var nev = value.name.toLowerCase();
		nev = nev.replace("á","a").
				replace("é","e").replace("í","i").
				replace("ó","o").replace("ö","o").
				replace("ő","o").replace("ü","u").
				replace("ű","u").replace("ú","u");
		
		searchtext = searchtext.toLowerCase().replace("á","a").
						replace("é","e").replace("í","i").
						replace("ó","o").replace("ö","o").
						replace("ő","o").replace("ü","u").
						replace("ű","u").replace("ú","u");
		
			if(nev.indexOf(searchtext) > -1)
			{
				count = count + 1;
				var element = $("<li>");
				var link = $("<a>");
				link.attr("href", "#namelist");
				link.attr("data-index", index);
				link.text(value.name);
				element.append(link);
				$("#namesearch_fastlist").append(element);
			}
		
		});
		
		if(count === 0){
			var error = $("<li>");
			error.attr("data-theme","f");
			error.text("Nincs találat!");
			$("#namesearch_fastlist").append(error);
		}
		
		
		$('#namesearch_fastlist').listview('refresh');
		$("#namesearch_fastlist").slideDown();
		});
	}
	else
	{
		$("#namesearch_fastlist").slideUp();
		$("#namesearch_fastlist").promise().done(function(){
		$("#namesearch_fastlist").empty();
		var error = $("<li>");
		error.attr("data-theme","f");
		error.text("Legalább 3 karakter kötelező!");
		$("#namesearch_fastlist").append(error);
		$('#namesearch_fastlist').listview('refresh');
		$("#namesearch_fastlist").slideDown();
		});
	}
}


function searchNameByDateClicked(day){
	
	$("#srcnametitle").slideUp();
	$("#srcnamelist").slideUp();
	$("#srcnamelist").promise().done(function(){
	$("#srcnamelist").empty();
	$("#srcnamelist").append("<li data-role=\"list-divider\">Ünnepelnek</li>");
	
	$.each(data, function(index, value) {
		
		$.each(value.dates, function(index2, date) {
				//alert(value.name + " - " + date.date);
				if(date.date == day){
					var element = $("<li>");
					var link = $("<a>");
					link.attr("href", "#namelist");
					link.attr("data-index", index);
					link.text(value.name);
					element.append(link);
					$("#srcnamelist").append(element);
				}
				
		});
		
	});
	
	try {
	$('#srcnamelist').listview('refresh');
	} catch (ex) {}
	$("#srcnamelist").slideDown();
	});
	
}

function SearchNameBySelectedName(variable){

	var honap = $(variable).find("a").attr("data-day").split(".")[0];
	var nap = $(variable).find("a").attr("data-day").split(".")[1];
	
	addHonapok();
	$("#slcHonap").val(honapok[honap-1][0]);
	$("#slcHonap").selectmenu('refresh', true);
	addNapok();
	$("#slcNap").val(nap);
	$("#slcNap").selectmenu('refresh', true);
	
	searchNameByDateClicked($(variable).find("a").attr("data-day"));
}

function addToday(){
	
	var year = new Date().getFullYear();
	var datestring = new Date().getMonth()+1 + "." + new Date().getDate() + ".";
	var textdatestring = honapok[new Date().getMonth()][0];
	
	$("#today_title").text(year + ". " + textdatestring.toLowerCase() + " " + new Date().getDate() + ".");
	
	$("#today_list").slideUp();
	$("#today_list").promise().done(function(){
	$("#today_list").empty();
	$("#today_list").append("<li data-role=\"list-divider\">Ma ünnepelnek:</li>");
	
	
	$.each(data, function(index, value) {
		
		$.each(value.dates, function(index2, date) {
				if(date.date == datestring){
					var element = $("<li>");
					var link = $("<a>");
					link.attr("href", "#namelist");
					link.attr("data-index", index);
					link.text(value.name);
					element.append(link);
					$("#today_list").append(element);
				}
				
		});
		
	});
	
	try {
	$('#today_list').listview('refresh');
	} catch (ex) {}
	$("#today_list").slideDown();
	
	});
	
}

