// Populate the database
var nakaiydb = TAFFY(); 
function populateDB() {
	var nakaiy = new Array();
	nakaiy["1"] = ["Mula", "10 Dec - 22 Dec", "Iruvaa", "First Nakaiy of Iruvaa", "Strong winds, rough seas", "The name given in Maldives to the first Nakaiy of Iruvaa season. On the third day of this nakaiy “badi helun” ceremony is held. The olden form of writing this name in Dhivehi was Mulahalha. According to Hindu astrologers it is the 19th Lunar mansion named Mula which means \"the root\" and the presiding divinity is Nirrti. Arab: it is the 19th manzil of the moon, and is named Ash-Shaulah, meaning \"the sting\" (of the scorpion). Sinhala name is Mula. This is figured as a Lions Tail.", "Iruvaa season begins. During this period winds are strong and not settled to blow from one direction and the seas are rough. Generally winds are from the North-East.", "Average rainfall for this Nakaiy is 84.0 mm (3.31 inches); wind speed is 11 knots/hr. (20.37 km/hr.); sunshine is 86.4 hours.", "Good for Tuna, bad for Bonito. Live bait is abundant in the northern Maldives.", "", "Epsilon, Mu, Xi, Eta Theta, Iota, Chi, Upsilon and Lambda (shaula) in Scopionis"]; 
	nakaiy["2"] = ["Furahalha", "23 Dec - 5 Jan", "Iruvaa", "Second Nakaiy of Iruvaa", "Strong north-easterly winds, rough seas", "The name given to the second Nakaiy of Iruvaa season. According to the Hindu astrologers it is the twentieth lunar mansion and is named Purva-Ashadha. The word \"Ashadha\" means \"unsubdued\", and Purva designates \"former, because this and the following asterisms are taken to form a double asterism. the presiding divinity is Apa Deva. To the Arabs it is the twentieth manzil of the moon and is named An-Na’am, meaning \"the pasturing cattle\".  Sinhala name is Puvasala. It is figured as either as a bed or a couch.", "Generally winds are strong and blow from the North-East during this period. The seas are rough.", "Average rainfall for this Nakaiy is 76.5 mm (3.01 inches); the average wind speed is 12 knots per hour (22.22 km/hr) and the sunshine is 97.1 hrs.", "Good in the North of Maldives.", "", "Delta and Epsilon (Kaus Australis) in Sagittarii"]; 
	nakaiy["3"] = ["Uthura-halha", "6 Jan - 18 Jan", "Iruvaa", "Third Nakaiy of Iruvaa", "Clear blue skies, strong winds, rough seas", "The name given to third Nakaiy of Iruvaa season. According to the Hindu astrologers it is the twenty-first lunar mansion and is called Uttara-Ashadtha. The word “uttara” meaning \"latter\". The presiding divinity is Vicve Deva. This is the latter of the two \"Halha\" asterism. To the Arabs it is the twenty-first manzil of the moon and is named Al-Baldah meaning \"the town\". Singhala name is Uthurusala. It is figured as an elephant\'s tusk.", "Winds are strong and are from the North-East and the seas are rough during this period.", "Average Rainfall for this Nakaiy is 21.6 mm (0.86 inches); average wind speed is 12 knots/hr. (22.22 km/hr.)", "Average.", "Planting Millets.", "Sigma (Nunki), and Zeta in Sagitarrarii"]; 
	nakaiy["4"] = ["Huvan", "19 Jan - 31 Jan", "Iruvaa", "Fourth Nakaiy of Iruvaa", "Calm seas, blue skies", "The name given to the fourth Nakaiy of Iruvaa season. According to the Hindu astrologers it is the twenty-third lunar mansion and is named Cravana, meaning \"hearing, or ear\". The presiding divinity is Visnu. To the Arabs it is the twenty -third manzil of the moon and is named Sa’d Bula, meaning \"felicity of a devourer\" or Al-Bula, meaning \"the devourer\". Singhala name is Suvana. It is figured as three steps.", "In this Nakaiy seas are calm, winds moderate and blow from the North-East.", "Winds at an average speed of 12 knots/hr. (22.22 km/hr.) Average rainfall is 24.2 mm (0.95 inches) and the sunshine is 101.6 hrs.", "Fishing is good from the fishing grounds on the eastern side of Maldives.", "", "Alpha (Altair), Beta and Gamma in Aquilae"]; 
	nakaiy["5"] = ["Dhinasha", "1 Feb - 13 Feb", "Iruvaa", "Fifth Nakaiy of Iruvaa", "North-easterly winds, moderate seas, plenty of sunshine", "The name given to the fifth Nakaiy of Iruvaa season. In the past it was during this nakaiy that sailing vessels left  Maldives for Cochin and other ports in the area. According to the hindu astrologers it is the twenty-fourth lunar mansion and is named Cravishtha, meaning “most famous”. The presiding deities are eight Vasus. To the Arabs it is the the twenty-fourth manzil of the moon and is named Sa’d as-Su’ud, meaning \"felicity of felicities\". Singhala name is Dhenata. Figured as a drum.", "During this period seas are moderate and winds blow from the North-East.", "Winds at an average speed of 11 knots per hour (20.37 km/hr.). Average rainfall is 37.8 mm (1.49 inches) and the sunshine is 107.4 hrs.", "Good for shark fishing, Sailing towards the Malabar coast.", "", "Alpha, Beta, Gamma and Delta in Delphini"]; 
	nakaiy["6"] = ["Hiyavihaa", "14 Feb - 26 Feb", "Iruvaa", "Sixth Nakaiy of Iruvaa", "Seas are calm, days and nights are hot", "The name given to the sixth Nakaiy of Iruvaa season. According to the Hindu Astrologers it is the twenty fifth lunar mansion and is named Catabhishaj, meaning \"having a hundred physicians\". The presiding divinity is Varuna. To the Arabs it is the twenty-fifth manzil of the moon and is called Sa\'d al -Akhbiyah, which mean \"felicity of tents\". Singhala name is Siyavasa. It is figured a a circle.", "During this period the seas are calm, the winds blow from the North-East.", "Winds at an average speed of 9 knots/hr. (16.67 km/hr.). The currents of the seas are moderate. Average rainfall for this Nakaiy is 14.4 mm (0.57 inches) and the sunshine is 126.5 hrs.", "Good. Schools closer to the coast.", "Fields are sown.", "Lambda in Aquarii"]; 
	nakaiy["7"] = ["Fura-badhuruva", "27 Feb - 11 Mar", "Iruvaa", "Seventh Nakaiy of Iruvaa", "Frequent, short, sharp bursts of thunder and lightning", "The name given in Maldives to the seventh Nakaiy of Iruvaa season. According to Hindu astrologers it is the twenty-sixth lunar mansion and is named, along with the following asterism Bhadrapada, which means \"beautiful foot\". Another name given to this asterism is Proshthapada. This again is a double asterism and to distinguish the two one has the prefix \"Purva\" meaning \"former\" added to the name. The presiding divinity is Ajikapada. To the Arabs it is the twenty-six manzil of the moon and is called Al-Fargh al-Mukdim, which means \"the fore spout of water-jar\". Singhala name is Puvaputupa. Figured as a couch.", "There may be storms lasting a short duration, thunder and lightning maybe frequent during this period. Generally winds are moderate and blow from the North-East.", "Winds at 7 knots/hr. (12.96 km/hr.) Average rainfall is 43.2 mm (1.70 inches) and the sunshine is 120 hours.", "Very good.", "Magoo (Beach Naupaka - Scaevola taccada), Uni (Guettarda speciosa) and Dhakadhaa (Premna obtusifolia) are cut down and allowed to dry.", "Alpha (Markab), Beta (Scheat) in Pegasi"]; 
	nakaiy["8"] = ["Fas-badhuruva", "12 Mar - 25 Mar", "Iruvaa", "Eighth Nakaiy of Iruvaa", "Usually clear blue skies", "The name given in Maldives to the eighth Nakaiy of Iruvaa season. According to Hindu astrologers it is the twenty-seventh lunar mansion and is named Uttara-Bhadrapada. It forms a double asterism with the preceding one. The presiding divinity is Ahi Budhnya. To the Arabs it is the twenty-seventh manzil of the moon and is called Al Fargh al-Mukhir, which means \"the hind spout of the water jar\". Singhala name is Uthuruputupa. Figured with a double face.", "On the third or fourth day of this Nakaiy the storm associated with its name is normally experienced. Thunder and lightening may be experienced. Generally winds are moderate and blow from the North-East.", "Winds at an average speed of 07 knots/hr. Thunder and lightning may be experienced. Average rainfall for this Nakaiy is 31.8 mm (1.25 inches) and the Sunshine is 131.3 hrs.", "Very good.", "It is said that if thundering is frequent, Yam harvest will be good for the year.", "Gamma (Algenib) an Pegasi and Alpha (Alpheratz) in Andromedae"]; 
	nakaiy["9"] = ["Reyva", "26 Mar - 7 Apr", "Iruvaa", "Last Nakaiy of Iruvaa", "If storms occur they may be severe", "The name given in Maldives to the ninth and the last Nakaiy of Iruvaa season. According to Hindu astrologers it is the twenty-eighth lunar mansion and is named Revati, meaning \"wealthy\", \"abundant\". The presiding divinity is Pushan. To the Arabs it is the twenty-eighth manzil of the moon and is called Batn al-Hut, which mean \"the fish\'s belly\". Sinhala name is Revathi. Figured as a tabor.", "The storm associated with its name, if experienced at night, will be severe. Winds from North-West.", "Average rainfall for this Nakaiy is 5.2 mm (1.98 inches); average wind speed is 7 knots/hr. (12.96 km/hr.) and the average sunshine is 103.4 hours.", "Fishing is generally good in the northern atolls of the Maldives.", "Mirihi (Wedelia biflora) in the fields are cut down and allowed to dry before being burnt.", "Xi in Piscium"]; 
	nakaiy["10"] = ["Assidha", "8 Apr - 21 Apr", "Hulhangu", "First Nakaiy of Hulhangu", "Begins with a storm, then becomes hot and dry", "The name given in Maldives to the first Nakaiy of Hulhangu season. People in the Maldives get themselves wet with the first rains of this nakaiy in the belief that it will bring them good luck. According to Hindu astrologers it is the first lunar mansion and is named Acvini, meaning ”two horsemen”. The presiding divinity are Acvins. To the Arabs it is the first manzil of the moon and they name it Ash-Sharatan, meaning “the two tokens”. Sinhala name is Asvidha. It is figured as a horse-head.", "Dry & hot. Very little rain. South West Monsoon Starts. After the initial storm of this Nakaiy winds are weak and blow from the West.", "Winds at an average speed of 07 knots per hour (12.96 kilometers per hour). The Average Rainfall for this Nakaiy is 49.6 millimeters (1.95 inches) and sunshine is 116.1 hours.", "Poor. Usually sharks are caught.", "Planting millets & trees: hoeing land.", "Alpha (Hamal), Beta (Sheratan), and Gamma in Arietis"]; 
	nakaiy["11"] = ["Burunu", "22 Apr - 5 May", "Hulhangu", "Second Nakaiy of Hulhangu", "Begins with a storm and strong winds, then becomes calm", "The name given in Maldives to the second Nakaiy of Hulhangu season. According to Hindu astrologers it is the second lunar mansion and is named Bharani, meaning ”bearer away”. To the Arabs it is the second manzil of the moon and is called Al Butain, meaning “little belly”. Sinhala name is Berana. It is figured as a pudendum muliebre.", "Rather dry & stormy with rough seas. This Nakaiy is ushered in with a storm accompanied by strong winds but it will be calm after this initial storm. The direction of the wind is not settled but generally blows from the West.", "Winds at an average speed of 10 knots per hour. (18.52 kilometers per hour). Average Rainfall for this Nakaiy is 65.9 mm (2.59 inches), and Sunshine is 115.4 hours.", "Poor.", "The main agricultural activity during this Nakaiy is allowing the chopped trees on the cleared area to dry before being burnt. On some islands seeds are sown in this Nakaiy.", "Musca Borealis in Arietis"]; 
	nakaiy["12"] = ["Kethi", "6 May - 19 May", "Hulhangu", "Third Nakaiy of Hulhangu", "Dark clouds, frequent rains", "The name given in Maldives to the third Nakaiy of Hulhangu season. According to Hindu astrologers it is the third lunar mansion and is named Krittika. The presiding divinity is Agni. To the Arabs it is the third manzil of the moon and is named Ath-Thuraiya, meaning \"the little thick-set group\". Sinhala name is Kethi. It is either figured as either a flame or a razor.", "Weather for Hulhangu season (South-West Monsoon) is firmly settled in this Nakaiy. According to an old Maldivian saying, there will be seven storms in this Nakaiy. Clouds will be dark and rains frequent. It is with this Nakaiy that the stormy days of Hulhangu begins.", "Average rainfall for this Nakaiy is 11.9 mm (4.41 inches). Winds are from the West at an average speed of 11 knots per hour (20.37km/hr.) Average sunshine is 97.4 hrs.", "Poor.", "Dried leaves of the cleared fields are burnt, the ashes are raked and spread and the fields are sown.", "Pleiades in Taurus"]; 
	nakaiy["13"] = ["Roanu", "20 May - 2 Jun", "Hulhangu", "Fourth Nakaiy of Hulhangu", "Storms, strong winds and rough seas", "The name given in Maldives to the fourth Nakaiy of Hulhangu season. According to Hindu astrologers it is the fourth lunar mansion and is named Rohini, meaning “ruddy”. The presiding divinity is Prajapati. To the Arabs it is the 4th Manzil of the moon and they call it Ad-Dabaran, which means \"the follower\". Sinhala name is Rehena. It is figured as either a wain or a temple.", "Generally stormy with heavy rain, strong winds & rough seas. Winds blow generally from the West.", "Average Rainfall for this Nakaiy is 119.7 mm (4.71 inches). Winds at an average of 13 knots per hour (24.08 km/hr). Average sunshine is 89.3 hrs.", "Mainly Kawakawa.", "Fields are sown on some islands.", "Alpha, Thetha, Gamma, Delta and Epsilon in Tauri"]; 
	nakaiy["14"] = ["Miahelli", "3 Jun - 16 Jun", "Hulhangu", "Fifth Nakaiy of Hulhangu", "Storms, rough seas and strong westerly winds", "The name given in Maldives to the fifth Nakaiy of Hulhangu season. According to Hindu astrologers it is the fifth lunar mansion and is named Mogacirsha or Mogaciras, meaning “antelope’s head”. The presiding divinity is Soma. To the Arabs it is the fifth manzil of the moon and is called Al-Hak’ah. Sinhala name is Muvasirisa. It is figured as a head of an antelope.", "Stormy with rough seas and strong winds blowing generally from the West. Seas are rough and not suitable for traveling.", "Winds at an average speed of 11 knots/hr (20.37 km/hr). Average rainfall is 80.1mm (3.15 inches) and the average sunshine is 95.6 hours.", "Poor.", "Fields are sown and weeding carried out.", "Lambda, Phi (one) and Phi (two) in Orionis"]; 
	nakaiy["15"] = ["Adha", "17 Jun - 30 Jun", "Hulhangu", "Sixth Nakaiy of Hulhangu", "Storms, south-westerly winds", "The name given in Maldives to the sixth Nakaiy of Hulhangu season. According to Hindu astrologers it is the sixth lunar mansion and is is called Ardra, which means \"moist\". The presiding divinity is Rudra. To the Arabs it is the sixth manzil of the moon and is known as Al Han\'ah, meaning \"the pile\". Singhala name is Adha. it is figured as a gem.", "Sea travelers try to steer towards the middle of storm clouds as the clouds tend to divide and give a clear path in the centre, the worst being experienced at both ends of these clouds.  Wind blows generally from South-West.", "Winds at an average of 11 knots (20.37 km/hr) Average rainfall for this Nakaiy is 65.8 mm (2.59inches). Average sunshine is 100.6 hrs.", "Good large schools of fish are found.", "Weeding, thinning, gap-filling and transplanting of the field is done.", "Alpha (Betelgeuse) in Orionis"]; 
	nakaiy["16"] = ["Funoas", "1 Jul - 14 Jul", "Hulhangu", "Seventh Nakaiy of Hulhangu", "Storms, rough seas, frequent sudden gales", "The name given in Maldives to the seventh Nakaiy of Hulhangu season. According to Hindu astrologers it is the seventh lunar mansion and is named Punarvasu, meaning “good or brilliant again”. The presiding divinity is Aditi. To the Arabs it is the seventh manzil of the moon, and it is called Adh-Dhira, meaning \"the paw\". Singhala name is Punavasa. It is figured as a house.", "This is a stormy Nakaiy. Seas are rough and the winds blow generally from the West. Sudden gusts of wind are a frequent feature of this Nakaiy.", "Winds at an average of 10 knots/hr. (18.52 km/hr). Average rainfall is 61.2 mm (2.41inches) and the average sunshine is 102.9 hrs.", "Average.", "Weeding, thinning, gap-filling and transplanting of the field is done.", "Alpha (Castor) and Beta (Pollux) in Geminorium"]; 
	nakaiy["17"] = ["Fus", "15 Jul - 28 Jul", "Hulhangu", "Eighth Nakaiy of Hulhangu", "Wet and overcast", "The name given in Maldives to the eighth Nakaiy of Hulhangu season. According to Hindu astrologers it is the eighth lunar mansion and is called Pushya, which means, \"nourish, thrive\" it is also called Tishya, which means \"auspicious\". The presiding divinity is Brahaspati. To the Arabs it is the eighth manzil of the moon and is known as An-Nathrah, meaning \"the nose-gap\". Singhala name is Pusha. It either figured as a crescent or a barbed head of an arrow.", "This Nakaiy is rainy and the skies are overcast most of the time. Winds are generally from the West.", "Winds at an average speed of 11 knots per hour (20.37 km/hr). Average rainfall is 88.6 mm (3.49 inches) and the average sunshine is 89.0 hrs.", "Good. Schools are very close to the coast.", "", "Theta, Delta and Gamma in Cancri"]; 
	nakaiy["18"] = ["Ahuliha", "29 Jul - 10 Aug", "Hulhangu", "Ninth Nakaiy of Hulhangu", "Less frequent storms, calmer days", "The name is given in Maldives to the ninth Nakaiy of Hulhangu season. According to Hindu astrologers it is the ninth lunar mansion and is named Aclesha, meaning “entwiner or embracer”. The presiding divinity are the Sarpas. To the  Arabs it is the ninth Manzil of the moon and is called At-Tarf, which means \"the look\". Sinhala name is Aslisa. It is figured as a wheel.", "Calm and dry with lot of sunshine. During this period the stormy days of Hulhangu begin to come to a close. Its generally calm. Winds generally blow from the West.", "Winds at an average speed of 10 knots/hr. Average rainfall is 67.3 mm (2.65 inches), and the average sunshine is 96.9 hrs.", "Good. Schools move away from the coast.", "Grain harvest is reaped during this Nakaiy.", "Eta, Sigma, Delta, Epsilon and Rho in Hydrae"]; 
	nakaiy["19"] = ["Maa", "11 Aug - 23 Aug", "Hulhangu", "Tenth Nakaiy of Hulhangu", "Generally calm", "The name given in Maldives to the tenth Nakaiy of Hulhangu season. According to Hindu astrologers it is the tenth lunar mansion and is named Magha, meaning \"mighty\". The presiding divinity are th Pitaras. To the Arabs it is the tenth manzil of the moon and is called Aj-Jabhah, \"the forehead\". Sinhala name is Magha.", "Generally calm, but the old Maldivian saying is that, if Ahuliha has been stormy, then Maa too is most likely to be stormy.  Winds generally blow from the West.", "Winds at an average speed of 11 knots/hr. (20.37 km/hr.) Average rainfall is 106.0mm (4.17 inches) and the average sunshine is 76.9 hours.", "Possible, if no rain.", "Harvesting.", "Alpha (Regulus), Zeta, Gamma (Algeiba), Mu, Epsilon and Eta in Leonis"]; 
	nakaiy["20"] = ["Fura", "24 Aug - 6 Sep", "Hulhangu", "Eleventh Nakaiy of Hulhangu", "Isolated showers. Rainy season ends. usually dry with light north-westerly winds", "The name is given in Maldives to the eleventh Nakaiy of Hulhangu season. According to Hindu astrologers it is the eleventh lunar mansion and it is a double asterism having the same Phalguni. The word Purva meaning “former” being added to this one to distinguish it from the following. The exact meaning of the word is not certain but is used to designate a species of  fig tree. The presiding divinity is Bhaga. To the Arabs it is the eleventh Manzil of the moon and they name it, Az-Zubrah, \"the mane\". Singhala name is Puvapal. it is figured as a couch.", "This is the end of the rainy days of Hulhangu. There are isolated showers. Wind generally blows from the North-West.", "Winds at an average speed of 10 knots/hr. (18.52 km/hr.). Average rainfall is 48.0 mm (1.89 inches) and the average sunshine is 107.8 hours.", "Average schools are far from coast.", "Harvesting.", "Delta and Theta in Leonis"]; 
	nakaiy["21"] = ["Uthura", "7 Sep - 20 Sep", "Hulhangu", "Twelfth Nakaiy of Hulhangu", "Strong north-westerly winds", "The name given in Maldives to the twelfth Nakaiy of Hulhangu season. According to Hindu astrologers it is the twelfth lunar mansion and is called Uttara Phalguni. Being a double asterism with the former. The presiding divinity is Aryaman. To the Arabs it is the twelfth manzil of the moon and is known as As-Sarfah, \"the turn\". Sinhala name is Uthurupal. It is figured as a bed.", "Wind blows generally from the North West.", "Winds at an average speed of 12 knots (22.22 km/hr.) Average rainfall is 116.6 mm (4.59 inches). And the average sunshine is 90.7 hrs.", "Average. Sailing towards Bengal.", "", "Beta (Denebola) in Leonis"]; 
	nakaiy["22"] = ["Atha", "21 Sep - 3 Oct", "Hulhangu", "Thirteenth Nakaiy of Hulhangu", "Generally clear and calm with isolated showers", "The name is given in Maldives to the thirteenth Nakaiy of Hulhangu season. According to Hindu astrologers it is the thirteenth lunar mansion and is named Hasta, meaning “hand”. The presiding divinity is Savitar. To the Arabs it is the thirteenth manzil of the moon and it is called Al-Auwa, \"the barking dog\". Sinhala name is Hatha. It is figured as a hand.", "During this period there may be minor storms now and then, but it will be generally clear and calm. Winds blow generally from the West.", "Winds at an average speed of 13 knots per hour (24.08 km/hr.) Average rainfall is 96.1 mm (3.78 inches) & the average sunshine is 80.5 hrs.", "Good. Schools move closer to the coast.", "", "Alpha, Beta, Gamma, Delta and Epsilon in Corvi"]; 
	nakaiy["23"] = ["Hitha", "4 Oct - 17 Oct", "Hulhangu", "Fourteenth Nakaiy of Hulhangu", "Light winds, isolated showers", "The name is given in Maldives to the fourteenth Nakaiy of Hulhangu season. According to Hindu astrologers it is the fourteenth lunar mansion and is named Citra, meaning \"brilliant\". The presiding divinity is Tvashtar. To the Arabs it is the fourteenth manzil of the moon and is known as As-Simak, Sinhala name is Sitha. It is figured as either a pearl or a lamp.", "There may be isolated showers of rain lasting a short duration. Winds are generally weak. There may be isolated showers of rain lasting a short duration. Winds are generally from the West.", "Winds at a speed of 12 knots per hour (22.2 km/hr.) Average rainfall is 104.2 mm (4.10 inches) and the average sunshine is 106.1 hours.", "Average. Schools are seen closer to the coast. Sailing towards Sri Lanka.", "", "Alpha (Spica) in Virginis"]; 
	nakaiy["24"] = ["Hei", "18 Oct - 31 Oct", "Hulhangu", "Fifteenth Nakaiy of the Hulhangu", "Strong winds from all directions", "The name given in maldives to the fifteenth Nakaiy of the Hulhangu season. According to Hindu astrologers it is the fifteenth lunar mansion  and is known as Svati, meaning \"sword\". To the Arabs it is the fifteenth manzil of the moon and is called Al-Ghafr, the \"covering\". Sinhala name is Saa. It is figured as either a coral bead, a gem or a pearl", "Winds may not settle onto one direction, but generally blow from the West.", "Winds at an average speed of 12 knots per hour (22.22 km/hr). Average rainfall is 111.0 mm (4.37 inches) and the average sunshine is 109.7 hours", "Good. Fish caught are usually large.", "", "Alpha (Arcturus) in Bootis"]; 
	nakaiy["25"] = ["Vihaa", "1 Nov - 13 Nov", "Hulhangu", "Sixteenth Nakaiy of Hulhangu", "Calm days", "The name given in Maldives to the sixteenth Nakaiy of Hulhangu season. According to Hindu astrologers it is the sixteenth lunar mansion and is named Vicakha, meaning “having spread branches”. The presiding divinity are Indra and Agni jointly. To the  Arabs it is the sixteenth manzil of the moon and is called Az-Zubanan, \"the two claws\". Sinhala name is Visaa. Figured as a gate.", "Calm. Winds blow generally from the West.", "Winds at an average speed of 11 knots per hour (20.37 km/hr.) Average rainfall is 96.3 mm (3.7 inches) and the average sunshine is 93.0 hrs.", "It is calm and fishing is good in this period. The particular fishing season of these days are called the fishing days of \"Noraahi\".", "", "Alpha, Beta, Gamma and Iota in Librae"]; 
	nakaiy["26"] = ["Nora", "14 Nov - 26 Nov", "Hulhangu", "Seventeenth Nakaiy of Hulhangu", "Light winds, some sun and showers", "The name given in Maldives to the seventeenth Nakaiy of Hulhagu season. According to Hindu astrologers it is the seventeenth lunar mansion and is named Anuradha, meaning “success”. The presiding divinity is Mitra. To the Arabs it is the seventeenth manzil of the moon and is known as Al-Iklil, \"the crown\". Sinhala name is Anura. It is figured as a row.", "Winds will be weak and blow generally from the North-West. The currents in the seas are not settled during this period. On the third day for this Nakaiy the currents of the North East monsoon (Iruvaa) will start to be experienced in the seas.", "Winds at an average speed of 9 knots/hr. (16.67 km/hr) Average rainfall is 84.5 mm (3.33 inches) and the average sunshine is 90.0 hrs.", "According to old Maldivian saying: if the first storm of this Nakaiy comes from the East, then the fishing will generally be good.", "", "Beta Delta and Pi in Scorpionis"]; 
	nakaiy["27"] = ["Dhosha", "27 Nov - 9 Dec", "Hulhangu", "Last Nakaiy of Hulhangu", "Light north-easterly winds", "The name given in Maldives to the eighteenth Nakaiy of Hulhangu season. According to Hindu astrologers it is the eighteenth lunar mansion and is named Jyeshtha, meaning “oldest”. The presiding divinity is Indra. To the \rArabs it is the eighteenth manzil of the moon and is known as Al-Qalb, \"the heart\". Sinhala name is Dheta. It is figured as a ring or an ear-ring.", "Winds will generally be weak and blows from the North-East.", "Winds at an average speed of 9 knots/hr. (16.67 km/hr.) Average rainfall is 101.6 mm (4 inches) and the sunshine is 97.6 hrs.", "Good. Season begins in the South.", "", "Alpha (Antares), Sigma and Tau in Scorpionis"];
	
	for (var i=1; i<nakaiy.length; i++){
		nakaiydb.insert({	id:i, 
							nakaiy:nakaiy[i][0], 
							dates:nakaiy[i][1], 
							season:nakaiy[i][2], 
							number:nakaiy[i][3], 
							description:nakaiy[i][4], 
							meaning:nakaiy[i][5], 
							weather:nakaiy[i][6], 
							averages:nakaiy[i][7], 
							fishing:nakaiy[i][8], 
							agriculture:nakaiy[i][9], 
							asterism:nakaiy[i][10]
						});	
	}
}

function today_queryDB() {
	var curr = new Date();
	currdate =  String(curr.getDate());
	currdate = currdate.length == 1? "0" + currdate: currdate;
	var today = (curr.getMonth()+1) + currdate;
	var d = {101:[2,10],102:[2,11],103:[2,12],104:[2,13],105:[2,14],106:[3,1],107:[3,2],108:[3,3],109:[3,4],110:[3,5],111:[3,6],112:[3,7],113:[3,8],114:[3,9],115:[3,10],116:[3,11],117:[3,12],118:[3,13],119:[4,1],120:[4,2],121:[4,3],122:[4,4],123:[4,5],124:[4,6],125:[4,7],126:[4,8],127:[4,9],128:[4,10],129:[4,11],130:[4,12],131:[4,13],201:[5,1],202:[5,2],203:[5,3],204:[5,4],205:[5,5],206:[5,6],207:[5,7],208:[5,8],209:[5,9],210:[5,10],211:[5,11],212:[5,12],213:[5,13],214:[6,1],215:[6,2],216:[6,3],217:[6,4],218:[6,5],219:[6,6],220:[6,7],221:[6,8],222:[6,9],223:[6,10],224:[6,11],225:[6,12],226:[6,13],227:[7,1],228:[7,2],229:[7,3],301:[7,3],302:[7,4],303:[7,5],304:[7,6],305:[7,7],306:[7,8],307:[7,9],308:[7,10],309:[7,11],310:[7,12],311:[7,13],312:[8,1],313:[8,2],314:[8,3],315:[8,4],316:[8,5],317:[8,6],318:[8,7],319:[8,8],320:[8,9],321:[8,10],322:[8,11],323:[8,12],324:[8,13],325:[8,14],326:[9,1],327:[9,2],328:[9,3],329:[9,4],330:[9,5],331:[9,6],401:[9,7],402:[9,8],403:[9,9],404:[9,10],405:[9,11],406:[9,12],407:[9,13],408:[10,1],409:[10,2],410:[10,3],411:[10,4],412:[10,5],413:[10,6],414:[10,7],415:[10,8],416:[10,9],417:[10,10],418:[10,11],419:[10,12],420:[10,13],421:[10,14],422:[11,1],423:[11,2],424:[11,3],425:[11,4],426:[11,5],427:[11,6],428:[11,7],429:[11,8],430:[11,9],501:[11,10],502:[11,11],503:[11,12],504:[11,13],505:[11,14],506:[12,1],507:[12,2],508:[12,3],509:[12,4],510:[12,5],511:[12,6],512:[12,7],513:[12,8],514:[12,9],515:[12,10],516:[12,11],517:[12,12],518:[12,13],519:[12,14],520:[13,1],521:[13,2],522:[13,3],523:[13,4],524:[13,5],525:[13,6],526:[13,7],527:[13,8],528:[13,9],529:[13,10],530:[13,11],531:[13,12],601:[13,13],602:[13,14],603:[14,1],604:[14,2],605:[14,3],606:[14,4],607:[14,5],608:[14,6],609:[14,7],610:[14,8],611:[14,9],612:[14,10],613:[14,11],614:[14,12],615:[14,13],616:[14,14],617:[15,1],618:[15,2],619:[15,3],620:[15,4],621:[15,5],622:[15,6],623:[15,7],624:[15,8],625:[15,9],626:[15,10],627:[15,11],628:[15,12],629:[15,13],630:[15,14],701:[16,1],702:[16,2],703:[16,3],704:[16,4],705:[16,5],706:[16,6],707:[16,7],708:[16,8],709:[16,9],710:[16,10],711:[16,11],712:[16,12],713:[16,13],714:[16,14],715:[17,1],716:[17,2],717:[17,3],718:[17,4],719:[17,5],720:[17,6],721:[17,7],722:[17,8],723:[17,9],724:[17,10],725:[17,11],726:[17,12],727:[17,13],728:[17,14],729:[18,1],730:[18,2],731:[18,3],801:[18,4],802:[18,5],803:[18,6],804:[18,7],805:[18,8],806:[18,9],807:[18,10],808:[18,11],809:[18,12],810:[18,13],811:[19,1],812:[19,2],813:[19,3],814:[19,4],815:[19,5],816:[19,6],817:[19,7],818:[19,8],819:[19,9],820:[19,10],821:[19,11],822:[19,12],823:[19,13],824:[20,1],825:[20,2],826:[20,3],827:[20,4],828:[20,5],829:[20,6],830:[20,7],831:[20,8],901:[20,9],902:[20,10],903:[20,11],904:[20,12],905:[20,13],906:[20,14],907:[21,1],908:[21,2],909:[21,3],910:[21,4],911:[21,5],912:[21,6],913:[21,7],914:[21,8],915:[21,9],916:[21,10],917:[21,11],918:[21,12],919:[21,13],920:[21,14],921:[22,1],922:[22,2],923:[22,3],924:[22,4],925:[22,5],926:[22,6],927:[22,7],928:[22,8],929:[22,9],930:[22,10],1001:[22,11],1002:[22,12],1003:[22,13],1004:[23,1],1005:[23,2],1006:[23,3],1007:[23,4],1008:[23,5],1009:[23,6],1010:[23,7],1011:[23,8],1012:[23,9],1013:[23,10],1014:[23,11],1015:[23,12],1016:[23,13],1017:[23,14],1018:[24,1],1019:[24,2],1020:[24,3],1021:[24,4],1022:[24,5],1023:[24,6],1024:[24,7],1025:[24,8],1026:[24,9],1027:[24,10],1028:[24,11],1029:[24,12],1030:[24,13],1031:[24,14],1101:[25,1],1102:[25,2],1103:[25,3],1104:[25,4],1105:[25,5],1106:[25,6],1107:[25,7],1108:[25,8],1109:[25,9],1110:[25,10],1111:[25,11],1112:[25,12],1113:[25,13],1114:[26,1],1115:[26,2],1116:[26,3],1117:[26,4],1118:[26,5],1119:[26,6],1120:[26,7],1121:[26,8],1122:[26,9],1123:[26,10],1124:[26,11],1125:[26,12],1126:[26,13],1127:[27,1],1128:[27,2],1129:[27,3],1130:[27,4],1201:[27,5],1202:[27,6],1203:[27,7],1204:[27,8],1205:[27,9],1206:[27,10],1207:[27,11],1208:[27,12],1209:[27,13],1210:[1,1],1211:[1,2],1212:[1,3],1213:[1,4],1214:[1,5],1215:[1,6],1216:[1,7],1217:[1,8],1218:[1,9],1219:[1,10],1220:[1,11],1221:[1,12],1222:[1,13],1223:[2,1],1224:[2,2],1225:[2,3],1226:[2,4],1227:[2,5],1228:[2,6],1229:[2,7],1230:[2,8],1231:[2,9]};
	if (curr.isLeapYear()) { //if leap year
		d[301]=[7,4];d[302]=[7,5];d[303]=[7,6];d[304]=[7,7];d[305]=[7,8];d[306]=[7,9];d[307]=[7,10];d[308]=[7,11];d[309]=[7,12];d[310]=[7,13];d[311]=[7,14];
	}
	var weekday=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
	var month=["January","February","March","April","May","June","July","August","September","October","November","December"];

	curr_date = weekday[curr.getDay()] + " " + curr.getDate() + " " + month[curr.getMonth()] + " " + curr.getFullYear(); 
	curr_nakai_id = d[today][0];
	curr_nakai_date = d[today][1];

	var result = nakaiydb({id:curr_nakai_id}).first()
//alert(nakaiydb);
	var today_bgcol = result.season == "Iruvaa" ? "#aedd1d" : "#2cbbca";
	x$("body").setStyle('backgroundColor', today_bgcol);
	x$("#home").setStyle('backgroundColor', today_bgcol);
	x$("#listview").setStyle('backgroundColor', today_bgcol);
	x$("#detailview").setStyle('backgroundColor', today_bgcol);
	
	x$("#today").setStyle('backgroundColor', today_bgcol);
	x$("#curr_nakaiy_icon").attr("src", "app/images/nakaiy_icons/large/"+curr_nakai_id+".png");
	x$("#curr_nakaiy_icon").attr("alt", result.nakaiy);
	x$("#today").attr("data-nakaiy-id", curr_nakai_id);
	x$("#curr_today").html("Today is "+curr_date);
	x$("#curr_nakaiy").html(curr_nakai_date + " " + result.nakaiy);
	x$("#curr_nakaiy_range").html(result.dates);
	x$("#curr_nakaiy_number").html(result.number);
	x$("#curr_nakaiy_desc").html(result.description);

/* add lecute logos based on nakaiy */
	var l = new Array();
	l[25] = "lecute";l[26] = "lecute";l[27] = "lecute";l[1] = "lecute";l[2] = "lecute";l[3] = "lecute";l[4] = "lecute";
	l[5] = "panasonic";l[6] = "panasonic";l[7] = "panasonic";l[8] = "panasonic";l[9] = "panasonic";l[10] = "panasonic";l[11] = "panasonic";
	l[12] = "lacoste";l[13] = "lacoste";l[14] = "lacoste";l[15] = "lacoste";
	l[16] = "bosch";l[17] = "bosch";
	l[18] = "electrolux";l[19] = "electrolux";l[21] = "electrolux";
	l[22] = "energizer";l[23] = "energizer";l[24] = "energizer";
	brand = l[curr_nakai_id];
	x$("body").setStyle('backgroundImage', 'url("app/images/lecute/'+brand+'.png")');
	x$("#home").setStyle('backgroundImage', 'url("app/images/lecute/'+brand+'.png")');
	x$("#listview").setStyle('backgroundImage', 'url("app/images/lecute/'+brand+'.png")');
	x$("#detailview").setStyle('backgroundImage', 'url("app/images/lecute/'+brand+'.png")');
/* adding lecute logos end*/

	update_today_detail();
	//homeScroll.refresh();
}


function list_queryDB() {
	nakaiydb({season:"Iruvaa"}).order("id desc").each(function(result){list_querySuccess(result)})
	nakaiydb({season:"Hulhangu"}).order("id desc").each(function(result){list_querySuccess(result)})
}
function list_querySuccess(result) {

	var season = result.season.toString();
	list = '<li data-nakaiy-id="'+result.id+'" class="li_'+season+' show_detail">'+
				'<img class="li_nakaiy_icon" src="app/images/nakaiy_icons/small/'+result.id+'.png" alt="icon" />'+
				'<span class="li_nakaiy">'+result.nakaiy+'</span>' +
				'<span class="li_nakaiy_range">'+result.dates+'</span>' +
				'<span class="arrow"></span>' +
			'</li>';
	x$("#season_"+season).after(list);

	if (result.id == 27) { // add event handler after the last nakaiy only to avoid repeating
		var nakaiy_detail_changer = function  (e) {
			x$('.show_detail').un('click', nakaiy_detail_changer)
			x$("#detail_nakaiy_icon").attr("src", "app/images/nakaiy_icons/large/0.png");
			var detail_nakaiy_id = x$(this).attr("data-nakaiy-id");
			var resultd = nakaiydb({id:parseFloat(detail_nakaiy_id)}).first()
			detail_querySuccess(resultd)
			x$(".general_detail_only").hide()
			x$(".nakaiy_detail_only").show()
			////myScroll.goToPage(2, 0, 200)
			x$('#listview').hide();
			x$('#home').hide();
			x$('#detailview').show();
			myScroll.refresh()
			
			setTimeout(function () {
				x$('.show_detail').on('click', nakaiy_detail_changer)
				x$(".show_detail").swipe({click:function(){x$(this).fire('click');}});
			}, 100);
   		}
		x$('.show_detail').on('click', nakaiy_detail_changer)
		x$(".show_detail").swipe({click:function(){x$(this).fire('click');}});
		setTimeout(function () {
			////listScroll.refresh(); //refresh the scroller after all nakaiy are added to the list
			x$('.show_detail').on('click', nakaiy_detail_changer)
			x$(".show_detail").swipe({click:function(){x$(this).fire('click');}});
			myScroll.refresh()
		}, 100);
		
		//x$(".show_detail").swipe({swipeLeft:function(){x$(this).fire('click');}});
		//x$("#detail_nakaiy_text").swipe({swipeLeft:function(){x$("#next_nakaiy_tap").fire('click');}});

		//x$('li').has(".show_detail").click(function(e){x$(this).fire('touchend');});

		//x$("#prev_nakaiy_browse").swipe({swipeLeft:null});
		//x$("#next_nakaiy_browse").swipe({swipeLeft:null});
		/*x$("#nlist").find('li').swipe({swipeRight:function(){
			update_home();
			myScroll.scrollToElement('home', 200);
			
		}});*/

		//x$("#detail_nakaiy_icon_wrap").swipe({swipeLeft:function(){x$("#next_nakaiy_tap").fire('click');}});
		//x$("#detail_nakaiy_icon_wrap").swipe({swipeRight:function(){x$("#prev_nakaiy_tap").fire('click');}});
		//x$("#detail_nakaiy_text").swipe({swipeRight:function(){x$("#backtolist").fire('click');}});
		
	}
}


function detail_querySuccess(result) {
	var bgcol = result.season == "Iruvaa" ? "#aedd1d" : "#2cbbca";
	this_detail_nakaiy_id = result.id;
	// set prev and next
	var prev = this_detail_nakaiy_id-1;
	prev = prev < 1 ? 27 : prev; 
	var next = this_detail_nakaiy_id+1;
	next = next > 27 ? 1 : next;
	x$("#prev_nakaiy_tap").attr("data-nakaiy-id", prev);
	x$("#next_nakaiy_tap").attr("data-nakaiy-id", next);
	x$("#prev_nakaiy_browse").attr("data-nakaiy-id", prev);
	x$("#next_nakaiy_browse").attr("data-nakaiy-id", next);
	
	//inject nakaiy detail info
	x$("#detail_nakaiy_icon").attr("src", "app/images/nakaiy_icons/large/"+this_detail_nakaiy_id+".png");
	x$("#detail_nakaiy_icon").attr("alt", result.nakaiy);
	x$("#detail_nakaiy_icon_wrap").setStyle('backgroundColor', bgcol);
	//x$("#detail_scroll_wrapper").setStyle('backgroundColor', bgcol);

	x$("#detail_nakaiy").html(result.nakaiy);
	x$("#detail_nakaiy_range").html(result.dates);
	x$("#detail_nakaiy_number").html(result.number);
	x$("#detail_nakaiy_desc").html(result.description);
	
	var details_from_db = ["Weather", "Averages", "Fishing", "Agriculture", "Meaning", "Asterism"];
	var nakaiy_details = "";
	for (var i = 0; i < details_from_db.length; i++) {
		var subheading = details_from_db[i];
		var subheading_detail = result[subheading.toLowerCase()];
		if (subheading_detail.length > 0) {
			nakaiy_details += 	"<h3 class='copyable'>"+subheading+"</h3>" +
								"<p class='copyable'>"+subheading_detail+"</p>"
		}	
	}	
	x$("#detail_nakaiy_details").html(nakaiy_details);
	setTimeout(function () {
								////detailScroll.refresh();detailScroll.scrollTo(0,0,0)
		myScroll.scrollTo(0,0)
							}, 0); //refresh detail view scroller 
}
function update_home(){
	//check if today has changed
	var nowdate = String(new Date().getDate());
	nowdate = nowdate.length == 1? "0" + nowdate: nowdate
	if (typeof currdate == "undefined" || currdate != nowdate ) { 
		today_queryDB(); //if so update homepage!
	}
}

function update_today_detail(){
	var detail_nakaiy_id = x$('#today').attr("data-nakaiy-id");
	var result = nakaiydb({id:parseFloat(detail_nakaiy_id)}).first()
	detail_querySuccess(result)
	x$(".general_detail_only").hide()
	x$(".nakaiy_detail_only").show()
}

// PhoneGap is ready
function phoneGapReady() {
	document.addEventListener("backbutton", 
		function(){
			update_home();
			if (x$('#home').getStyle('display') == "block")  { 
				navigator.app.exitApp();
			} else {
				////myScroll.goToPage(0, 0, 200);
				x$('#listview').hide();
				x$('#detailview').hide();
				x$('#home').show();
				myScroll.refresh()
			}
		}, false);
}

function onDeviceReady()
{
	populateDB();
	document.addEventListener("resume", update_home, false); // if resumed from sleeping
	update_home();
	list_queryDB();
	x$('#nakaiy_nevi').click(function(e) {
		////myScroll.goToPage(1, 0, 200);
		x$('#home').hide();
		x$('#listview').show();
		myScroll.refresh()
	})
	x$("#nakaiy_nevi").swipe({click:function(){x$(this).fire('click');}});
	x$('#today').click(function(e) {
		update_today_detail();
    		////myScroll.goToPage(2, 0, 200)
    		////myScroll.enable()
    		x$('#home').hide();
		x$('#detailview').show();
		myScroll.refresh()
	})
	x$("#today").swipe({click:function(){x$(this).fire('click');}});
	
//	x$("#today").swipe({swipeLeft:function(){myScroll.disable();x$(this).fire('click');}});

	x$('#back').click(function(e) {
		update_home();
		////myScroll.goToPage(0, 0, 200);
		x$('#listview').hide();
		x$('#home').show();
		myScroll.refresh()

	})
	x$("#back").swipe({click:function(){x$(this).fire('click');}});


	x$('#backtolist').click(function(e) {
		////myScroll.goToPage(1, 0, 200);
		x$('#detailview').hide();
		x$('#listview').show();
		myScroll.refresh()
	})
	x$("#backtolist").swipe({click:function(){x$(this).fire('click');}});

	
	/*intro pages etc*/
	x$('#introduction').click(function(e) {
		
		x$("#general_detail_content").html(
		'<h3>Nakaiy</h3>'+
'<p class="copyable"><i>an indigenous Maldivian calendar system</i></p>'+
'<img id="intro_img" alt="guide" src="app/images/guide.png" />'+
'<p class="copyable">Tap into centuries old wisdom to gain deeper insight and discover weather patterns through the indigenous Nakaiy Calendar. Geo-specific to the Maldives, one of the most fragile environments on earth, at a time of shifting weather patterns on a global scale we can look and learn from the past to enable us to better prepare for the future. </p>' +

'<p class="copyable">Use Nakaiy Nevi to easily check the current Nakaiy. Visually gauge the passage of time and position of current Nakaiy date, range and a short description of what to expect. More details for each Nakaiy are also available such as weather patterns, fishing, agricultural activities, meaning of the Nakaiy and average weather data for the period.</p>' +

"<p class='copyable'>Maldivians co-existing in relative harmony with their natural environment adapted to the workings of nature by devising and adopting ways to determine its changes and transformations. Nothing shows as clearly as this subtle and complex calendar of the Maldivians' profound practical knowledge of nature and their careful adaptation to their environment. Nakaiy also serves in determining seasons for fishing, planting and harvesting fields.</p>" +

'<p class="copyable">Nakaiy is a calendar system, a derivative from the Indus Valley Civilization, based on observations of subtle changes in the weather. Each Nakaiy is a 13-14 day period each with their own characteristics and weather pattern, based on the positions of certain groups of stars (asterisms). The year is divided into twenty-seven Nakaiy which are grouped into two distinctive seasons: Iruvaa and Hulhangu.</p>' +

'<p class="copyable">Iruvaa (the North-East Monsoon) has nine Nakaiy and runs from December 10 to April 7. Iruvaa means "easterly winds", in reference to the winds which blow mainly from the East, though slightly deflected, during this season. </p>' +

'<p class="copyable">Hulhangu (the South-West Monsoon) has eighteen Nakaiy and runs from April 8 to December 9. The word Hulhangu has its etymological root in the Sinhala word Hulanga meaning "wind" alluding to the fact that the Maldives usually experiences strong winds accompanied with stormy weather during this time.</p>' +

'<p class="copyable"><i>"The future has an ancient heart" - Carlo Levi</i></p>'+

'<p  class="copyable" style="font-style:italic;font-size:.8em">Sources of information used in this app:<br />'+
'- Vanavaru by Hassan Ahmed Maniku published 19 March 1989<br />'+
'- Vonadhona Raajje (Rahvehi Kamuge Theyreyrai Dhivehin Part 1) by Ahmed Shafeeq published 1 January 1999</p>'+

"<p  class='copyable' id='intro_credit'>Designed & Developed by: <br />"+
"Shahee Ilyas & Ayeshath Fadwa <br />"+
"Special thanks to Ali Shafee Saeed (Topi) & Lintel Investments and Management Services Pvt. Ltd.<br />"+
"Nakaiy Nevi 1.3 (c) 2011-2014 Shahee Ilyas. This work is licensed under a Creative Commons Attribution-NonCommercial 3.0 Unported License. <br />" +
"For feedback please email shahee@shaheeilyas.com.</p>");
		
		x$(".nakaiy_detail_only").hide()
		x$(".general_detail_only").show()
       	////myScroll.goToPage(2, 0, 200);
       	x$('#listview').hide();
		x$('#detailview').show();
		myScroll.refresh();
		myScroll.scrollTo(0,0);

	})
	//x$("#introduction").swipe({swipeLeft:function(){x$(this).fire('click');}});
	x$("#introduction").swipe({click:function(){x$(this).fire('click');}});

	
	x$("#li_associate").click(function(e){
		x$("#general_detail_content").html(
		'<h3>Le Cute</h3>'+
		'<img id="intro_img" alt="guide" src="app/images/lecute/lecute_pic.jpg" />'+

		'<p class="copyable">	Le Cute, opened in November 1990 is a well-recognized retail brand in Maldives that has expanded over the years. Le Cute presently has 6 outlets nationwide under its brand name in the avenues of travel retail, downtown retail and resort boutiques.</p>'+
		'<p class="copyable">Lintel Investments and Management Services Pvt. Ltd, the parent company of Le Cute is a wholly Maldivian-owned company registered and operating in the Maldives since 1989 as one of the country’s leading distributors of luxury fashion, beauty and lifestyle electronics brands.</p>'+
		'<p class="copyable">Lintel continues to provide its customers with unprecedented quality and service excellence under the longstanding slogan of “Quality Most Compare”. Lintel is a retail leader who has continued to persistently reinvent the retail experience in Maldives.</p>'+
		'<p class="copyable">Lintel is determined to be a good corporate citizen, being fully conscious of its responsibility and accountability to Maldives and its people. Hence, Lintel believes that our heritage and culture needs to be continued for our future generations. In this belief, Lintel supports “Nakaiy Nevi” – a smartphone app developed with the intention of connecting modern Maldivians to our roots.</p>'
		);
		x$(".nakaiy_detail_only").hide()
		x$(".general_detail_only").show()
       	////myScroll.goToPage(2, 0, 200);
       	 x$('#listview').hide();
		x$('#detailview').show();
		myScroll.refresh()
		myScroll.scrollTo(0,0);
	})
//	x$("#li_associate").swipe({swipeLeft:function(){x$(this).fire('click');}});
	x$("#li_associate").swipe({click:function(){x$(this).fire('click');}});

	

}

